/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: EVThermalManagement_AMPC_2020b.c
 *
 * Code generated for Simulink model 'EVThermalManagement_AMPC_2020b'.
 *
 * Model version                  : 1.11
 * Simulink Coder version         : 9.4 (R2020b) 29-Jul-2020
 * C/C++ source code generated on : Tue Oct 15 12:58:56 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Custom Processor->Custom Processor
 * Code generation objectives:
 *    1. Execution efficiency
 *    2. RAM efficiency
 * Validation result: Not run
 */

#include "EVThermalManagement_AMPC_2020b.h"

/* Named constants for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
#define RYscale                        (0.1)
#define Yscale                         (10.0)
#define nu                             (1.0)
#define ny                             (1.0)
#define uoff                           (0.0)
#define yoff                           (2.6)
#define NumBitsPerChar                 8U

/* Private macros used by the generated code to access rtModel */
#ifndef rtmIsMajorTimeStep
#define rtmIsMajorTimeStep(rtm)        (((rtm)->Timing.simTimeStep) == MAJOR_TIME_STEP)
#endif

#ifndef rtmIsMinorTimeStep
#define rtmIsMinorTimeStep(rtm)        (((rtm)->Timing.simTimeStep) == MINOR_TIME_STEP)
#endif

#ifndef rtmSetTPtr
#define rtmSetTPtr(rtm, val)           ((rtm)->Timing.t = (val))
#endif

/* Used by FromWorkspace Block: '<S20>/From Workspace1' */
#ifndef rtInterpolate
# define rtInterpolate(v1,v2,f1,f2)    (((v1)==(v2))?((double)(v1)): (((f1)*((double)(v1)))+((f2)*((double)(v2)))))
#endif

#ifndef rtRound
# define rtRound(v)                    ( ((v) >= 0) ? floor((v) + 0.5) : ceil((v) - 0.5) )
#endif

/* Continuous states */
X rtX;

/* Block signals and states (default storage) */
DW rtDW;

/* Mass Matrices */
MassMatrix rtMassMatrix;

/* Real-time model */
static RT_MODEL rtM_;
RT_MODEL *const rtM = &rtM_;
extern real_T rt_powd_snf(real_T u0, real_T u1);
extern real_T rt_roundd_snf(real_T u);
extern real_T rt_hypotd_snf(real_T u0, real_T u1);
static real_T look1_plinlx(real_T u0, const real_T bp0[], const real_T table[],
  uint32_T prevIndex[], uint32_T maxIndex);
static real_T look2_binlx(real_T u0, real_T u1, const real_T bp0[], const real_T
  bp1[], const real_T table[], const uint32_T maxIndex[], uint32_T stride);

/* private model entry point functions */
extern void EVThermalManagement_AMPC_2020b_derivatives(void);

/* Forward declaration for local functions */
static real_T PadeApproximantOfDegree(real_T A, uint8_T m);
static real_T expmNoLog2(real_T A);
static void mpc_constraintcoef(real_T b_A, real_T Bu, const real_T Bv[3], real_T
  b_C, const real_T Dv[3], const real_T b_Jm[36], real_T b_SuJm[36], real_T
  b_Sx[9], real_T b_Su1[9], real_T b_Hv[270]);
static void WtMult(const real_T W[9], const real_T M[36], real_T nwt, real_T WM
                   [36]);
static int32_T xpotrf(real_T b_A[25]);
static real_T minimum(const real_T x[5]);
static void mpc_checkhessian(real_T b_H[25], real_T L[25], real_T *BadH);
static void trisolve(const real_T b_A[25], real_T b_B[25]);
static void Unconstrained(const real_T b_Hinv[25], const real_T f_3[5], real_T
  x[5], int16_T n_4);
static real_T norm(const real_T x[5]);
static void abs_a(const real_T x[5], real_T y[5]);
static real_T maximum(const real_T x[5]);
static void abs_am(const real_T x[34], real_T y[34]);
static void maximum2(const real_T x[34], real_T y, real_T ex[34]);
static real_T xnrm2(int32_T n_0, const real_T x[25], int32_T ix0);
static void xgemv(int32_T b_m, int32_T n_2, const real_T b_A[25], int32_T ia0,
                  const real_T x[25], int32_T ix0, real_T y[5]);
static void xgerc(int32_T b_m, int32_T n_3, real_T alpha1, int32_T ix0, const
                  real_T y[5], real_T b_A[25], int32_T ia0);
static void qr(const real_T b_A[25], real_T Q[25], real_T R[25]);
static real_T KWIKfactor(const real_T b_Ac[170], const int16_T iC[34], int16_T
  nA, const real_T b_Linv[25], real_T RLinv[25], real_T b_D[25], real_T b_H[25],
  int16_T n_1);
static real_T mtimes(const real_T b_A[5], const real_T b_B[5]);
static void DropConstraint(int16_T kDrop, int16_T iA[34], int16_T *nA, int16_T
  iC[34]);
static void qpkwik(const real_T b_Linv[25], const real_T b_Hinv[25], const
                   real_T f_2[5], const real_T b_Ac[170], const real_T b[34],
                   int16_T iA[34], int16_T maxiter, real_T FeasTol, real_T x[5],
                   real_T lambda[34], real_T *status);
static void mpc_solveQP(real_T xQP, const real_T b_Kx[4], const real_T b_Kr[36],
  const real_T rseq[9], const real_T b_Ku1[4], real_T old_u, const real_T b_Kv
  [120], const real_T vseq[30], const real_T b_Kut[36], const real_T b_utarget[9],
  const real_T b_Linv[25], const real_T b_Hinv[25], const real_T b_Ac[170],
  const real_T Bc[34], boolean_T iA[34], real_T zopt[5], real_T f_1[5], real_T
  *status);
static void mpcblock_optimizer(const real_T rseq[9], const real_T vseq[30],
  real_T x, real_T old_u, const boolean_T iA[34], const real_T b_Mlim[34],
  real_T b_Mx[34], real_T b_Mu1[34], real_T b_Mv[1020], const real_T b_utarget[9],
  real_T b_uoff, real_T b_H[25], real_T b_Ac[170], const real_T b_Wy[9], const
  real_T b_Wdu[9], const real_T b_Jm[36], const real_T b_Wu[9], const real_T
  b_I1[9], real_T b_A, const real_T Bu[10], const real_T Bv[30], real_T b_C,
  const real_T Dv[30], const real_T b_Mrows_0[34], real_T *u, real_T useq[10],
  real_T *status, boolean_T iAout[34]);
static real_T rtGetInf(void);
static real32_T rtGetInfF(void);
static real_T rtGetMinusInf(void);
static real32_T rtGetMinusInfF(void);
static real_T rtGetNaN(void);
static real32_T rtGetNaNF(void);
extern real_T rtInf;
extern real_T rtMinusInf;
extern real_T rtNaN;
extern real32_T rtInfF;
extern real32_T rtMinusInfF;
extern real32_T rtNaNF;
static void rt_InitInfAndNaN(size_t realSize);
static boolean_T rtIsInf(real_T value);
static boolean_T rtIsInfF(real32_T value);
static boolean_T rtIsNaN(real_T value);
static boolean_T rtIsNaNF(real32_T value);
typedef struct {
  struct {
    uint32_T wordH;
    uint32_T wordL;
  } words;
} BigEndianIEEEDouble;

typedef struct {
  struct {
    uint32_T wordL;
    uint32_T wordH;
  } words;
} LittleEndianIEEEDouble;

typedef struct {
  union {
    real32_T wordLreal;
    uint32_T wordLuint;
  } wordL;
} IEEESingle;

real_T rtInf;
real_T rtMinusInf;
real_T rtNaN;
real32_T rtInfF;
real32_T rtMinusInfF;
real32_T rtNaNF;

/*
 * Initialize rtInf needed by the generated code.
 * Inf is initialized as non-signaling. Assumes IEEE.
 */
static real_T rtGetInf(void)
{
  size_t bitsPerReal = sizeof(real_T) * (NumBitsPerChar);
  real_T inf = 0.0;
  if (bitsPerReal == 32U) {
    inf = rtGetInfF();
  } else {
    union {
      LittleEndianIEEEDouble bitVal;
      real_T fltVal;
    } tmpVal;

    tmpVal.bitVal.words.wordH = 0x7FF00000U;
    tmpVal.bitVal.words.wordL = 0x00000000U;
    inf = tmpVal.fltVal;
  }

  return inf;
}

/*
 * Initialize rtInfF needed by the generated code.
 * Inf is initialized as non-signaling. Assumes IEEE.
 */
static real32_T rtGetInfF(void)
{
  IEEESingle infF;
  infF.wordL.wordLuint = 0x7F800000U;
  return infF.wordL.wordLreal;
}

/*
 * Initialize rtMinusInf needed by the generated code.
 * Inf is initialized as non-signaling. Assumes IEEE.
 */
static real_T rtGetMinusInf(void)
{
  size_t bitsPerReal = sizeof(real_T) * (NumBitsPerChar);
  real_T minf = 0.0;
  if (bitsPerReal == 32U) {
    minf = rtGetMinusInfF();
  } else {
    union {
      LittleEndianIEEEDouble bitVal;
      real_T fltVal;
    } tmpVal;

    tmpVal.bitVal.words.wordH = 0xFFF00000U;
    tmpVal.bitVal.words.wordL = 0x00000000U;
    minf = tmpVal.fltVal;
  }

  return minf;
}

/*
 * Initialize rtMinusInfF needed by the generated code.
 * Inf is initialized as non-signaling. Assumes IEEE.
 */
static real32_T rtGetMinusInfF(void)
{
  IEEESingle minfF;
  minfF.wordL.wordLuint = 0xFF800000U;
  return minfF.wordL.wordLreal;
}

/*
 * Initialize rtNaN needed by the generated code.
 * NaN is initialized as non-signaling. Assumes IEEE.
 */
static real_T rtGetNaN(void)
{
  size_t bitsPerReal = sizeof(real_T) * (NumBitsPerChar);
  real_T nan = 0.0;
  if (bitsPerReal == 32U) {
    nan = rtGetNaNF();
  } else {
    union {
      LittleEndianIEEEDouble bitVal;
      real_T fltVal;
    } tmpVal;

    tmpVal.bitVal.words.wordH = 0xFFF80000U;
    tmpVal.bitVal.words.wordL = 0x00000000U;
    nan = tmpVal.fltVal;
  }

  return nan;
}

/*
 * Initialize rtNaNF needed by the generated code.
 * NaN is initialized as non-signaling. Assumes IEEE.
 */
static real32_T rtGetNaNF(void)
{
  IEEESingle nanF = { { 0 } };

  nanF.wordL.wordLuint = 0xFFC00000U;
  return nanF.wordL.wordLreal;
}

/*
 * Initialize the rtInf, rtMinusInf, and rtNaN needed by the
 * generated code. NaN is initialized as non-signaling. Assumes IEEE.
 */
static void rt_InitInfAndNaN(size_t realSize)
{
  (void) (realSize);
  rtNaN = rtGetNaN();
  rtNaNF = rtGetNaNF();
  rtInf = rtGetInf();
  rtInfF = rtGetInfF();
  rtMinusInf = rtGetMinusInf();
  rtMinusInfF = rtGetMinusInfF();
}

/* Test if value is infinite */
static boolean_T rtIsInf(real_T value)
{
  return (boolean_T)((value==rtInf || value==rtMinusInf) ? 1U : 0U);
}

/* Test if single-precision value is infinite */
static boolean_T rtIsInfF(real32_T value)
{
  return (boolean_T)(((value)==rtInfF || (value)==rtMinusInfF) ? 1U : 0U);
}

/* Test if value is not a number */
static boolean_T rtIsNaN(real_T value)
{
  boolean_T result = (boolean_T) 0;
  size_t bitsPerReal = sizeof(real_T) * (NumBitsPerChar);
  if (bitsPerReal == 32U) {
    result = rtIsNaNF((real32_T)value);
  } else {
    union {
      LittleEndianIEEEDouble bitVal;
      real_T fltVal;
    } tmpVal;

    tmpVal.fltVal = value;
    result = (boolean_T)((tmpVal.bitVal.words.wordH & 0x7FF00000) == 0x7FF00000 &&
                         ( (tmpVal.bitVal.words.wordH & 0x000FFFFF) != 0 ||
                          (tmpVal.bitVal.words.wordL != 0) ));
  }

  return result;
}

/* Test if single-precision value is not a number */
static boolean_T rtIsNaNF(real32_T value)
{
  IEEESingle tmp;
  tmp.wordL.wordLreal = value;
  return (boolean_T)( (tmp.wordL.wordLuint & 0x7F800000) == 0x7F800000 &&
                     (tmp.wordL.wordLuint & 0x007FFFFF) != 0 );
}

static real_T look1_plinlx(real_T u0, const real_T bp0[], const real_T table[],
  uint32_T prevIndex[], uint32_T maxIndex)
{
  real_T frac;
  real_T yL_0d0;
  uint32_T startIndex;

  /* Column-major Lookup 1-D
     Search method: 'linear'
     Use previous index: 'on'
     Interpolation method: 'Linear point-slope'
     Extrapolation method: 'Linear'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'linear'
     Extrapolation method: 'Linear'
     Use previous index: 'on'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  if (u0 <= bp0[0U]) {
    startIndex = 0U;
    frac = (u0 - bp0[0U]) / (bp0[1U] - bp0[0U]);
  } else if (u0 < bp0[maxIndex]) {
    /* Linear Search */
    for (startIndex = prevIndex[0U]; u0 < bp0[startIndex]; startIndex--) {
    }

    while (u0 >= bp0[startIndex + 1U]) {
      startIndex++;
    }

    frac = (u0 - bp0[startIndex]) / (bp0[startIndex + 1U] - bp0[startIndex]);
  } else {
    startIndex = maxIndex - 1U;
    frac = (u0 - bp0[maxIndex - 1U]) / (bp0[maxIndex] - bp0[maxIndex - 1U]);
  }

  prevIndex[0U] = startIndex;

  /* Column-major Interpolation 1-D
     Interpolation method: 'Linear point-slope'
     Use last breakpoint for index at or above upper limit: 'off'
     Overflow mode: 'wrapping'
   */
  yL_0d0 = table[startIndex];
  return (table[startIndex + 1U] - yL_0d0) * frac + yL_0d0;
}

static real_T look2_binlx(real_T u0, real_T u1, const real_T bp0[], const real_T
  bp1[], const real_T table[], const uint32_T maxIndex[], uint32_T stride)
{
  real_T fractions[2];
  real_T frac;
  real_T yL_0d0;
  real_T yL_0d1;
  uint32_T bpIndices[2];
  uint32_T bpIdx;
  uint32_T iLeft;
  uint32_T iRght;

  /* Column-major Lookup 2-D
     Search method: 'binary'
     Use previous index: 'off'
     Interpolation method: 'Linear point-slope'
     Extrapolation method: 'Linear'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Linear'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  if (u0 <= bp0[0U]) {
    iLeft = 0U;
    frac = (u0 - bp0[0U]) / (bp0[1U] - bp0[0U]);
  } else if (u0 < bp0[maxIndex[0U]]) {
    /* Binary Search */
    bpIdx = maxIndex[0U] >> 1U;
    iLeft = 0U;
    iRght = maxIndex[0U];
    while (iRght - iLeft > 1U) {
      if (u0 < bp0[bpIdx]) {
        iRght = bpIdx;
      } else {
        iLeft = bpIdx;
      }

      bpIdx = (iRght + iLeft) >> 1U;
    }

    frac = (u0 - bp0[iLeft]) / (bp0[iLeft + 1U] - bp0[iLeft]);
  } else {
    iLeft = maxIndex[0U] - 1U;
    frac = (u0 - bp0[maxIndex[0U] - 1U]) / (bp0[maxIndex[0U]] - bp0[maxIndex[0U]
      - 1U]);
  }

  fractions[0U] = frac;
  bpIndices[0U] = iLeft;

  /* Prelookup - Index and Fraction
     Index Search method: 'binary'
     Extrapolation method: 'Linear'
     Use previous index: 'off'
     Use last breakpoint for index at or above upper limit: 'off'
     Remove protection against out-of-range input in generated code: 'off'
   */
  if (u1 <= bp1[0U]) {
    iLeft = 0U;
    frac = (u1 - bp1[0U]) / (bp1[1U] - bp1[0U]);
  } else if (u1 < bp1[maxIndex[1U]]) {
    /* Binary Search */
    bpIdx = maxIndex[1U] >> 1U;
    iLeft = 0U;
    iRght = maxIndex[1U];
    while (iRght - iLeft > 1U) {
      if (u1 < bp1[bpIdx]) {
        iRght = bpIdx;
      } else {
        iLeft = bpIdx;
      }

      bpIdx = (iRght + iLeft) >> 1U;
    }

    frac = (u1 - bp1[iLeft]) / (bp1[iLeft + 1U] - bp1[iLeft]);
  } else {
    iLeft = maxIndex[1U] - 1U;
    frac = (u1 - bp1[maxIndex[1U] - 1U]) / (bp1[maxIndex[1U]] - bp1[maxIndex[1U]
      - 1U]);
  }

  /* Column-major Interpolation 2-D
     Interpolation method: 'Linear point-slope'
     Use last breakpoint for index at or above upper limit: 'off'
     Overflow mode: 'wrapping'
   */
  bpIdx = iLeft * stride + bpIndices[0U];
  yL_0d0 = table[bpIdx];
  yL_0d0 += (table[bpIdx + 1U] - yL_0d0) * fractions[0U];
  bpIdx += stride;
  yL_0d1 = table[bpIdx];
  return (((table[bpIdx + 1U] - yL_0d1) * fractions[0U] + yL_0d1) - yL_0d0) *
    frac + yL_0d0;
}

/* ForcingFunction for root system: '<Root>' */
void EVThermalManagement_AMPC_2020b_forcingfunction(void)
{
  NeslSimulationData *simulationData;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  XDot *_rtXdot;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  int_T tmp_1[25];
  int_T is;
  boolean_T tmp;
  _rtXdot = ((XDot *) rtM->derivs);

  /* ForcingFunction for TransferFcn: '<S377>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE = 0.0;
  _rtXdot->TransferFcn_CSTATE += -rtX.TransferFcn_CSTATE;
  _rtXdot->TransferFcn_CSTATE += rtDW.Saturation_a;

  /* ForcingFunction for TransferFcn: '<S1>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_b = 0.0;
  _rtXdot->TransferFcn_CSTATE_b += -rtX.TransferFcn_CSTATE_b;
  _rtXdot->TransferFcn_CSTATE_b += rtDW.iBMScomputation;

  /* ForcingFunction for TransferFcn: '<S2>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_j = 0.0;
  _rtXdot->TransferFcn_CSTATE_j += -0.2 * rtX.TransferFcn_CSTATE_j;
  _rtXdot->TransferFcn_CSTATE_j += rtDW.Switch_k;

  /* ForcingFunction for TransferFcn: '<S5>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_n = 0.0;
  _rtXdot->TransferFcn_CSTATE_n += -rtX.TransferFcn_CSTATE_n;

  /* ForcingFunction for TransferFcn: '<S7>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_f = 0.0;
  _rtXdot->TransferFcn_CSTATE_f += -0.2 * rtX.TransferFcn_CSTATE_f;
  _rtXdot->TransferFcn_CSTATE_f += rtDW.Saturation_c;

  /* ForcingFunction for TransferFcn: '<S8>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_jk = 0.0;
  _rtXdot->TransferFcn_CSTATE_jk += -0.2 * rtX.TransferFcn_CSTATE_jk;
  _rtXdot->TransferFcn_CSTATE_jk += rtDW.uDLookupTable;

  /* ForcingFunction for TransferFcn: '<S16>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_p = 0.0;
  _rtXdot->TransferFcn_CSTATE_p += -0.2 * rtX.TransferFcn_CSTATE_p;
  _rtXdot->TransferFcn_CSTATE_p += rtDW.Saturation;

  /* ForcingFunction for TransferFcn: '<S17>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_pv = 0.0;
  _rtXdot->TransferFcn_CSTATE_pv += -rtX.TransferFcn_CSTATE_pv;
  _rtXdot->TransferFcn_CSTATE_pv += rtDW.Switch_l;

  /* ForcingFunction for TransferFcn: '<S19>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_nf = 0.0;
  _rtXdot->TransferFcn_CSTATE_nf += -rtX.TransferFcn_CSTATE_nf;
  _rtXdot->TransferFcn_CSTATE_nf += rtDW.Relay;

  /* ForcingFunction for SimscapeExecutionBlock: '<S380>/STATE_1' */
  simulationData = (NeslSimulationData *)rtDW.STATE_1_SimData;
  time = rtM->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 631;
  simulationData->mData->mContStates.mX = &rtX.EVThermalManagement_AMPC_2020bB[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 393;
  simulationData->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep(rtM);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = rtDW.INPUT_1_1_1[0];
  tmp_0[1] = rtDW.INPUT_1_1_1[1];
  tmp_0[2] = rtDW.INPUT_1_1_1[2];
  tmp_0[3] = rtDW.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = rtDW.INPUT_2_1_1[0];
  tmp_0[5] = rtDW.INPUT_2_1_1[1];
  tmp_0[6] = rtDW.INPUT_2_1_1[2];
  tmp_0[7] = rtDW.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = rtDW.INPUT_3_1_1[0];
  tmp_0[9] = rtDW.INPUT_3_1_1[1];
  tmp_0[10] = rtDW.INPUT_3_1_1[2];
  tmp_0[11] = rtDW.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = rtDW.INPUT_4_1_1[0];
  tmp_0[13] = rtDW.INPUT_4_1_1[1];
  tmp_0[14] = rtDW.INPUT_4_1_1[2];
  tmp_0[15] = rtDW.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = rtDW.INPUT_5_1_1[0];
  tmp_0[17] = rtDW.INPUT_5_1_1[1];
  tmp_0[18] = rtDW.INPUT_5_1_1[2];
  tmp_0[19] = rtDW.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = rtDW.INPUT_6_1_1[0];
  tmp_0[21] = rtDW.INPUT_6_1_1[1];
  tmp_0[22] = rtDW.INPUT_6_1_1[2];
  tmp_0[23] = rtDW.INPUT_6_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = rtDW.INPUT_10_1_1[0];
  tmp_0[25] = rtDW.INPUT_10_1_1[1];
  tmp_0[26] = rtDW.INPUT_10_1_1[2];
  tmp_0[27] = rtDW.INPUT_10_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = rtDW.INPUT_8_1_1[0];
  tmp_0[29] = rtDW.INPUT_8_1_1[1];
  tmp_0[30] = rtDW.INPUT_8_1_1[2];
  tmp_0[31] = rtDW.INPUT_8_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = rtDW.INPUT_7_1_1[0];
  tmp_0[33] = rtDW.INPUT_7_1_1[1];
  tmp_0[34] = rtDW.INPUT_7_1_1[2];
  tmp_0[35] = rtDW.INPUT_7_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = rtDW.INPUT_9_1_1[0];
  tmp_0[37] = rtDW.INPUT_9_1_1[1];
  tmp_0[38] = rtDW.INPUT_9_1_1[2];
  tmp_0[39] = rtDW.INPUT_9_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = rtDW.INPUT_11_1_1[0];
  tmp_0[41] = rtDW.INPUT_11_1_1[1];
  tmp_0[42] = rtDW.INPUT_11_1_1[2];
  tmp_0[43] = rtDW.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = rtDW.INPUT_12_1_1[0];
  tmp_0[45] = rtDW.INPUT_12_1_1[1];
  tmp_0[46] = rtDW.INPUT_12_1_1[2];
  tmp_0[47] = rtDW.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = rtDW.INPUT_13_1_1[0];
  tmp_0[49] = rtDW.INPUT_13_1_1[1];
  tmp_0[50] = rtDW.INPUT_13_1_1[2];
  tmp_0[51] = rtDW.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = rtDW.INPUT_14_1_1[0];
  tmp_0[53] = rtDW.INPUT_14_1_1[1];
  tmp_0[54] = rtDW.INPUT_14_1_1[2];
  tmp_0[55] = rtDW.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = rtDW.INPUT_15_1_1[0];
  tmp_0[57] = rtDW.INPUT_15_1_1[1];
  tmp_0[58] = rtDW.INPUT_15_1_1[2];
  tmp_0[59] = rtDW.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = rtDW.INPUT_16_1_1[0];
  tmp_0[61] = rtDW.INPUT_16_1_1[1];
  tmp_0[62] = rtDW.INPUT_16_1_1[2];
  tmp_0[63] = rtDW.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = rtDW.INPUT_17_1_1[0];
  tmp_0[65] = rtDW.INPUT_17_1_1[1];
  tmp_0[66] = rtDW.INPUT_17_1_1[2];
  tmp_0[67] = rtDW.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = rtDW.INPUT_18_1_1[0];
  tmp_0[69] = rtDW.INPUT_18_1_1[1];
  tmp_0[70] = rtDW.INPUT_18_1_1[2];
  tmp_0[71] = rtDW.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = rtDW.INPUT_22_1_1[0];
  tmp_0[73] = rtDW.INPUT_22_1_1[1];
  tmp_0[74] = rtDW.INPUT_22_1_1[2];
  tmp_0[75] = rtDW.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = rtDW.INPUT_20_1_1[0];
  tmp_0[77] = rtDW.INPUT_20_1_1[1];
  tmp_0[78] = rtDW.INPUT_20_1_1[2];
  tmp_0[79] = rtDW.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = rtDW.INPUT_19_1_1[0];
  tmp_0[81] = rtDW.INPUT_19_1_1[1];
  tmp_0[82] = rtDW.INPUT_19_1_1[2];
  tmp_0[83] = rtDW.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = rtDW.INPUT_21_1_1[0];
  tmp_0[85] = rtDW.INPUT_21_1_1[1];
  tmp_0[86] = rtDW.INPUT_21_1_1[2];
  tmp_0[87] = rtDW.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = rtDW.INPUT_23_1_1[0];
  tmp_0[89] = rtDW.INPUT_23_1_1[1];
  tmp_0[90] = rtDW.INPUT_23_1_1[2];
  tmp_0[91] = rtDW.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = rtDW.INPUT_24_1_1[0];
  tmp_0[93] = rtDW.INPUT_24_1_1[1];
  tmp_0[94] = rtDW.INPUT_24_1_1[2];
  tmp_0[95] = rtDW.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulationData->mData->mDx.mN = 631;
  simulationData->mData->mDx.mX = &_rtXdot->EVThermalManagement_AMPC_2020bB[0];
  diagnosticManager = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  is = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
    NESL_SIM_FORCINGFUNCTION, simulationData, diagnosticManager);
  if (is != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(rtM, msg);
    }
  }

  /* End of ForcingFunction for SimscapeExecutionBlock: '<S380>/STATE_1' */

  /* ForcingFunction for TransferFcn: '<S377>/Transfer Fcn3' */
  _rtXdot->TransferFcn3_CSTATE = 0.0;
  _rtXdot->TransferFcn3_CSTATE += -rtX.TransferFcn3_CSTATE;
  _rtXdot->TransferFcn3_CSTATE += rtDW.ChargerHeatvsCurrent;

  /* ForcingFunction for TransferFcn: '<S377>/Transfer Fcn4' */
  _rtXdot->TransferFcn4_CSTATE = 0.0;
  _rtXdot->TransferFcn4_CSTATE += -rtX.TransferFcn4_CSTATE;
  _rtXdot->TransferFcn4_CSTATE += rtDW.DCDCHeatvsCurrent;

  /* ForcingFunction for TransferFcn: '<S11>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_fj = 0.0;
  _rtXdot->TransferFcn_CSTATE_fj += -rtX.TransferFcn_CSTATE_fj;
  _rtXdot->TransferFcn_CSTATE_fj += rtDW.Switch_j;

  /* ForcingFunction for TransferFcn: '<S377>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE = 0.0;
  _rtXdot->TransferFcn1_CSTATE += -rtX.TransferFcn1_CSTATE;
  _rtXdot->TransferFcn1_CSTATE += rtDW.InverterHeatvsCurrent;

  /* ForcingFunction for TransferFcn: '<S377>/Transfer Fcn2' */
  _rtXdot->TransferFcn2_CSTATE = 0.0;
  _rtXdot->TransferFcn2_CSTATE += -rtX.TransferFcn2_CSTATE;
  _rtXdot->TransferFcn2_CSTATE += rtDW.MotorHeatvsCurrent;

  /* ForcingFunction for TransferFcn: '<S7>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE_e = 0.0;
  _rtXdot->TransferFcn1_CSTATE_e += -0.25 * rtX.TransferFcn1_CSTATE_e;
  _rtXdot->TransferFcn1_CSTATE_e += rtDW.Divide;

  /* ForcingFunction for TransferFcn: '<S273>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_o = 0.0;
  _rtXdot->TransferFcn_CSTATE_o += -100.0 * rtX.TransferFcn_CSTATE_o;
  _rtXdot->TransferFcn_CSTATE_o += rtDW.EPower_Compressor;

  /* ForcingFunction for Integrator: '<S12>/Integrator' */
  _rtXdot->Integrator_CSTATE = rtDW.Gain_n;

  /* ForcingFunction for Integrator: '<S379>/Integrator' */
  _rtXdot->Integrator_CSTATE_h = rtDW.Sum;

  /* ForcingFunction for Integrator: '<S340>/Integrator' */
  _rtXdot->Integrator_CSTATE_l = rtDW.Gain_j;

  /* ForcingFunction for Integrator: '<S341>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = rtDW.EPower_BTM;

  /* ForcingFunction for Integrator: '<S341>/Integrator' */
  _rtXdot->Integrator_CSTATE_g = rtDW.EPower_battery;

  /* ForcingFunction for Integrator: '<S343>/Integrator2' incorporates:
   *  Constant: '<S343>/Constant'
   */
  _rtXdot->Integrator2_CSTATE = 0.0;

  /* ForcingFunction for Integrator: '<S343>/Integrator' */
  _rtXdot->Integrator_CSTATE_m = rtDW.EPower_Compressor;
}

/* MassMatrix for root system: '<Root>' */
void EVThermalManagement_AMPC_2020b_massmatrix(void)
{
  NeslSimulationData *simulationData;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  real_T *tmp_2;
  int32_T tmp_3;
  int_T tmp_1[25];
  boolean_T tmp;

  /* MassMatrix for SimscapeExecutionBlock: '<S380>/STATE_1' */
  simulationData = (NeslSimulationData *)rtDW.STATE_1_SimData;
  time = rtM->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 631;
  simulationData->mData->mContStates.mX = &rtX.EVThermalManagement_AMPC_2020bB[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 393;
  simulationData->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep(rtM);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = rtDW.INPUT_1_1_1[0];
  tmp_0[1] = rtDW.INPUT_1_1_1[1];
  tmp_0[2] = rtDW.INPUT_1_1_1[2];
  tmp_0[3] = rtDW.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = rtDW.INPUT_2_1_1[0];
  tmp_0[5] = rtDW.INPUT_2_1_1[1];
  tmp_0[6] = rtDW.INPUT_2_1_1[2];
  tmp_0[7] = rtDW.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = rtDW.INPUT_3_1_1[0];
  tmp_0[9] = rtDW.INPUT_3_1_1[1];
  tmp_0[10] = rtDW.INPUT_3_1_1[2];
  tmp_0[11] = rtDW.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = rtDW.INPUT_4_1_1[0];
  tmp_0[13] = rtDW.INPUT_4_1_1[1];
  tmp_0[14] = rtDW.INPUT_4_1_1[2];
  tmp_0[15] = rtDW.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = rtDW.INPUT_5_1_1[0];
  tmp_0[17] = rtDW.INPUT_5_1_1[1];
  tmp_0[18] = rtDW.INPUT_5_1_1[2];
  tmp_0[19] = rtDW.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = rtDW.INPUT_6_1_1[0];
  tmp_0[21] = rtDW.INPUT_6_1_1[1];
  tmp_0[22] = rtDW.INPUT_6_1_1[2];
  tmp_0[23] = rtDW.INPUT_6_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = rtDW.INPUT_10_1_1[0];
  tmp_0[25] = rtDW.INPUT_10_1_1[1];
  tmp_0[26] = rtDW.INPUT_10_1_1[2];
  tmp_0[27] = rtDW.INPUT_10_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = rtDW.INPUT_8_1_1[0];
  tmp_0[29] = rtDW.INPUT_8_1_1[1];
  tmp_0[30] = rtDW.INPUT_8_1_1[2];
  tmp_0[31] = rtDW.INPUT_8_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = rtDW.INPUT_7_1_1[0];
  tmp_0[33] = rtDW.INPUT_7_1_1[1];
  tmp_0[34] = rtDW.INPUT_7_1_1[2];
  tmp_0[35] = rtDW.INPUT_7_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = rtDW.INPUT_9_1_1[0];
  tmp_0[37] = rtDW.INPUT_9_1_1[1];
  tmp_0[38] = rtDW.INPUT_9_1_1[2];
  tmp_0[39] = rtDW.INPUT_9_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = rtDW.INPUT_11_1_1[0];
  tmp_0[41] = rtDW.INPUT_11_1_1[1];
  tmp_0[42] = rtDW.INPUT_11_1_1[2];
  tmp_0[43] = rtDW.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = rtDW.INPUT_12_1_1[0];
  tmp_0[45] = rtDW.INPUT_12_1_1[1];
  tmp_0[46] = rtDW.INPUT_12_1_1[2];
  tmp_0[47] = rtDW.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = rtDW.INPUT_13_1_1[0];
  tmp_0[49] = rtDW.INPUT_13_1_1[1];
  tmp_0[50] = rtDW.INPUT_13_1_1[2];
  tmp_0[51] = rtDW.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = rtDW.INPUT_14_1_1[0];
  tmp_0[53] = rtDW.INPUT_14_1_1[1];
  tmp_0[54] = rtDW.INPUT_14_1_1[2];
  tmp_0[55] = rtDW.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = rtDW.INPUT_15_1_1[0];
  tmp_0[57] = rtDW.INPUT_15_1_1[1];
  tmp_0[58] = rtDW.INPUT_15_1_1[2];
  tmp_0[59] = rtDW.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = rtDW.INPUT_16_1_1[0];
  tmp_0[61] = rtDW.INPUT_16_1_1[1];
  tmp_0[62] = rtDW.INPUT_16_1_1[2];
  tmp_0[63] = rtDW.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = rtDW.INPUT_17_1_1[0];
  tmp_0[65] = rtDW.INPUT_17_1_1[1];
  tmp_0[66] = rtDW.INPUT_17_1_1[2];
  tmp_0[67] = rtDW.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = rtDW.INPUT_18_1_1[0];
  tmp_0[69] = rtDW.INPUT_18_1_1[1];
  tmp_0[70] = rtDW.INPUT_18_1_1[2];
  tmp_0[71] = rtDW.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = rtDW.INPUT_22_1_1[0];
  tmp_0[73] = rtDW.INPUT_22_1_1[1];
  tmp_0[74] = rtDW.INPUT_22_1_1[2];
  tmp_0[75] = rtDW.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = rtDW.INPUT_20_1_1[0];
  tmp_0[77] = rtDW.INPUT_20_1_1[1];
  tmp_0[78] = rtDW.INPUT_20_1_1[2];
  tmp_0[79] = rtDW.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = rtDW.INPUT_19_1_1[0];
  tmp_0[81] = rtDW.INPUT_19_1_1[1];
  tmp_0[82] = rtDW.INPUT_19_1_1[2];
  tmp_0[83] = rtDW.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = rtDW.INPUT_21_1_1[0];
  tmp_0[85] = rtDW.INPUT_21_1_1[1];
  tmp_0[86] = rtDW.INPUT_21_1_1[2];
  tmp_0[87] = rtDW.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = rtDW.INPUT_23_1_1[0];
  tmp_0[89] = rtDW.INPUT_23_1_1[1];
  tmp_0[90] = rtDW.INPUT_23_1_1[2];
  tmp_0[91] = rtDW.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = rtDW.INPUT_24_1_1[0];
  tmp_0[93] = rtDW.INPUT_24_1_1[1];
  tmp_0[94] = rtDW.INPUT_24_1_1[2];
  tmp_0[95] = rtDW.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  tmp_2 = rtMassMatrix.pr;
  tmp_2 = double_pointer_shift(tmp_2, rtDW.STATE_1_MASS_MATRIX_PR);
  simulationData->mData->mMassMatrixPr.mN = 134;
  simulationData->mData->mMassMatrixPr.mX = tmp_2;
  diagnosticManager = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  tmp_3 = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
    NESL_SIM_MASSMATRIX, simulationData, diagnosticManager);
  if (tmp_3 != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(rtM, msg);
    }
  }

  /* End of MassMatrix for SimscapeExecutionBlock: '<S380>/STATE_1' */
}

void local_evaluateMassMatrix(RTWSolverInfo *si, real_T *Mdest )
{
  /* Refresh global mass matrix */
  EVThermalManagement_AMPC_2020b_massmatrix();

  /* Copy the mass matrix from system to the destination, if needed. */
  if (Mdest != rtsiGetSolverMassMatrixPr(si)) {
    real_T *Msrc = rtsiGetSolverMassMatrixPr(si);
    int_T nzmax = rtsiGetSolverMassMatrixNzMax(si);
    (void) memcpy(Mdest, Msrc,
                  (uint_T)nzmax*sizeof(real_T));
  }
}

void local_evaluateFminusMv(RTWSolverInfo *si, const real_T *v, real_T *fminusMv
  )
{
  /* Refresh forcing function */
  rtsiSetdX(si,fminusMv);
  EVThermalManagement_AMPC_2020b_forcingfunction();

  /* Refresh global mass matrix */
  EVThermalManagement_AMPC_2020b_massmatrix();

  /* Form f - M*v */
  {
    real_T *elptr = rtsiGetSolverMassMatrixPr(si);
    int_T *iptr = rtsiGetSolverMassMatrixIr(si);
    int_T *jc = rtsiGetSolverMassMatrixJc(si);
    int_T nx = 654;
    int_T col,row;
    for (col = 0; col < nx; col++) {
      for (row = jc[col]; row < jc[col+1]; row++) {
        fminusMv[*iptr++] -= (*v) * (*elptr++);
      }

      v++;
    }
  }
}

/* Simplified version of numjac.cpp, for use with RTW. */
void local_numjac( RTWSolverInfo *si, real_T *y, const real_T *v, const real_T
                  *Fty, real_T *fac, real_T *dFdy )
{
  /* constants */
  real_T THRESH = 1e-6;
  real_T EPS = 2.2e-16;                /* utGetEps(); */
  real_T BL = pow(EPS, 0.75);
  real_T BU = pow(EPS, 0.25);
  real_T FACMIN = pow(EPS, 0.78);
  real_T FACMAX = 0.1;
  int_T nx = 654;
  real_T *x = rtsiGetContStates(si);
  real_T del;
  real_T difmax;
  real_T FdelRowmax;
  real_T temp;
  real_T Fdiff;
  real_T maybe;
  real_T xscale;
  real_T fscale;
  real_T *p;
  int_T rowmax;
  int_T i,j;
  if (x != y)
    (void) memcpy(x, y,
                  (uint_T)nx*sizeof(real_T));
  rtsiSetSolverComputingJacobian(si,true);
  for (p = dFdy, j = 0; j < nx; j++, p += nx) {
    /* Select an increment del for a difference approximation to
       column j of dFdy.  The vector fac accounts for experience
       gained in previous calls to numjac. */
    xscale = fabs(x[j]);
    if (xscale < THRESH)
      xscale = THRESH;
    temp = (x[j] + fac[j]*xscale);
    del = temp - y[j];
    while (del == 0.0) {
      if (fac[j] < FACMAX) {
        fac[j] *= 100.0;
        if (fac[j] > FACMAX)
          fac[j] = FACMAX;
        temp = (x[j] + fac[j]*xscale);
        del = temp - x[j];
      } else {
        del = THRESH;                  /* thresh is nonzero */
        break;
      }
    }

    /* Keep del pointing into region. */
    if (Fty[j] >= 0.0)
      del = fabs(del);
    else
      del = -fabs(del);

    /* Form a difference approximation to column j of dFdy. */
    temp = x[j];
    x[j] += del;
    EVThermalManagement_AMPC_2020b_step0();
    local_evaluateFminusMv(si,v,p );
    x[j] = temp;
    difmax = 0.0;
    rowmax = 0;
    FdelRowmax = p[0];
    temp = 1.0 / del;
    for (i = 0; i < nx; i++) {
      Fdiff = p[i] - Fty[i];
      maybe = fabs(Fdiff);
      if (maybe > difmax) {
        difmax = maybe;
        rowmax = i;
        FdelRowmax = p[i];
      }

      p[i] = temp * Fdiff;
    }

    /* Adjust fac for next call to numjac. */
    if (((FdelRowmax != 0.0) && (Fty[rowmax] != 0.0)) || (difmax == 0.0)) {
      fscale = fabs(FdelRowmax);
      if (fscale < fabs(Fty[rowmax]))
        fscale = fabs(Fty[rowmax]);
      if (difmax <= BL*fscale) {
        /* The difference is small, so increase the increment. */
        fac[j] *= 10.0;
        if (fac[j] > FACMAX)
          fac[j] = FACMAX;
      } else if (difmax > BU*fscale) {
        /* The difference is large, so reduce the increment. */
        fac[j] *= 0.1;
        if (fac[j] < FACMIN)
          fac[j] = FACMIN;
      }
    }
  }

  rtsiSetSolverComputingJacobian(si,false);
}                                      /* end local_numjac */

/*
 * This function updates continuous states using the ODE14x fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  /* Solver Matrices */
  static int_T rt_ODE14x_N[4] = { 12, 8, 6, 4 };

  time_T t0 = rtsiGetT(si);
  time_T t1 = t0;
  time_T h = rtsiGetStepSize(si);
  real_T *x1 = rtsiGetContStates(si);
  int_T order = rtsiGetSolverExtrapolationOrder(si);
  int_T numIter = rtsiGetSolverNumberNewtonIterations(si);
  ODE14X_IntgData *id = (ODE14X_IntgData *)rtsiGetSolverData(si);
  real_T *x0 = id->x0;
  real_T *f0 = id->f0;
  real_T *x1start = id->x1start;
  real_T *f1 = id->f1;
  real_T *Delta = id->Delta;
  real_T *E = id->E;
  real_T *fac = id->fac;
  real_T *dfdx = id->DFDX;
  real_T *W = id->W;
  int_T *pivots = id->pivots;
  real_T *xtmp = id->xtmp;
  real_T *ztmp = id->ztmp;
  int_T *Mpattern_ir = rtsiGetSolverMassMatrixIr(si);
  int_T *Mpattern_jc = rtsiGetSolverMassMatrixJc(si);
  real_T *M = id->M;
  real_T *M1 = id->M1;
  real_T *xdot = id->xdot;
  real_T *Edot = id->Edot;
  real_T *fminusMxdot = id->fminusMxdot;
  int_T col,row,rowidx;
  int_T *N = &(rt_ODE14x_N[0]);
  int_T i,j,k,iter;
  int_T nx = 654;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void) memcpy(x0, x1,
                (uint_T)nx*sizeof(real_T));

  /* Assumes that rtsiSetT and ModelOutputs are up-to-date */
  local_evaluateMassMatrix(si,M );
  rtsiSetdX(si, xdot);
  EVThermalManagement_AMPC_2020b_derivatives();

  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  EVThermalManagement_AMPC_2020b_forcingfunction();

  /* Form fminusMxdot = f(x) - M(x)*xdot, d(fminusMxdot)/dx = df/dx - d(Mv)/dx */
  (void) memcpy(fminusMxdot, f0,
                (uint_T)nx*sizeof(real_T));
  for (col = 0; col < nx; col++) {
    for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
      real_T m_row_col = M[rowidx];
      row = Mpattern_ir[rowidx];
      fminusMxdot[row] -= m_row_col*xdot[col];
    }
  }

  local_numjac(si,x0,xdot,fminusMxdot,fac,dfdx );
  for (j = 0; j < order; j++) {
    real_T *p;
    real_T hN = h/N[j];

    /* Get the iteration matrix and solution at t0 */

    /* [L,U] = lu(M - hN*J) */
    (void) memcpy(W, dfdx,
                  (uint_T)nx*nx*sizeof(real_T));
    for (p = W, i = 0; i < nx*nx; i++, p++) {
      *p *= (-hN);
    }

    for (col = 0, p = W; col < nx; col++, p += nx) {
      for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
        real_T m_row_col = M[rowidx];
        row = Mpattern_ir[rowidx];
        p[row] += m_row_col;
      }
    }

    rt_lu_real(W, nx,
               pivots);

    /* First Newton's iteration at t0. */
    /* rhs = hN*f0 */
    for (i = 0; i < nx; i++) {
      Delta[i] = hN*f0[i];
    }

    /* Delta = (U \ (L \ rhs)) */
    rt_ForwardSubstitutionRR_Dbl(W, Delta,
      f1, nx,
      1, pivots,
      1);
    rt_BackwardSubstitutionRR_Dbl(W+nx*nx-1, f1+nx-1,
      Delta, nx,
      1, 0);

    /* ytmp = y0 + Delta
       ztmp = (ytmp-y0)/h
     */
    (void) memcpy(x1, x0,
                  (uint_T)nx*sizeof(real_T));
    for (i = 0; i < nx; i++) {
      x1[i] += Delta[i];
      ztmp[i] = Delta[i]/hN;
    }

    /* Additional Newton's iterations, if desired.
       for iter = 2:NewtIter
       rhs = hN*feval(odefun,tn,ytmp,extraArgs{:}) - M*(ytmp - yn);
       if statedepM   % only for state dep. Mdel ~= 0
       Mdel = M - feval(massfun,tn,ytmp);
       rhs = rhs + Mdel*ztmp*h;
       end
       Delta = ( U \ ( L \ rhs ) );
       ytmp = ytmp + Delta;
       ztmp = (ytmp - yn)/h
       end
     */
    rtsiSetT(si, t0);
    rtsiSetdX(si, f1);
    for (iter = 1; iter < numIter; iter++) {
      EVThermalManagement_AMPC_2020b_step0();
      EVThermalManagement_AMPC_2020b_forcingfunction();
      for (i = 0; i < nx; i++) {
        Delta[i] = hN*f1[i];
        xtmp[i] = x1[i] - x0[i];
      }

      /* rhs = hN*f(tn,ytmp) - M*(ytmp-yn) */
      for (col = 0; col < nx; col++) {
        for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
          real_T m_row_col = M[rowidx];
          row = Mpattern_ir[rowidx];
          Delta[row] -= m_row_col*xtmp[col];
        }
      }

      /* rhs = rhs - (Mtmp - M)*ztmp*h */
      local_evaluateMassMatrix(si,M1 );
      for (i = 0; i < rtsiGetSolverMassMatrixNzMax(si); i++) {
        M1[i] -= M[i];
      }

      for (col = 0; col < nx; col++) {
        for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
          real_T m_row_col = M1[rowidx];
          row = Mpattern_ir[rowidx];
          Delta[row] -= hN*m_row_col*ztmp[col];
        }
      }

      rt_ForwardSubstitutionRR_Dbl(W, Delta,
        f1, nx,
        1, pivots,
        1);
      rt_BackwardSubstitutionRR_Dbl(W+nx*nx-1, f1+nx-1,
        Delta, nx,
        1, 0);

      /* ytmp = ytmp + delta
         ztmp = (ytmp - yn)/h
       */
      for (i = 0; i < nx; i++) {
        x1[i] += Delta[i];
        ztmp[i] = (x1[i] - x0[i])/hN;
      }
    }

    /* Steps from t0+hN to t1 -- subintegration of N(j) steps for extrapolation
       ttmp = t0;
       for i = 2:N(j)
       ttmp = ttmp + hN
       ytmp0 = ytmp;
       for iter = 1:NewtIter
       rhs = (ytmp0 - ytmp) + hN*feval(odefun,ttmp,ytmp,extraArgs{:});
       Delta = ( U \ ( L \ rhs ) );
       ytmp = ytmp + Delta;
       end
       end
     */
    for (k = 1; k < N[j]; k++) {
      t1 = t0 + k*hN;
      (void) memcpy(x1start, x1,
                    (uint_T)nx*sizeof(real_T));
      rtsiSetT(si, t1);
      rtsiSetdX(si, f1);
      for (iter = 0; iter < numIter; iter++) {
        EVThermalManagement_AMPC_2020b_step0();
        EVThermalManagement_AMPC_2020b_forcingfunction();
        if (iter == 0) {
          for (i = 0; i < nx; i++) {
            Delta[i] = hN*f1[i];
          }
        } else {
          for (i = 0; i < nx; i++) {
            Delta[i] = hN*f1[i];
            xtmp[i] = (x1[i]-x1start[i]);
          }

          /* rhs = hN*f(tn,ytmp) - M*(ytmp-yn) */
          for (col = 0; col < nx; col++) {
            for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx
                 ++) {
              real_T m_row_col = M[rowidx];
              row = Mpattern_ir[rowidx];
              Delta[row] -= m_row_col*xtmp[col];
            }
          }
        }

        /* For state-dep.,  Mdel = M(ttmp,ytmp) - M */
        EVThermalManagement_AMPC_2020b_step0();
        local_evaluateMassMatrix(si,M1 );
        for (i = 0; i < rtsiGetSolverMassMatrixNzMax(si); i++) {
          M1[i] -= M[i];
        }

        /* rhs = rhs - Mdel*ztmp*h */
        for (col = 0; col < nx; col++) {
          for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++)
          {
            real_T m_row_col = M1[rowidx];
            row = Mpattern_ir[rowidx];
            Delta[row] -= hN*m_row_col*ztmp[col];
          }
        }

        rt_ForwardSubstitutionRR_Dbl(W, Delta,
          f1, nx,
          1, pivots,
          1);
        rt_BackwardSubstitutionRR_Dbl(W+nx*nx-1, f1+nx-1,
          Delta, nx,
          1, 0);

        /* ytmp = ytmp + Delta
           ztmp = (ytmp - ytmp0)/h
         */
        for (i = 0; i < nx; i++) {
          x1[i] += Delta[i];
          ztmp[i] = (x1[i] - x1start[i])/hN;
        }
      }
    }

    /* Extrapolate to order j
       E(:,j) = ytmp
       for k = j:-1:2
       coef = N(k-1)/(N(j) - N(k-1))
       E(:,k-1) = E(:,k) + coef*( E(:,k) - E(:,k-1) )
       end
     */
    (void) memcpy(&(E[nx*j]), x1,
                  (uint_T)nx*sizeof(real_T));
    for (k = j; k > 0; k--) {
      real_T coef = (real_T)(N[k-1]) / (N[j]-N[k-1]);
      for (i = 0; i < nx; i++) {
        x1[i] = E[nx*k+i] + coef*(E[nx*k+i] - E[nx*(k-1)+i]);
      }

      (void) memcpy(&(E[nx*(k-1)]), x1,
                    (uint_T)nx*sizeof(real_T));
    }

    /* Extrapolate the derivative */
    for (i = 0; i < nx; i++) {
      xdot[i] = (x1[i] - x1start[i])/hN;
    }

    (void) memcpy(&(Edot[nx*j]), xdot,
                  (uint_T)nx*sizeof(real_T));
    for (k = j; k > 0; k--) {
      real_T coef = (real_T)(N[k-1]) / (N[j]-N[k-1]);
      for (i = 0; i < nx; i++) {
        xdot[i] = Edot[nx*k+i] + coef*(Edot[nx*k+i] - Edot[nx*(k-1)+i]);
      }

      (void) memcpy(&(Edot[nx*(k-1)]), xdot,
                    nx*sizeof(real_T));
    }
  }

  /* x1 = E(:,1); */
  (void) memcpy(x1, E,
                (uint_T)nx*sizeof(real_T));

  /* Extrapolated xdot */
  (void) memcpy(xdot, Edot,
                nx*sizeof(real_T));

  /* t1 = t0 + h; */
  rtsiSetT(si,rtsiGetSolverStopTime(si));
  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

real_T rt_powd_snf(real_T u0, real_T u1)
{
  real_T tmp;
  real_T tmp_0;
  real_T y;
  if (rtIsNaN(u0) || rtIsNaN(u1)) {
    y = (rtNaN);
  } else {
    tmp = fabs(u0);
    tmp_0 = fabs(u1);
    if (rtIsInf(u1)) {
      if (tmp == 1.0) {
        y = 1.0;
      } else if (tmp > 1.0) {
        if (u1 > 0.0) {
          y = (rtInf);
        } else {
          y = 0.0;
        }
      } else if (u1 > 0.0) {
        y = 0.0;
      } else {
        y = (rtInf);
      }
    } else if (tmp_0 == 0.0) {
      y = 1.0;
    } else if (tmp_0 == 1.0) {
      if (u1 > 0.0) {
        y = u0;
      } else {
        y = 1.0 / u0;
      }
    } else if (u1 == 2.0) {
      y = u0 * u0;
    } else if ((u1 == 0.5) && (u0 >= 0.0)) {
      y = sqrt(u0);
    } else if ((u0 < 0.0) && (u1 > floor(u1))) {
      y = (rtNaN);
    } else {
      y = pow(u0, u1);
    }
  }

  return y;
}

/* Function for MATLAB Function: '<S273>/MATLAB Function' */
static real_T PadeApproximantOfDegree(real_T A, uint8_T m)
{
  real_T A2;
  real_T A3;
  real_T A4;
  real_T U;
  real_T V;
  A2 = A * A;
  if (m == 3) {
    U = (A2 + 60.0) * A;
    V = 12.0 * A2;
    A2 = 120.0;
  } else {
    A3 = A2 * A2;
    if (m == 5) {
      U = ((420.0 * A2 + A3) + 15120.0) * A;
      V = 30.0 * A3 + 3360.0 * A2;
      A2 = 30240.0;
    } else {
      A4 = A3 * A2;
      switch (m) {
       case 7:
        U = (((1512.0 * A3 + A4) + 277200.0 * A2) + 8.64864E+6) * A;
        V = (56.0 * A4 + 25200.0 * A3) + 1.99584E+6 * A2;
        A2 = 1.729728E+7;
        break;

       case 9:
        V = A4 * A2;
        U = ((((3960.0 * A4 + V) + 2.16216E+6 * A3) + 3.027024E+8 * A2) +
             8.8216128E+9) * A;
        V = ((90.0 * V + 110880.0 * A4) + 3.027024E+7 * A3) + 2.0756736E+9 * A2;
        A2 = 1.76432256E+10;
        break;

       default:
        U = (((16380.0 * A3 + A4) + 4.08408E+7 * A2) * A4 + (((3.352212864E+10 *
                A4 + 1.05594705216E+13 * A3) + 1.1873537964288E+15 * A2) +
              3.238237626624E+16)) * A;
        V = ((((182.0 * A4 + 960960.0 * A3) + 1.32324192E+9 * A2) * A4 +
              6.704425728E+11 * A4) + 1.29060195264E+14 * A3) +
          7.7717703038976E+15 * A2;
        A2 = 6.476475253248E+16;
        break;
      }
    }
  }

  V += A2;
  V -= U;
  U *= 2.0;
  return U / V + 1.0;
}

/* Function for MATLAB Function: '<S273>/MATLAB Function' */
static real_T expmNoLog2(real_T A)
{
  static const real_T theta[5] = { 0.01495585217958292, 0.253939833006323,
    0.95041789961629319, 2.097847961257068, 5.3719203511481517 };

  static const uint8_T b[5] = { 3U, 5U, 7U, 9U, 13U };

  real_T F;
  real_T normA;
  real_T scnrm;
  int32_T j;
  boolean_T exitg1;
  normA = fabs(A);
  if (normA <= 5.3719203511481517) {
    j = 0;
    exitg1 = false;
    while ((!exitg1) && (j < 5)) {
      if (normA <= theta[j]) {
        F = PadeApproximantOfDegree(A, b[j]);
        exitg1 = true;
      } else {
        j++;
      }
    }
  } else {
    if (rtIsInf(normA) || rtIsNaN(normA)) {
      normA = 0.0;
    } else {
      scnrm = normA / 5.3719203511481517;
      normA = floor(log(scnrm) / 0.69314718055994529);
      scnrm *= rt_powd_snf(2.0, -normA);
      if (scnrm < 0.5) {
        normA--;
        scnrm *= 2.0;
      } else {
        if (scnrm >= 1.0) {
          normA++;
          scnrm *= 0.5;
        }
      }

      if (scnrm == 0.5) {
        normA--;
      }
    }

    A /= rt_powd_snf(2.0, normA);
    F = PadeApproximantOfDegree(A, 13);
    for (j = 0; j < (int32_T)normA; j++) {
      F *= F;
    }
  }

  return F;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void mpc_constraintcoef(real_T b_A, real_T Bu, const real_T Bv[3], real_T
  b_C, const real_T Dv[3], const real_T b_Jm[36], real_T b_SuJm[36], real_T
  b_Sx[9], real_T b_Su1[9], real_T b_Hv[270])
{
  real_T Su[81];
  real_T CA_0[30];
  real_T Sum_0[9];
  real_T CA;
  real_T Sum;
  int32_T b_SuJm_tmp;
  int32_T i;
  int32_T i_0;
  int32_T i_1;
  CA = b_C * b_A;
  Sum = b_C * Bu;
  b_Hv[0] = b_C * Bv[0];
  b_Hv[27] = Dv[0];
  b_Hv[9] = b_C * Bv[1];
  b_Hv[36] = Dv[1];
  b_Hv[18] = b_C * Bv[2];
  b_Hv[45] = Dv[2];
  for (i_0 = 0; i_0 < 24; i_0++) {
    b_Hv[9 * (i_0 + 6)] = 0.0;
  }

  for (i_0 = 0; i_0 < 30; i_0++) {
    memset(&b_Hv[i_0 * 9 + 1], 0, sizeof(real_T) << 3U);
  }

  b_Sx[0] = CA;
  b_Su1[0] = Sum;
  Su[0] = Sum;
  memset(&b_Sx[1], 0, sizeof(real_T) << 3U);
  memset(&b_Su1[1], 0, sizeof(real_T) << 3U);
  for (i = 0; i < 8; i++) {
    Su[9 * (i + 1)] = 0.0;
  }

  for (i_0 = 0; i_0 < 9; i_0++) {
    memset(&Su[i_0 * 9 + 1], 0, sizeof(real_T) << 3U);
  }

  for (i = 0; i < 8; i++) {
    Sum += CA * Bu;
    b_Su1[i + 1] = Sum;
    Sum_0[0] = Sum;
    for (i_0 = 0; i_0 < 8; i_0++) {
      Sum_0[i_0 + 1] = Su[9 * i_0 + i];
    }

    for (i_0 = 0; i_0 < 9; i_0++) {
      Su[(i + 9 * i_0) + 1] = Sum_0[i_0];
    }

    CA_0[0] = CA * Bv[0];
    CA_0[1] = CA * Bv[1];
    CA_0[2] = CA * Bv[2];
    for (i_0 = 0; i_0 < 27; i_0++) {
      CA_0[i_0 + 3] = b_Hv[9 * i_0 + i];
    }

    for (i_0 = 0; i_0 < 30; i_0++) {
      b_Hv[(i + 9 * i_0) + 1] = CA_0[i_0];
    }

    CA *= b_A;
    b_Sx[i + 1] = CA;
  }

  for (i_0 = 0; i_0 < 4; i_0++) {
    for (i = 0; i < 9; i++) {
      b_SuJm_tmp = i + 9 * i_0;
      b_SuJm[b_SuJm_tmp] = 0.0;
      for (i_1 = 0; i_1 < 9; i_1++) {
        b_SuJm[b_SuJm_tmp] += Su[9 * i_1 + i] * b_Jm[9 * i_0 + i_1];
      }
    }
  }
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void WtMult(const real_T W[9], const real_T M[36], real_T nwt, real_T WM
                   [36])
{
  real_T W_0;
  int32_T i;
  int32_T tmp;
  int16_T ixw;
  ixw = 1;
  for (i = 0; i < 9; i++) {
    W_0 = W[ixw - 1];
    WM[i] = W_0 * M[i];
    WM[i + 9] = M[i + 9] * W_0;
    WM[i + 18] = M[i + 18] * W_0;
    WM[i + 27] = M[i + 27] * W_0;
    tmp = ixw + 1;
    if (ixw + 1 > 32767) {
      tmp = 32767;
    }

    ixw = (int16_T)tmp;
    if ((int16_T)tmp > 9) {
      W_0 = rt_roundd_snf(9.0 - nwt);
      if (W_0 < 32768.0) {
        if (W_0 >= -32768.0) {
          ixw = (int16_T)W_0;
        } else {
          ixw = MIN_int16_T;
        }
      } else {
        ixw = MAX_int16_T;
      }

      tmp = ixw + 1;
      if (W_0 < 32768.0) {
        if (W_0 >= -32768.0) {
          ixw = (int16_T)W_0;
        } else {
          ixw = MIN_int16_T;
        }
      } else {
        ixw = MAX_int16_T;
      }

      if (ixw + 1 > 32767) {
        tmp = 32767;
      }

      ixw = (int16_T)tmp;
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static int32_T xpotrf(real_T b_A[25])
{
  real_T c;
  real_T ssq;
  int32_T b_ix;
  int32_T b_iy;
  int32_T b_k;
  int32_T d;
  int32_T ia;
  int32_T idxAjj;
  int32_T info;
  int32_T iy;
  int32_T j;
  boolean_T exitg1;
  info = 0;
  j = 0;
  exitg1 = false;
  while ((!exitg1) && (j < 5)) {
    idxAjj = j * 5 + j;
    ssq = 0.0;
    if (j >= 1) {
      b_ix = j;
      b_iy = j;
      for (b_k = 0; b_k < j; b_k++) {
        ssq += b_A[b_ix] * b_A[b_iy];
        b_ix += 5;
        b_iy += 5;
      }
    }

    ssq = b_A[idxAjj] - ssq;
    if (ssq > 0.0) {
      ssq = sqrt(ssq);
      b_A[idxAjj] = ssq;
      if (j + 1 < 5) {
        if (j != 0) {
          b_ix = j;
          b_iy = ((j - 1) * 5 + j) + 2;
          for (b_k = j + 2; b_k <= b_iy; b_k += 5) {
            c = -b_A[b_ix];
            iy = idxAjj + 1;
            d = (b_k - j) + 3;
            for (ia = b_k; ia <= d; ia++) {
              b_A[iy] += b_A[ia - 1] * c;
              iy++;
            }

            b_ix += 5;
          }
        }

        ssq = 1.0 / ssq;
        b_ix = (idxAjj - j) + 5;
        for (idxAjj++; idxAjj < b_ix; idxAjj++) {
          b_A[idxAjj] *= ssq;
        }
      }

      j++;
    } else {
      b_A[idxAjj] = ssq;
      info = j + 1;
      exitg1 = true;
    }
  }

  return info;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T minimum(const real_T x[5])
{
  real_T ex;
  int32_T idx;
  int32_T k_0;
  boolean_T exitg1;
  if (!rtIsNaN(x[0])) {
    idx = 1;
  } else {
    idx = 0;
    k_0 = 2;
    exitg1 = false;
    while ((!exitg1) && (k_0 < 6)) {
      if (!rtIsNaN(x[k_0 - 1])) {
        idx = k_0;
        exitg1 = true;
      } else {
        k_0++;
      }
    }
  }

  if (idx == 0) {
    ex = x[0];
  } else {
    ex = x[idx - 1];
    while (idx + 1 <= 5) {
      if (ex > x[idx]) {
        ex = x[idx];
      }

      idx++;
    }
  }

  return ex;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void mpc_checkhessian(real_T b_H[25], real_T L[25], real_T *BadH)
{
  real_T varargin_1[5];
  real_T normH;
  real_T s_0;
  int32_T Tries;
  int32_T j;
  int8_T b[25];
  boolean_T exitg1;
  boolean_T exitg2;
  boolean_T guard1 = false;
  boolean_T guard2 = false;
  *BadH = 0.0;
  memcpy(&L[0], &b_H[0], 25U * sizeof(real_T));
  Tries = xpotrf(L);
  guard1 = false;
  if (Tries == 0) {
    for (Tries = 0; Tries < 5; Tries++) {
      varargin_1[Tries] = L[5 * Tries + Tries];
    }

    if (minimum(varargin_1) > 1.4901161193847656E-7) {
    } else {
      guard1 = true;
    }
  } else {
    guard1 = true;
  }

  if (guard1) {
    normH = 0.0;
    Tries = 0;
    exitg2 = false;
    while ((!exitg2) && (Tries < 5)) {
      s_0 = 0.0;
      for (j = 0; j < 5; j++) {
        s_0 += fabs(b_H[5 * j + Tries]);
      }

      if (rtIsNaN(s_0)) {
        normH = (rtNaN);
        exitg2 = true;
      } else {
        if (s_0 > normH) {
          normH = s_0;
        }

        Tries++;
      }
    }

    if (normH >= 1.0E+10) {
      *BadH = 2.0;
    } else {
      Tries = 0;
      exitg1 = false;
      while ((!exitg1) && (Tries <= 4)) {
        normH = rt_powd_snf(10.0, (real_T)Tries) * 1.4901161193847656E-7;
        for (j = 0; j < 25; j++) {
          b[j] = 0;
        }

        for (j = 0; j < 5; j++) {
          b[j + 5 * j] = 1;
        }

        for (j = 0; j < 25; j++) {
          s_0 = normH * (real_T)b[j] + b_H[j];
          L[j] = s_0;
          b_H[j] = s_0;
        }

        j = xpotrf(L);
        guard2 = false;
        if (j == 0) {
          for (j = 0; j < 5; j++) {
            varargin_1[j] = L[5 * j + j];
          }

          if (minimum(varargin_1) > 1.4901161193847656E-7) {
            *BadH = 1.0;
            exitg1 = true;
          } else {
            guard2 = true;
          }
        } else {
          guard2 = true;
        }

        if (guard2) {
          *BadH = 3.0;
          Tries++;
        }
      }
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void trisolve(const real_T b_A[25], real_T b_B[25])
{
  real_T tmp_0;
  int32_T i;
  int32_T j;
  int32_T jBcol;
  int32_T kAcol;
  int32_T k_8;
  int32_T tmp;
  int32_T tmp_1;
  for (j = 0; j < 5; j++) {
    jBcol = 5 * j;
    for (k_8 = 0; k_8 < 5; k_8++) {
      kAcol = 5 * k_8;
      tmp = k_8 + jBcol;
      tmp_0 = b_B[tmp];
      if (tmp_0 != 0.0) {
        b_B[tmp] = tmp_0 / b_A[k_8 + kAcol];
        for (i = k_8 + 2; i < 6; i++) {
          tmp_1 = (i + jBcol) - 1;
          b_B[tmp_1] -= b_A[(i + kAcol) - 1] * b_B[tmp];
        }
      }
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void Unconstrained(const real_T b_Hinv[25], const real_T f_3[5], real_T
  x[5], int16_T n_4)
{
  real_T b_Hinv_0;
  int32_T i;
  int32_T i_0;
  for (i = 1; i - 1 < n_4; i++) {
    b_Hinv_0 = 0.0;
    for (i_0 = 0; i_0 < 5; i_0++) {
      b_Hinv_0 += -b_Hinv[(5 * i_0 + (int16_T)i) - 1] * f_3[i_0];
    }

    x[(int16_T)i - 1] = b_Hinv_0;
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T norm(const real_T x[5])
{
  real_T absxk;
  real_T scale;
  real_T t_1;
  real_T y;
  int32_T k_2;
  y = 0.0;
  scale = 3.3121686421112381E-170;
  for (k_2 = 0; k_2 < 5; k_2++) {
    absxk = fabs(x[k_2]);
    if (absxk > scale) {
      t_1 = scale / absxk;
      y = y * t_1 * t_1 + 1.0;
      scale = absxk;
    } else {
      t_1 = absxk / scale;
      y += t_1 * t_1;
    }
  }

  return scale * sqrt(y);
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void abs_a(const real_T x[5], real_T y[5])
{
  int32_T k_3;
  for (k_3 = 0; k_3 < 5; k_3++) {
    y[k_3] = fabs(x[k_3]);
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T maximum(const real_T x[5])
{
  real_T ex;
  int32_T idx;
  int32_T k_4;
  boolean_T exitg1;
  if (!rtIsNaN(x[0])) {
    idx = 1;
  } else {
    idx = 0;
    k_4 = 2;
    exitg1 = false;
    while ((!exitg1) && (k_4 < 6)) {
      if (!rtIsNaN(x[k_4 - 1])) {
        idx = k_4;
        exitg1 = true;
      } else {
        k_4++;
      }
    }
  }

  if (idx == 0) {
    ex = x[0];
  } else {
    ex = x[idx - 1];
    while (idx + 1 <= 5) {
      if (ex < x[idx]) {
        ex = x[idx];
      }

      idx++;
    }
  }

  return ex;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void abs_am(const real_T x[34], real_T y[34])
{
  int32_T k_6;
  for (k_6 = 0; k_6 < 34; k_6++) {
    y[k_6] = fabs(x[k_6]);
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void maximum2(const real_T x[34], real_T y, real_T ex[34])
{
  real_T u0;
  int32_T k_7;
  for (k_7 = 0; k_7 < 34; k_7++) {
    u0 = x[k_7];
    if ((u0 > y) || rtIsNaN(y)) {
      ex[k_7] = u0;
    } else {
      ex[k_7] = y;
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T xnrm2(int32_T n_0, const real_T x[25], int32_T ix0)
{
  real_T absxk;
  real_T scale;
  real_T t_0;
  real_T y;
  int32_T k_1;
  int32_T kend;
  y = 0.0;
  if (n_0 >= 1) {
    if (n_0 == 1) {
      y = fabs(x[ix0 - 1]);
    } else {
      scale = 3.3121686421112381E-170;
      kend = (ix0 + n_0) - 1;
      for (k_1 = ix0; k_1 <= kend; k_1++) {
        absxk = fabs(x[k_1 - 1]);
        if (absxk > scale) {
          t_0 = scale / absxk;
          y = y * t_0 * t_0 + 1.0;
          scale = absxk;
        } else {
          t_0 = absxk / scale;
          y += t_0 * t_0;
        }
      }

      y = scale * sqrt(y);
    }
  }

  return y;
}

real_T rt_hypotd_snf(real_T u0, real_T u1)
{
  real_T a;
  real_T y;
  a = fabs(u0);
  y = fabs(u1);
  if (a < y) {
    a /= y;
    y *= sqrt(a * a + 1.0);
  } else if (a > y) {
    y /= a;
    y = sqrt(y * y + 1.0) * a;
  } else {
    if (!rtIsNaN(y)) {
      y = a * 1.4142135623730951;
    }
  }

  return y;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void xgemv(int32_T b_m, int32_T n_2, const real_T b_A[25], int32_T ia0,
                  const real_T x[25], int32_T ix0, real_T y[5])
{
  real_T c;
  int32_T b;
  int32_T b_iy;
  int32_T d;
  int32_T ia;
  int32_T iac;
  int32_T ix;
  if ((b_m != 0) && (n_2 != 0)) {
    for (b_iy = 0; b_iy < n_2; b_iy++) {
      y[b_iy] = 0.0;
    }

    b_iy = 0;
    b = (n_2 - 1) * 5 + ia0;
    for (iac = ia0; iac <= b; iac += 5) {
      ix = ix0;
      c = 0.0;
      d = (iac + b_m) - 1;
      for (ia = iac; ia <= d; ia++) {
        c += b_A[ia - 1] * x[ix - 1];
        ix++;
      }

      y[b_iy] += c;
      b_iy++;
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void xgerc(int32_T b_m, int32_T n_3, real_T alpha1, int32_T ix0, const
                  real_T y[5], real_T b_A[25], int32_T ia0)
{
  real_T temp;
  int32_T b;
  int32_T ijA;
  int32_T ix;
  int32_T j;
  int32_T jA;
  int32_T jy;
  if (!(alpha1 == 0.0)) {
    jA = ia0 - 1;
    jy = 0;
    for (j = 0; j < n_3; j++) {
      if (y[jy] != 0.0) {
        temp = y[jy] * alpha1;
        ix = ix0;
        b = b_m + jA;
        for (ijA = jA; ijA < b; ijA++) {
          b_A[ijA] += b_A[ix - 1] * temp;
          ix++;
        }
      }

      jy++;
      jA += 5;
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void qr(const real_T b_A[25], real_T Q[25], real_T R[25])
{
  real_T c_A[25];
  real_T tau[5];
  real_T work[5];
  real_T b_atmp;
  real_T beta1;
  int32_T b_coltop;
  int32_T c_lastc;
  int32_T coltop;
  int32_T exitg1;
  int32_T i;
  int32_T ia;
  int32_T ii;
  int32_T knt;
  boolean_T exitg2;
  for (i = 0; i < 5; i++) {
    tau[i] = 0.0;
  }

  memcpy(&c_A[0], &b_A[0], 25U * sizeof(real_T));
  for (i = 0; i < 5; i++) {
    work[i] = 0.0;
  }

  for (i = 0; i < 5; i++) {
    ii = i * 5 + i;
    if (i + 1 < 5) {
      b_atmp = c_A[ii];
      tau[i] = 0.0;
      beta1 = xnrm2(4 - i, c_A, ii + 2);
      if (beta1 != 0.0) {
        beta1 = rt_hypotd_snf(c_A[ii], beta1);
        if (c_A[ii] >= 0.0) {
          beta1 = -beta1;
        }

        if (fabs(beta1) < 1.0020841800044864E-292) {
          knt = 0;
          c_lastc = ii - i;
          do {
            knt++;
            for (b_coltop = ii + 1; b_coltop < c_lastc + 5; b_coltop++) {
              c_A[b_coltop] *= 9.9792015476736E+291;
            }

            beta1 *= 9.9792015476736E+291;
            b_atmp *= 9.9792015476736E+291;
          } while ((fabs(beta1) < 1.0020841800044864E-292) && (knt < 20));

          beta1 = rt_hypotd_snf(b_atmp, xnrm2(4 - i, c_A, ii + 2));
          if (b_atmp >= 0.0) {
            beta1 = -beta1;
          }

          tau[i] = (beta1 - b_atmp) / beta1;
          b_atmp = 1.0 / (b_atmp - beta1);
          for (b_coltop = ii + 1; b_coltop < c_lastc + 5; b_coltop++) {
            c_A[b_coltop] *= b_atmp;
          }

          for (c_lastc = 0; c_lastc < knt; c_lastc++) {
            beta1 *= 1.0020841800044864E-292;
          }

          b_atmp = beta1;
        } else {
          tau[i] = (beta1 - c_A[ii]) / beta1;
          b_atmp = 1.0 / (c_A[ii] - beta1);
          knt = ii - i;
          for (c_lastc = ii + 1; c_lastc < knt + 5; c_lastc++) {
            c_A[c_lastc] *= b_atmp;
          }

          b_atmp = beta1;
        }
      }

      c_A[ii] = b_atmp;
      b_atmp = c_A[ii];
      c_A[ii] = 1.0;
      if (tau[i] != 0.0) {
        knt = 5 - i;
        c_lastc = ii - i;
        while ((knt > 0) && (c_A[c_lastc + 4] == 0.0)) {
          knt--;
          c_lastc--;
        }

        c_lastc = 4 - i;
        exitg2 = false;
        while ((!exitg2) && (c_lastc > 0)) {
          b_coltop = ((c_lastc - 1) * 5 + ii) + 5;
          coltop = b_coltop;
          do {
            exitg1 = 0;
            if (coltop + 1 <= b_coltop + knt) {
              if (c_A[coltop] != 0.0) {
                exitg1 = 1;
              } else {
                coltop++;
              }
            } else {
              c_lastc--;
              exitg1 = 2;
            }
          } while (exitg1 == 0);

          if (exitg1 == 1) {
            exitg2 = true;
          }
        }
      } else {
        knt = 0;
        c_lastc = 0;
      }

      if (knt > 0) {
        xgemv(knt, c_lastc, c_A, ii + 6, c_A, ii + 1, work);
        xgerc(knt, c_lastc, -tau[i], ii + 1, work, c_A, ii + 6);
      }

      c_A[ii] = b_atmp;
    } else {
      tau[4] = 0.0;
    }
  }

  for (i = 0; i < 5; i++) {
    for (ii = 0; ii <= i; ii++) {
      R[ii + 5 * i] = c_A[5 * i + ii];
    }

    for (ii = i + 1; ii + 1 < 6; ii++) {
      R[ii + 5 * i] = 0.0;
    }

    work[i] = 0.0;
  }

  i = 4;
  for (ii = 4; ii >= 0; ii--) {
    knt = (ii * 5 + ii) + 6;
    if (ii + 1 < 5) {
      c_A[knt - 6] = 1.0;
      if (tau[i] != 0.0) {
        c_lastc = 5 - ii;
        b_coltop = knt - ii;
        while ((c_lastc > 0) && (c_A[b_coltop - 2] == 0.0)) {
          c_lastc--;
          b_coltop--;
        }

        b_coltop = 4 - ii;
        exitg2 = false;
        while ((!exitg2) && (b_coltop > 0)) {
          coltop = (b_coltop - 1) * 5 + knt;
          ia = coltop;
          do {
            exitg1 = 0;
            if (ia <= (coltop + c_lastc) - 1) {
              if (c_A[ia - 1] != 0.0) {
                exitg1 = 1;
              } else {
                ia++;
              }
            } else {
              b_coltop--;
              exitg1 = 2;
            }
          } while (exitg1 == 0);

          if (exitg1 == 1) {
            exitg2 = true;
          }
        }
      } else {
        c_lastc = 0;
        b_coltop = 0;
      }

      if (c_lastc > 0) {
        xgemv(c_lastc, b_coltop, c_A, knt, c_A, knt - 5, work);
        xgerc(c_lastc, b_coltop, -tau[i], knt - 5, work, c_A, knt);
      }

      c_lastc = (knt - ii) - 1;
      for (b_coltop = knt - 5; b_coltop < c_lastc; b_coltop++) {
        c_A[b_coltop] *= -tau[i];
      }
    }

    c_A[knt - 6] = 1.0 - tau[i];
    for (c_lastc = 0; c_lastc < ii; c_lastc++) {
      c_A[(knt - c_lastc) - 7] = 0.0;
    }

    i--;
  }

  for (i = 0; i < 5; i++) {
    for (ii = 0; ii < 5; ii++) {
      Q[ii + 5 * i] = c_A[5 * i + ii];
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T KWIKfactor(const real_T b_Ac[170], const int16_T iC[34], int16_T
  nA, const real_T b_Linv[25], real_T RLinv[25], real_T b_D[25], real_T b_H[25],
  int16_T n_1)
{
  real_T QQ[25];
  real_T RR[25];
  real_T TL[25];
  real_T Status;
  real_T b_Linv_0;
  int32_T exitg1;
  int32_T f_i;
  int32_T i;
  int32_T iC_0;
  int32_T i_0;
  int32_T tmp;
  int16_T b_j;
  int16_T c_k;
  Status = 1.0;
  memset(&RLinv[0], 0, 25U * sizeof(real_T));
  for (i = 1; i - 1 < nA; i++) {
    iC_0 = iC[(int16_T)i - 1];
    for (i_0 = 0; i_0 < 5; i_0++) {
      tmp = i_0 + 5 * ((int16_T)i - 1);
      RLinv[tmp] = 0.0;
      for (f_i = 0; f_i < 5; f_i++) {
        RLinv[tmp] += b_Ac[(34 * f_i + iC_0) - 1] * b_Linv[5 * f_i + i_0];
      }
    }
  }

  qr(RLinv, QQ, RR);
  i = 1;
  do {
    exitg1 = 0;
    if (i - 1 <= nA - 1) {
      if (fabs(RR[(((int16_T)i - 1) * 5 + (int16_T)i) - 1]) < 1.0E-12) {
        Status = -2.0;
        exitg1 = 1;
      } else {
        i++;
      }
    } else {
      for (i = 1; i - 1 < n_1; i++) {
        for (f_i = 1; f_i - 1 < n_1; f_i++) {
          b_Linv_0 = 0.0;
          for (i_0 = 0; i_0 < 5; i_0++) {
            b_Linv_0 += b_Linv[((int16_T)i - 1) * 5 + i_0] * QQ[((int16_T)f_i -
              1) * 5 + i_0];
          }

          TL[((int16_T)i + 5 * ((int16_T)f_i - 1)) - 1] = b_Linv_0;
        }
      }

      memset(&RLinv[0], 0, 25U * sizeof(real_T));
      for (b_j = nA; b_j > 0; b_j--) {
        i_0 = 5 * (b_j - 1);
        tmp = (b_j + i_0) - 1;
        RLinv[tmp] = 1.0;
        for (c_k = b_j; c_k <= nA; c_k++) {
          f_i = ((c_k - 1) * 5 + b_j) - 1;
          RLinv[f_i] /= RR[tmp];
        }

        if (b_j > 1) {
          for (i = 1; i - 1 <= b_j - 2; i++) {
            for (c_k = b_j; c_k <= nA; c_k++) {
              tmp = (c_k - 1) * 5;
              f_i = (tmp + (int16_T)i) - 1;
              RLinv[f_i] -= RR[(i_0 + (int16_T)i) - 1] * RLinv[(tmp + b_j) - 1];
            }
          }
        }
      }

      for (i = 1; i - 1 < n_1; i++) {
        for (b_j = (int16_T)i; b_j <= n_1; b_j++) {
          i_0 = ((int16_T)i + 5 * (b_j - 1)) - 1;
          b_H[i_0] = 0.0;
          tmp = nA + 1;
          if (nA + 1 > 32767) {
            tmp = 32767;
          }

          for (c_k = (int16_T)tmp; c_k <= n_1; c_k++) {
            tmp = (c_k - 1) * 5;
            b_H[i_0] -= TL[(tmp + (int16_T)i) - 1] * TL[(tmp + b_j) - 1];
          }

          b_H[(b_j + 5 * ((int16_T)i - 1)) - 1] = b_H[i_0];
        }
      }

      for (i = 1; i - 1 < nA; i++) {
        for (f_i = 1; f_i - 1 < n_1; f_i++) {
          i_0 = ((int16_T)f_i + 5 * ((int16_T)i - 1)) - 1;
          b_D[i_0] = 0.0;
          for (b_j = (int16_T)i; b_j <= nA; b_j++) {
            tmp = (b_j - 1) * 5;
            b_D[i_0] += TL[(tmp + (int16_T)f_i) - 1] * RLinv[(tmp + (int16_T)i)
              - 1];
          }
        }
      }

      exitg1 = 1;
    }
  } while (exitg1 == 0);

  return Status;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static real_T mtimes(const real_T b_A[5], const real_T b_B[5])
{
  real_T b_C;
  int32_T k_5;
  b_C = 0.0;
  for (k_5 = 0; k_5 < 5; k_5++) {
    b_C += b_A[k_5] * b_B[k_5];
  }

  return b_C;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void DropConstraint(int16_T kDrop, int16_T iA[34], int16_T *nA, int16_T
  iC[34])
{
  int32_T tmp;
  int16_T i;
  iA[iC[kDrop - 1] - 1] = 0;
  if (kDrop < *nA) {
    tmp = *nA - 1;
    if (*nA - 1 < -32768) {
      tmp = -32768;
    }

    for (i = kDrop; i <= (int16_T)tmp; i++) {
      iC[i - 1] = iC[i];
    }
  }

  iC[*nA - 1] = 0;
  tmp = *nA - 1;
  if (*nA - 1 < -32768) {
    tmp = -32768;
  }

  *nA = (int16_T)tmp;
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void qpkwik(const real_T b_Linv[25], const real_T b_Hinv[25], const
                   real_T f_2[5], const real_T b_Ac[170], const real_T b[34],
                   int16_T iA[34], int16_T maxiter, real_T FeasTol, real_T x[5],
                   real_T lambda[34], real_T *status)
{
  real_T cTol[34];
  real_T tmp_2[34];
  real_T RLinv[25];
  real_T U[25];
  real_T b_D[25];
  real_T b_H[25];
  real_T Opt[10];
  real_T Rhs[10];
  real_T b_Ac_0[5];
  real_T r_0[5];
  real_T z[5];
  real_T Xnorm0;
  real_T b_Ac_1;
  real_T cMin;
  real_T cVal;
  real_T rMin;
  real_T t_2;
  int32_T U_tmp;
  int32_T U_tmp_0;
  int32_T exitg1;
  int32_T exitg3;
  int32_T i;
  int32_T lambda_tmp_tmp;
  int32_T tmp;
  int16_T iC[34];
  int16_T kDrop;
  int16_T kNext;
  int16_T nA;
  int16_T tmp_0;
  int16_T tmp_1;
  uint16_T b_x;
  uint16_T q_0;
  boolean_T ColdReset;
  boolean_T DualFeasible;
  boolean_T cTolComputed;
  boolean_T exitg2;
  boolean_T exitg4;
  boolean_T guard1 = false;
  boolean_T guard2 = false;
  *status = 1.0;
  memset(&lambda[0], 0, 34U * sizeof(real_T));
  for (i = 0; i < 5; i++) {
    x[i] = 0.0;
    r_0[i] = 0.0;
  }

  rMin = 0.0;
  cTolComputed = false;
  for (i = 0; i < 34; i++) {
    cTol[i] = 1.0;
    iC[i] = 0;
  }

  nA = 0;
  for (i = 0; i < 34; i++) {
    if (iA[i] == 1) {
      U_tmp = nA + 1;
      if (nA + 1 > 32767) {
        U_tmp = 32767;
      }

      nA = (int16_T)U_tmp;
      iC[(int16_T)U_tmp - 1] = (int16_T)(i + 1);
    }
  }

  guard1 = false;
  if (nA > 0) {
    memset(&Opt[0], 0, 10U * sizeof(real_T));
    for (i = 0; i < 5; i++) {
      Rhs[i] = f_2[i];
      Rhs[i + 5] = 0.0;
    }

    DualFeasible = false;
    U_tmp = 3 * nA;
    if (U_tmp > 32767) {
      U_tmp = 32767;
    }

    if ((int16_T)U_tmp > 50) {
      kNext = (int16_T)U_tmp;
    } else {
      kNext = 50;
    }

    q_0 = (uint16_T)(kNext / 10U);
    b_x = (uint16_T)((uint32_T)kNext - q_0 * 10);
    if ((b_x > 0) && (b_x >= 5)) {
      q_0++;
    }

    ColdReset = false;
    do {
      exitg3 = 0;
      if ((!DualFeasible) && (nA > 0) && ((int32_T)*status <= maxiter)) {
        Xnorm0 = KWIKfactor(b_Ac, iC, nA, b_Linv, RLinv, b_D, b_H, 5);
        if (Xnorm0 < 0.0) {
          if (ColdReset) {
            *status = -2.0;
            exitg3 = 2;
          } else {
            nA = 0;
            memset(&iA[0], 0, 34U * sizeof(int16_T));
            memset(&iC[0], 0, 34U * sizeof(int16_T));
            ColdReset = true;
          }
        } else {
          for (i = 1; i - 1 < nA; i++) {
            U_tmp = (int16_T)i + 5;
            if ((int16_T)i + 5 > 32767) {
              U_tmp = 32767;
            }

            Rhs[U_tmp - 1] = b[iC[(int16_T)i - 1] - 1];
            for (kNext = (int16_T)i; kNext <= nA; kNext++) {
              U_tmp = (kNext + 5 * ((int16_T)i - 1)) - 1;
              U[U_tmp] = 0.0;
              for (lambda_tmp_tmp = 1; lambda_tmp_tmp - 1 < nA; lambda_tmp_tmp++)
              {
                U_tmp_0 = ((int16_T)lambda_tmp_tmp - 1) * 5;
                U[U_tmp] += RLinv[(U_tmp_0 + kNext) - 1] * RLinv[(U_tmp_0 +
                  (int16_T)i) - 1];
              }

              U[((int16_T)i + 5 * (kNext - 1)) - 1] = U[U_tmp];
            }
          }

          for (i = 0; i < 5; i++) {
            Xnorm0 = 0.0;
            for (U_tmp = 0; U_tmp < 5; U_tmp++) {
              Xnorm0 += b_H[i + 5 * U_tmp] * Rhs[U_tmp];
            }

            Opt[i] = Xnorm0;
            for (lambda_tmp_tmp = 1; lambda_tmp_tmp - 1 < nA; lambda_tmp_tmp++)
            {
              U_tmp = (int16_T)lambda_tmp_tmp + 5;
              if ((int16_T)lambda_tmp_tmp + 5 > 32767) {
                U_tmp = 32767;
              }

              Opt[i] += b_D[((int16_T)lambda_tmp_tmp - 1) * 5 + i] * Rhs[U_tmp -
                1];
            }
          }

          for (i = 1; i - 1 < nA; i++) {
            Xnorm0 = 0.0;
            for (U_tmp = 0; U_tmp < 5; U_tmp++) {
              Xnorm0 += b_D[((int16_T)i - 1) * 5 + U_tmp] * Rhs[U_tmp];
            }

            U_tmp = (int16_T)i + 5;
            if ((int16_T)i + 5 > 32767) {
              U_tmp = 32767;
            }

            Opt[U_tmp - 1] = Xnorm0;
            for (lambda_tmp_tmp = 1; lambda_tmp_tmp - 1 < nA; lambda_tmp_tmp++)
            {
              U_tmp = (int16_T)i + 5;
              if ((int16_T)i + 5 > 32767) {
                U_tmp = 32767;
              }

              U_tmp_0 = (int16_T)i + 5;
              if ((int16_T)i + 5 > 32767) {
                U_tmp_0 = 32767;
              }

              tmp = (int16_T)lambda_tmp_tmp + 5;
              if ((int16_T)lambda_tmp_tmp + 5 > 32767) {
                tmp = 32767;
              }

              Opt[U_tmp - 1] = U[(((int16_T)lambda_tmp_tmp - 1) * 5 + (int16_T)i)
                - 1] * Rhs[tmp - 1] + Opt[U_tmp_0 - 1];
            }
          }

          Xnorm0 = -1.0E-12;
          kDrop = 0;
          for (i = 1; i - 1 < nA; i++) {
            U_tmp = (int16_T)i + 5;
            if ((int16_T)i + 5 > 32767) {
              U_tmp = 32767;
            }

            lambda[iC[(int16_T)i - 1] - 1] = Opt[U_tmp - 1];
            U_tmp = (int16_T)i + 5;
            if ((int16_T)i + 5 > 32767) {
              U_tmp = 32767;
            }

            if ((Opt[U_tmp - 1] < Xnorm0) && ((int16_T)i <= nA)) {
              kDrop = (int16_T)i;
              U_tmp = (int16_T)i + 5;
              if ((int16_T)i + 5 > 32767) {
                U_tmp = 32767;
              }

              Xnorm0 = Opt[U_tmp - 1];
            }
          }

          if (kDrop <= 0) {
            DualFeasible = true;
            for (i = 0; i < 5; i++) {
              x[i] = Opt[i];
            }
          } else {
            (*status)++;
            if ((int32_T)*status > q_0) {
              nA = 0;
              memset(&iA[0], 0, 34U * sizeof(int16_T));
              memset(&iC[0], 0, 34U * sizeof(int16_T));
              ColdReset = true;
            } else {
              lambda[iC[kDrop - 1] - 1] = 0.0;
              DropConstraint(kDrop, iA, &nA, iC);
            }
          }
        }
      } else {
        if (nA <= 0) {
          memset(&lambda[0], 0, 34U * sizeof(real_T));
          Unconstrained(b_Hinv, f_2, x, 5);
        }

        exitg3 = 1;
      }
    } while (exitg3 == 0);

    if (exitg3 == 1) {
      guard1 = true;
    }
  } else {
    Unconstrained(b_Hinv, f_2, x, 5);
    guard1 = true;
  }

  if (guard1) {
    Xnorm0 = norm(x);
    exitg2 = false;
    while ((!exitg2) && ((int32_T)*status <= maxiter)) {
      cMin = -FeasTol;
      kNext = 0;
      for (i = 0; i < 34; i++) {
        t_2 = cTol[i];
        if (!cTolComputed) {
          for (U_tmp = 0; U_tmp < 5; U_tmp++) {
            b_Ac_0[U_tmp] = b_Ac[i + 34 * U_tmp] * x[U_tmp];
          }

          abs_a(b_Ac_0, z);
          cVal = maximum(z);
          if ((!(t_2 > cVal)) && (!rtIsNaN(cVal))) {
            t_2 = cVal;
          }
        }

        if (iA[i] == 0) {
          b_Ac_1 = 0.0;
          for (U_tmp = 0; U_tmp < 5; U_tmp++) {
            b_Ac_1 += b_Ac[i + 34 * U_tmp] * x[U_tmp];
          }

          cVal = (b_Ac_1 - b[i]) / t_2;
          if (cVal < cMin) {
            cMin = cVal;
            kNext = (int16_T)(i + 1);
          }
        }

        cTol[i] = t_2;
      }

      cTolComputed = true;
      if (kNext <= 0) {
        exitg2 = true;
      } else if ((int32_T)*status == maxiter) {
        *status = 0.0;
        exitg2 = true;
      } else {
        do {
          exitg1 = 0;
          if ((kNext > 0) && ((int32_T)*status <= maxiter)) {
            guard2 = false;
            if (nA == 0) {
              for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                z[U_tmp] = 0.0;
                for (U_tmp_0 = 0; U_tmp_0 < 5; U_tmp_0++) {
                  z[U_tmp] += b_Ac[(34 * U_tmp_0 + kNext) - 1] * b_Hinv[5 *
                    U_tmp_0 + U_tmp];
                }
              }

              guard2 = true;
            } else {
              cMin = KWIKfactor(b_Ac, iC, nA, b_Linv, RLinv, b_D, b_H, 5);
              if (cMin <= 0.0) {
                *status = -2.0;
                exitg1 = 1;
              } else {
                for (U_tmp = 0; U_tmp < 25; U_tmp++) {
                  U[U_tmp] = -b_H[U_tmp];
                }

                for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                  z[U_tmp] = 0.0;
                  for (U_tmp_0 = 0; U_tmp_0 < 5; U_tmp_0++) {
                    z[U_tmp] += b_Ac[(34 * U_tmp_0 + kNext) - 1] * U[5 * U_tmp_0
                      + U_tmp];
                  }
                }

                for (i = 1; i - 1 < nA; i++) {
                  b_Ac_1 = 0.0;
                  for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                    b_Ac_1 += b_Ac[(34 * U_tmp + kNext) - 1] * b_D[((int16_T)i -
                      1) * 5 + U_tmp];
                  }

                  r_0[(int16_T)i - 1] = b_Ac_1;
                }

                guard2 = true;
              }
            }

            if (guard2) {
              kDrop = 0;
              cMin = 0.0;
              DualFeasible = true;
              ColdReset = true;
              if (nA > 0) {
                i = 0;
                exitg4 = false;
                while ((!exitg4) && (i <= nA - 1)) {
                  if (r_0[i] >= 1.0E-12) {
                    ColdReset = false;
                    exitg4 = true;
                  } else {
                    i++;
                  }
                }
              }

              if ((nA != 0) && (!ColdReset)) {
                for (i = 1; i - 1 < nA; i++) {
                  t_2 = r_0[(int16_T)i - 1];
                  if (t_2 > 1.0E-12) {
                    cVal = lambda[iC[(int16_T)i - 1] - 1] / t_2;
                    if ((kDrop == 0) || (cVal < rMin)) {
                      rMin = cVal;
                      kDrop = (int16_T)i;
                    }
                  }
                }

                if (kDrop > 0) {
                  cMin = rMin;
                  DualFeasible = false;
                }
              }

              for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                b_Ac_0[U_tmp] = b_Ac[(34 * U_tmp + kNext) - 1];
              }

              cVal = mtimes(z, b_Ac_0);
              if (cVal <= 0.0) {
                cVal = 0.0;
                ColdReset = true;
              } else {
                b_Ac_1 = 0.0;
                for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                  b_Ac_1 += b_Ac[(34 * U_tmp + kNext) - 1] * x[U_tmp];
                }

                cVal = (b[kNext - 1] - b_Ac_1) / cVal;
                ColdReset = false;
              }

              if (DualFeasible && ColdReset) {
                *status = -1.0;
                exitg1 = 1;
              } else {
                if (ColdReset) {
                  t_2 = cMin;
                } else if (DualFeasible) {
                  t_2 = cVal;
                } else if ((cMin < cVal) || rtIsNaN(cVal)) {
                  t_2 = cMin;
                } else {
                  t_2 = cVal;
                }

                for (i = 1; i - 1 < nA; i++) {
                  lambda_tmp_tmp = iC[(int16_T)i - 1];
                  lambda[lambda_tmp_tmp - 1] -= r_0[(int16_T)i - 1] * t_2;
                  if ((lambda_tmp_tmp <= 34) && (lambda[lambda_tmp_tmp - 1] <
                       0.0)) {
                    lambda[lambda_tmp_tmp - 1] = 0.0;
                  }
                }

                lambda[kNext - 1] += t_2;
                if (t_2 == cMin) {
                  DropConstraint(kDrop, iA, &nA, iC);
                }

                if (!ColdReset) {
                  for (U_tmp = 0; U_tmp < 5; U_tmp++) {
                    x[U_tmp] += t_2 * z[U_tmp];
                  }

                  if (t_2 == cVal) {
                    if (nA == 5) {
                      *status = -1.0;
                      exitg1 = 1;
                    } else {
                      U_tmp = nA + 1;
                      if (nA + 1 > 32767) {
                        U_tmp = 32767;
                      }

                      nA = (int16_T)U_tmp;
                      iC[(int16_T)U_tmp - 1] = kNext;
                      kDrop = (int16_T)U_tmp;
                      exitg4 = false;
                      while ((!exitg4) && (kDrop > 1)) {
                        tmp_0 = iC[kDrop - 1];
                        tmp_1 = iC[kDrop - 2];
                        if (tmp_0 > tmp_1) {
                          exitg4 = true;
                        } else {
                          iC[kDrop - 1] = tmp_1;
                          iC[kDrop - 2] = tmp_0;
                          kDrop--;
                        }
                      }

                      iA[kNext - 1] = 1;
                      kNext = 0;
                      (*status)++;
                    }
                  } else {
                    (*status)++;
                  }
                } else {
                  (*status)++;
                }
              }
            }
          } else {
            cMin = norm(x);
            if (fabs(cMin - Xnorm0) > 0.001) {
              Xnorm0 = cMin;
              abs_am(b, tmp_2);
              maximum2(tmp_2, 1.0, cTol);
              cTolComputed = false;
            }

            exitg1 = 2;
          }
        } while (exitg1 == 0);

        if (exitg1 == 1) {
          exitg2 = true;
        }
      }
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void mpc_solveQP(real_T xQP, const real_T b_Kx[4], const real_T b_Kr[36],
  const real_T rseq[9], const real_T b_Ku1[4], real_T old_u, const real_T b_Kv
  [120], const real_T vseq[30], const real_T b_Kut[36], const real_T b_utarget[9],
  const real_T b_Linv[25], const real_T b_Hinv[25], const real_T b_Ac[170],
  const real_T Bc[34], boolean_T iA[34], real_T zopt[5], real_T f_1[5], real_T
  *status)
{
  real_T unusedU0[34];
  real_T b_Kr_0;
  real_T b_Kut_0;
  real_T b_Kv_0;
  int32_T i;
  int32_T i_0;
  int16_T iAnew[34];
  for (i = 0; i < 5; i++) {
    f_1[i] = 0.0;
  }

  for (i = 0; i < 4; i++) {
    b_Kr_0 = 0.0;
    for (i_0 = 0; i_0 < 9; i_0++) {
      b_Kr_0 += b_Kr[9 * i + i_0] * rseq[i_0];
    }

    b_Kv_0 = 0.0;
    for (i_0 = 0; i_0 < 30; i_0++) {
      b_Kv_0 += b_Kv[30 * i + i_0] * vseq[i_0];
    }

    b_Kut_0 = 0.0;
    for (i_0 = 0; i_0 < 9; i_0++) {
      b_Kut_0 += b_Kut[9 * i + i_0] * b_utarget[i_0];
    }

    f_1[i] = (((b_Kx[i] * xQP + b_Kr_0) + b_Ku1[i] * old_u) + b_Kv_0) + b_Kut_0;
  }

  for (i = 0; i < 34; i++) {
    iAnew[i] = iA[i];
  }

  qpkwik(b_Linv, b_Hinv, f_1, b_Ac, Bc, iAnew, 156, 1.0E-6, zopt, unusedU0,
         status);
  for (i = 0; i < 34; i++) {
    iA[i] = (iAnew[i] != 0);
  }

  if ((*status < 0.0) || (*status == 0.0)) {
    for (i = 0; i < 5; i++) {
      zopt[i] = 0.0;
    }
  }
}

/* Function for MATLAB Function: '<S307>/FixedHorizonOptimizer' */
static void mpcblock_optimizer(const real_T rseq[9], const real_T vseq[30],
  real_T x, real_T old_u, const boolean_T iA[34], const real_T b_Mlim[34],
  real_T b_Mx[34], real_T b_Mu1[34], real_T b_Mv[1020], const real_T b_utarget[9],
  real_T b_uoff, real_T b_H[25], real_T b_Ac[170], const real_T b_Wy[9], const
  real_T b_Wdu[9], const real_T b_Jm[36], const real_T b_Wu[9], const real_T
  b_I1[9], real_T b_A, const real_T Bu[10], const real_T Bv[30], real_T b_C,
  const real_T Dv[30], const real_T b_Mrows_0[34], real_T *u, real_T useq[10],
  real_T *status, boolean_T iAout[34])
{
  static const int8_T c_A[81] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 };

  real_T c_Hv[270];
  real_T c_Hv_0[120];
  real_T I2Jm[36];
  real_T WuI2Jm[36];
  real_T WySuJm[36];
  real_T c_SuJm[36];
  real_T tmp[36];
  real_T b_Mlim_0[34];
  real_T c_Linv[25];
  real_T d_Linv[25];
  real_T b_Jm_0[16];
  real_T c_SuJm_0[16];
  real_T c_Su1[9];
  real_T c_Sx[9];
  real_T f_0[5];
  real_T zopt[5];
  real_T b_I1_0[4];
  real_T c_Su1_0[4];
  real_T c_Su1_1[4];
  real_T c_Sx_0[4];
  real_T BadH;
  int32_T I2Jm_tmp;
  int32_T i;
  int32_T i1;
  int32_T kidx;
  int32_T tmp_0;
  int32_T tmp_1;
  int8_T a[81];
  int8_T b_I[25];
  boolean_T exitg1;
  memset(&useq[0], 0, 10U * sizeof(real_T));
  for (i = 0; i < 34; i++) {
    iAout[i] = false;
  }

  mpc_constraintcoef(b_A, Bu[0], &Bv[0], b_C, &Dv[0], b_Jm, c_SuJm, c_Sx, c_Su1,
                     c_Hv);
  if (b_Mrows_0[0] > 0.0) {
    kidx = 0;
    exitg1 = false;
    while ((!exitg1) && (kidx < 34)) {
      if (b_Mrows_0[kidx] <= 9.0) {
        i1 = (int32_T)b_Mrows_0[kidx];
        b_Ac[kidx] = -c_SuJm[i1 - 1];
        b_Ac[kidx + 34] = -c_SuJm[i1 + 8];
        b_Ac[kidx + 68] = -c_SuJm[i1 + 17];
        b_Ac[kidx + 102] = -c_SuJm[i1 + 26];
        b_Mx[kidx] = -c_Sx[(int32_T)b_Mrows_0[kidx] - 1];
        b_Mu1[kidx] = -c_Su1[(int32_T)b_Mrows_0[kidx] - 1];
        for (i = 0; i < 30; i++) {
          b_Mv[kidx + 34 * i] = -c_Hv[(9 * i + i1) - 1];
        }

        kidx++;
      } else if (b_Mrows_0[kidx] <= 18.0) {
        i1 = (int32_T)(b_Mrows_0[kidx] - 9.0);
        b_Ac[kidx] = c_SuJm[i1 - 1];
        b_Ac[kidx + 34] = c_SuJm[i1 + 8];
        b_Ac[kidx + 68] = c_SuJm[i1 + 17];
        b_Ac[kidx + 102] = c_SuJm[i1 + 26];
        b_Mx[kidx] = c_Sx[(int32_T)(b_Mrows_0[kidx] - 9.0) - 1];
        b_Mu1[kidx] = c_Su1[(int32_T)(b_Mrows_0[kidx] - 9.0) - 1];
        for (i = 0; i < 30; i++) {
          b_Mv[kidx + 34 * i] = c_Hv[(9 * i + i1) - 1];
        }

        kidx++;
      } else {
        exitg1 = true;
      }
    }
  }

  kidx = -1;
  for (i = 0; i < 9; i++) {
    for (i1 = 0; i1 < 9; i1++) {
      kidx++;
      a[kidx] = c_A[9 * i + i1];
    }
  }

  for (i = 0; i < 4; i++) {
    for (kidx = 0; kidx < 9; kidx++) {
      I2Jm_tmp = kidx + 9 * i;
      I2Jm[I2Jm_tmp] = 0.0;
      for (i1 = 0; i1 < 9; i1++) {
        I2Jm[I2Jm_tmp] += (real_T)a[9 * i1 + kidx] * b_Jm[9 * i + i1];
      }
    }
  }

  WtMult(b_Wy, c_SuJm, ny, WySuJm);
  WtMult(b_Wu, I2Jm, nu, WuI2Jm);
  WtMult(b_Wdu, b_Jm, nu, tmp);
  for (i = 0; i < 4; i++) {
    for (kidx = 0; kidx < 4; kidx++) {
      I2Jm_tmp = i + (kidx << 2);
      c_SuJm_0[I2Jm_tmp] = 0.0;
      b_Jm_0[I2Jm_tmp] = 0.0;
      BadH = 0.0;
      for (i1 = 0; i1 < 9; i1++) {
        tmp_0 = 9 * i + i1;
        tmp_1 = 9 * kidx + i1;
        BadH += I2Jm[tmp_0] * WuI2Jm[tmp_1];
        c_SuJm_0[I2Jm_tmp] += c_SuJm[tmp_0] * WySuJm[tmp_1];
        b_Jm_0[I2Jm_tmp] += b_Jm[tmp_0] * tmp[tmp_1];
      }

      b_H[i + 5 * kidx] = (c_SuJm_0[I2Jm_tmp] + b_Jm_0[I2Jm_tmp]) + BadH;
    }
  }

  memcpy(&c_Linv[0], &b_H[0], 25U * sizeof(real_T));
  mpc_checkhessian(c_Linv, d_Linv, &BadH);
  if (BadH > 1.0) {
    *u = old_u + b_uoff;
    for (i = 0; i < 10; i++) {
      useq[i] = *u;
    }

    *status = -2.0;
  } else {
    for (i = 0; i < 25; i++) {
      b_I[i] = 0;
    }

    for (kidx = 0; kidx < 5; kidx++) {
      b_I[kidx + 5 * kidx] = 1;
    }

    for (kidx = 0; kidx < 5; kidx++) {
      for (i = 0; i < 5; i++) {
        I2Jm_tmp = 5 * kidx + i;
        c_Linv[I2Jm_tmp] = b_I[I2Jm_tmp];
      }
    }

    trisolve(d_Linv, c_Linv);
    for (i = 0; i < 34; i++) {
      iAout[i] = iA[i];
    }

    for (i = 0; i < 4; i++) {
      c_Su1_0[i] = 0.0;
      b_I1_0[i] = 0.0;
      c_Sx_0[i] = 0.0;
      for (kidx = 0; kidx < 9; kidx++) {
        i1 = 9 * i + kidx;
        BadH = WySuJm[i1];
        c_Su1_0[i] += c_Su1[kidx] * BadH;
        b_I1_0[i] += WuI2Jm[i1] * b_I1[kidx];
        c_Sx_0[i] += c_Sx[kidx] * BadH;
      }
    }

    for (i = 0; i < 36; i++) {
      c_SuJm[i] = -WySuJm[i];
    }

    c_Su1_1[0] = c_Su1_0[0] + b_I1_0[0];
    c_Su1_1[1] = c_Su1_0[1] + b_I1_0[1];
    c_Su1_1[2] = c_Su1_0[2] + b_I1_0[2];
    c_Su1_1[3] = c_Su1_0[3] + b_I1_0[3];
    for (i = 0; i < 30; i++) {
      for (kidx = 0; kidx < 4; kidx++) {
        I2Jm_tmp = i + 30 * kidx;
        c_Hv_0[I2Jm_tmp] = 0.0;
        for (i1 = 0; i1 < 9; i1++) {
          c_Hv_0[I2Jm_tmp] += c_Hv[9 * i + i1] * WySuJm[9 * kidx + i1];
        }
      }
    }

    for (i = 0; i < 36; i++) {
      WySuJm[i] = -WuI2Jm[i];
    }

    for (i = 0; i < 5; i++) {
      for (kidx = 0; kidx < 5; kidx++) {
        I2Jm_tmp = i + 5 * kidx;
        d_Linv[I2Jm_tmp] = 0.0;
        for (i1 = 0; i1 < 5; i1++) {
          d_Linv[I2Jm_tmp] += c_Linv[5 * i + i1] * c_Linv[5 * kidx + i1];
        }
      }
    }

    for (i = 0; i < 34; i++) {
      BadH = 0.0;
      for (kidx = 0; kidx < 30; kidx++) {
        BadH += b_Mv[34 * kidx + i] * vseq[kidx];
      }

      b_Mlim_0[i] = -(((b_Mx[i] * x + b_Mlim[i]) + b_Mu1[i] * old_u) + BadH);
    }

    mpc_solveQP(x, c_Sx_0, c_SuJm, rseq, c_Su1_1, old_u, c_Hv_0, vseq, WySuJm,
                b_utarget, c_Linv, d_Linv, b_Ac, b_Mlim_0, iAout, zopt, f_0,
                &BadH);
    *status = BadH;
    *u = (old_u + zopt[0]) + b_uoff;
  }
}

/* Model step function for TID0 */
void EVThermalManagement_AMPC_2020b_step0(void) /* Sample time: [0.0s, 0.0s] */
{
  /* local block i/o variables */
  real_T rtb_FromWorkspace;
  real_T rtb_SUM_f;
  if (rtmIsMajorTimeStep(rtM)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&rtM->solverInfo,((rtM->Timing.clockTick0+1)*
      rtM->Timing.stepSize0));

    /* Update the flag to indicate when data transfers from
     *  Sample time: [0.01s, 0.0s] to Sample time: [1.0s, 0.0s]  */
    (rtM->Timing.RateInteraction.TID1_2)++;
    if ((rtM->Timing.RateInteraction.TID1_2) > 99) {
      rtM->Timing.RateInteraction.TID1_2 = 0;
    }
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(rtM)) {
    rtM->Timing.t[0] = rtsiGetT(&rtM->solverInfo);
  }

  {
    NeParameterBundle expl_temp;
    NeslSimulationData *simulationData;
    NeuDiagnosticManager *diag;
    NeuDiagnosticTree *diagTree;
    char *msg;
    real_T tmp_0[96];
    real_T tmp[19];
    real_T Abs;
    real_T MaxSpeedrpm;
    real_T TransferFcn1;
    real_T TransferFcn2;
    real_T TransferFcn3;
    real_T TransferFcn4;
    real_T TransferFcn_an;
    real_T TransferFcn_b;
    real_T TransferFcn_c;
    real_T TransferFcn_fn;
    real_T TransferFcn_h;
    real_T b_idx_0;
    real_T b_idx_1;
    real_T b_idx_2;
    real_T i_battery;
    real_T time;
    real_T time_0;
    real_T *parameterBundle_mRealParameters;
    int_T tmp_2[26];
    int_T tmp_1[25];
    int_T j;
    uint8_T rtb_Sum_p;
    boolean_T rtb_RelationalOperator;
    boolean_T rtb_RelationalOperator1;
    if (rtmIsMajorTimeStep(rtM)) {
      /* SimscapeRtp: '<S21>/RTP_1' incorporates:
       *  Constant: '<S10>/Subsystem_around_RTP_BB68BA06_T'
       *  Constant: '<S11>/Subsystem_around_RTP_870DA25D_T'
       *  Constant: '<S11>/Subsystem_around_RTP_F36A67EE_T_I'
       *  Constant: '<S11>/Subsystem_around_RTP_F36A67EE_p_I'
       *  Constant: '<S13>/Subsystem_around_RTP_F6E40CEB_T'
       *  Constant: '<S15>/Subsystem_around_RTP_B2286759_T'
       *  Constant: '<S17>/Subsystem_around_RTP_20BF28A1_T_gas_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_20BF28A1_T_liquid_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_20BF28A1_p_gas_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_20BF28A1_volume_liquid'
       *  Constant: '<S17>/Subsystem_around_RTP_CD04B3E5_T_gas_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_CD04B3E5_T_liquid_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_CD04B3E5_p_gas_tank'
       *  Constant: '<S17>/Subsystem_around_RTP_CD04B3E5_volume_liquid'
       *  Constant: '<S37>/Subsystem_around_RTP_DAFD7CE0_T'
       *  Constant: '<S3>/Subsystem_around_RTP_51F214DC_T'
       *  Constant: '<S47>/Subsystem_around_RTP_6FC61999_T'
       *  Constant: '<S51>/Subsystem_around_RTP_B5FFC771_T'
       *  Constant: '<S55>/Subsystem_around_RTP_DEC1D52A_T'
       */
      if (rtDW.RTP_1_SetParametersNeeded) {
        tmp[0] = 299.15;
        tmp[1] = 299.15;
        tmp[2] = 299.15;
        tmp[3] = 299.15;
        tmp[4] = 26.0;
        tmp[5] = 26.0;
        tmp[6] = 26.0;
        tmp[7] = 26.0;
        tmp[8] = 0.101325;
        tmp[9] = 26.0;
        tmp[10] = 26.0;
        tmp[11] = 26.0;
        tmp[12] = 26.0;
        tmp[13] = 0.101325;
        tmp[14] = 0.3125;
        tmp[15] = 26.0;
        tmp[16] = 26.0;
        tmp[17] = 0.101325;
        tmp[18] = 0.3125;
        parameterBundle_mRealParameters = &tmp[0];
        diag = rtw_create_diagnostics();
        diagTree = neu_diagnostic_manager_get_initial_tree(diag);
        expl_temp.mRealParameters.mN = 19;
        expl_temp.mRealParameters.mX = parameterBundle_mRealParameters;
        expl_temp.mLogicalParameters.mN = 0;
        expl_temp.mLogicalParameters.mX = NULL;
        expl_temp.mIntegerParameters.mN = 0;
        expl_temp.mIntegerParameters.mX = NULL;
        expl_temp.mIndexParameters.mN = 0;
        expl_temp.mIndexParameters.mX = NULL;
        rtb_RelationalOperator1 = nesl_rtp_manager_set_rtps((NeslRtpManager *)
          rtDW.RTP_1_RtpManager, rtM->Timing.t[0], expl_temp, diag);
        if (!rtb_RelationalOperator1) {
          rtb_RelationalOperator1 = error_buffer_is_empty(rtmGetErrorStatus(rtM));
          if (rtb_RelationalOperator1) {
            msg = rtw_diagnostics_msg(diagTree);
            rtmSetErrorStatus(rtM, msg);
          }
        }
      }

      rtDW.RTP_1_SetParametersNeeded = false;

      /* End of SimscapeRtp: '<S21>/RTP_1' */
    }

    /* Sum: '<S1>/i_battery' incorporates:
     *  TransferFcn: '<S1>/Transfer Fcn'
     *  TransferFcn: '<S377>/Transfer Fcn'
     */
    i_battery = rtX.TransferFcn_CSTATE + rtX.TransferFcn_CSTATE_b;

    /* SimscapeInputBlock: '<S380>/INPUT_1_1_1' */
    rtDW.INPUT_1_1_1[0] = i_battery;
    rtDW.INPUT_1_1_1[1] = 0.0;
    rtDW.INPUT_1_1_1[2] = 0.0;
    rtDW.INPUT_1_1_1[3] = 0.0;

    /* Gain: '<S2>/Max Speed [rpm]' incorporates:
     *  TransferFcn: '<S2>/Transfer Fcn'
     */
    MaxSpeedrpm = 0.2 * rtX.TransferFcn_CSTATE_j * 1000.0;

    /* SimscapeInputBlock: '<S380>/INPUT_2_1_1' */
    rtDW.INPUT_2_1_1[0] = 0.10471975511965977 * MaxSpeedrpm;
    rtDW.INPUT_2_1_1[1] = 0.0;
    rtDW.INPUT_2_1_1[2] = 0.0;
    rtDW.INPUT_2_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_4_1_1' incorporates:
     *  Bias: '<S5>/Bias'
     *  Gain: '<S5>/Gain'
     *  Gain: '<S5>/Max Valve Displacement [m]'
     *  TransferFcn: '<S5>/Transfer Fcn'
     */
    rtDW.INPUT_4_1_1[0] = (2.0 * rtX.TransferFcn_CSTATE_n + -1.0) * 0.0063;
    rtDW.INPUT_4_1_1[1] = 0.0;
    rtDW.INPUT_4_1_1[2] = 0.0;
    rtDW.INPUT_4_1_1[3] = 0.0;

    /* TransferFcn: '<S7>/Transfer Fcn' */
    TransferFcn_c = 0.2 * rtX.TransferFcn_CSTATE_f;

    /* SimscapeInputBlock: '<S380>/INPUT_5_1_1' */
    rtDW.INPUT_5_1_1[0] = TransferFcn_c;
    rtDW.INPUT_5_1_1[1] = 0.0;
    rtDW.INPUT_5_1_1[2] = 0.0;
    rtDW.INPUT_5_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_6_1_1' incorporates:
     *  Gain: '<S8>/Fan Area [m^2]'
     *  TransferFcn: '<S8>/Transfer Fcn'
     */
    rtDW.INPUT_6_1_1[0] = 0.2 * rtX.TransferFcn_CSTATE_jk * 0.5;
    rtDW.INPUT_6_1_1[1] = 0.0;
    rtDW.INPUT_6_1_1[2] = 0.0;
    rtDW.INPUT_6_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_10_1_1' incorporates:
     *  Constant: '<S20>/CO2 Fraction'
     */
    rtDW.INPUT_10_1_1[0] = 0.0004;
    rtDW.INPUT_10_1_1[1] = 0.0;
    rtDW.INPUT_10_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_10_1_1_Discrete[0] = !(rtDW.INPUT_10_1_1[0] ==
        rtDW.INPUT_10_1_1_Discrete[1]);
      rtDW.INPUT_10_1_1_Discrete[1] = rtDW.INPUT_10_1_1[0];
    }

    rtDW.INPUT_10_1_1[0] = rtDW.INPUT_10_1_1_Discrete[1];
    rtDW.INPUT_10_1_1[3] = rtDW.INPUT_10_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_10_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_8_1_1' incorporates:
     *  Constant: '<S20>/Pressure [MPa]'
     */
    rtDW.INPUT_8_1_1[0] = 101325.0;
    rtDW.INPUT_8_1_1[1] = 0.0;
    rtDW.INPUT_8_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_8_1_1_Discrete[0] = !(rtDW.INPUT_8_1_1[0] ==
        rtDW.INPUT_8_1_1_Discrete[1]);
      rtDW.INPUT_8_1_1_Discrete[1] = rtDW.INPUT_8_1_1[0];
    }

    rtDW.INPUT_8_1_1[0] = rtDW.INPUT_8_1_1_Discrete[1];
    rtDW.INPUT_8_1_1[3] = rtDW.INPUT_8_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_8_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_7_1_1' incorporates:
     *  Constant: '<S20>/Temperature [degC]'
     */
    rtDW.INPUT_7_1_1[0] = 299.15;
    rtDW.INPUT_7_1_1[1] = 0.0;
    rtDW.INPUT_7_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_7_1_1_Discrete[0] = !(rtDW.INPUT_7_1_1[0] ==
        rtDW.INPUT_7_1_1_Discrete[1]);
      rtDW.INPUT_7_1_1_Discrete[1] = rtDW.INPUT_7_1_1[0];
    }

    rtDW.INPUT_7_1_1[0] = rtDW.INPUT_7_1_1_Discrete[1];
    rtDW.INPUT_7_1_1[3] = rtDW.INPUT_7_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_7_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_9_1_1' incorporates:
     *  Constant: '<S20>/Relative Humidity'
     */
    rtDW.INPUT_9_1_1[0] = 0.4;
    rtDW.INPUT_9_1_1[1] = 0.0;
    rtDW.INPUT_9_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_9_1_1_Discrete[0] = !(rtDW.INPUT_9_1_1[0] ==
        rtDW.INPUT_9_1_1_Discrete[1]);
      rtDW.INPUT_9_1_1_Discrete[1] = rtDW.INPUT_9_1_1[0];
    }

    rtDW.INPUT_9_1_1[0] = rtDW.INPUT_9_1_1_Discrete[1];
    rtDW.INPUT_9_1_1[3] = rtDW.INPUT_9_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_9_1_1' */

    /* Gain: '<S16>/Max Speed [rpm]' incorporates:
     *  TransferFcn: '<S16>/Transfer Fcn'
     */
    TransferFcn_h = 0.2 * rtX.TransferFcn_CSTATE_p * 1000.0;

    /* SimscapeInputBlock: '<S380>/INPUT_15_1_1' */
    rtDW.INPUT_15_1_1[0] = 0.10471975511965977 * TransferFcn_h;
    rtDW.INPUT_15_1_1[1] = 0.0;
    rtDW.INPUT_15_1_1[2] = 0.0;
    rtDW.INPUT_15_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_16_1_1' incorporates:
     *  Constant: '<S20>/Temperature [degC]'
     */
    rtDW.INPUT_16_1_1[0] = 299.15;
    rtDW.INPUT_16_1_1[1] = 0.0;
    rtDW.INPUT_16_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_16_1_1_Discrete[0] = !(rtDW.INPUT_16_1_1[0] ==
        rtDW.INPUT_16_1_1_Discrete[1]);
      rtDW.INPUT_16_1_1_Discrete[1] = rtDW.INPUT_16_1_1[0];
    }

    rtDW.INPUT_16_1_1[0] = rtDW.INPUT_16_1_1_Discrete[1];
    rtDW.INPUT_16_1_1[3] = rtDW.INPUT_16_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_16_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_17_1_1' incorporates:
     *  Constant: '<S20>/Temperature [degC]'
     */
    rtDW.INPUT_17_1_1[0] = 299.15;
    rtDW.INPUT_17_1_1[1] = 0.0;
    rtDW.INPUT_17_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_17_1_1_Discrete[0] = !(rtDW.INPUT_17_1_1[0] ==
        rtDW.INPUT_17_1_1_Discrete[1]);
      rtDW.INPUT_17_1_1_Discrete[1] = rtDW.INPUT_17_1_1[0];
    }

    rtDW.INPUT_17_1_1[0] = rtDW.INPUT_17_1_1_Discrete[1];
    rtDW.INPUT_17_1_1[3] = rtDW.INPUT_17_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_17_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_18_1_1' incorporates:
     *  Bias: '<S17>/Bias'
     *  Gain: '<S17>/Gain'
     *  Gain: '<S17>/Max Valve Displacement [m]'
     *  TransferFcn: '<S17>/Transfer Fcn'
     */
    rtDW.INPUT_18_1_1[0] = (2.0 * rtX.TransferFcn_CSTATE_pv + -1.0) * 0.0063;
    rtDW.INPUT_18_1_1[1] = 0.0;
    rtDW.INPUT_18_1_1[2] = 0.0;
    rtDW.INPUT_18_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_22_1_1' incorporates:
     *  Constant: '<S20>/CO2 Fraction'
     */
    rtDW.INPUT_22_1_1[0] = 0.0004;
    rtDW.INPUT_22_1_1[1] = 0.0;
    rtDW.INPUT_22_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_22_1_1_Discrete[0] = !(rtDW.INPUT_22_1_1[0] ==
        rtDW.INPUT_22_1_1_Discrete[1]);
      rtDW.INPUT_22_1_1_Discrete[1] = rtDW.INPUT_22_1_1[0];
    }

    rtDW.INPUT_22_1_1[0] = rtDW.INPUT_22_1_1_Discrete[1];
    rtDW.INPUT_22_1_1[3] = rtDW.INPUT_22_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_22_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_20_1_1' incorporates:
     *  Constant: '<S20>/Pressure [MPa]'
     */
    rtDW.INPUT_20_1_1[0] = 101325.0;
    rtDW.INPUT_20_1_1[1] = 0.0;
    rtDW.INPUT_20_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_20_1_1_Discrete[0] = !(rtDW.INPUT_20_1_1[0] ==
        rtDW.INPUT_20_1_1_Discrete[1]);
      rtDW.INPUT_20_1_1_Discrete[1] = rtDW.INPUT_20_1_1[0];
    }

    rtDW.INPUT_20_1_1[0] = rtDW.INPUT_20_1_1_Discrete[1];
    rtDW.INPUT_20_1_1[3] = rtDW.INPUT_20_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_20_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_19_1_1' incorporates:
     *  Constant: '<S20>/Temperature [degC]'
     */
    rtDW.INPUT_19_1_1[0] = 299.15;
    rtDW.INPUT_19_1_1[1] = 0.0;
    rtDW.INPUT_19_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_19_1_1_Discrete[0] = !(rtDW.INPUT_19_1_1[0] ==
        rtDW.INPUT_19_1_1_Discrete[1]);
      rtDW.INPUT_19_1_1_Discrete[1] = rtDW.INPUT_19_1_1[0];
    }

    rtDW.INPUT_19_1_1[0] = rtDW.INPUT_19_1_1_Discrete[1];
    rtDW.INPUT_19_1_1[3] = rtDW.INPUT_19_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_19_1_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_21_1_1' incorporates:
     *  Constant: '<S20>/Relative Humidity'
     */
    rtDW.INPUT_21_1_1[0] = 0.4;
    rtDW.INPUT_21_1_1[1] = 0.0;
    rtDW.INPUT_21_1_1[2] = 0.0;
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.INPUT_21_1_1_Discrete[0] = !(rtDW.INPUT_21_1_1[0] ==
        rtDW.INPUT_21_1_1_Discrete[1]);
      rtDW.INPUT_21_1_1_Discrete[1] = rtDW.INPUT_21_1_1[0];
    }

    rtDW.INPUT_21_1_1[0] = rtDW.INPUT_21_1_1_Discrete[1];
    rtDW.INPUT_21_1_1[3] = rtDW.INPUT_21_1_1_Discrete[0];

    /* End of SimscapeInputBlock: '<S380>/INPUT_21_1_1' */

    /* FromWorkspace: '<S20>/From Workspace1' */
    {
      real_T *pDataValues = (real_T *) rtDW.FromWorkspace1_PWORK.DataPtr;
      real_T *pTimeValues = (real_T *) rtDW.FromWorkspace1_PWORK.TimePtr;
      int_T currTimeIndex = rtDW.FromWorkspace1_IWORK.PrevIndex;
      real_T t = rtM->Timing.t[0];

      /* Get index */
      if (t <= pTimeValues[0]) {
        currTimeIndex = 0;
      } else if (t >= pTimeValues[1369]) {
        currTimeIndex = 1368;
      } else {
        if (t < pTimeValues[currTimeIndex]) {
          while (t < pTimeValues[currTimeIndex]) {
            currTimeIndex--;
          }
        } else {
          while (t >= pTimeValues[currTimeIndex + 1]) {
            currTimeIndex++;
          }
        }
      }

      rtDW.FromWorkspace1_IWORK.PrevIndex = currTimeIndex;

      /* Post output */
      {
        real_T t1 = pTimeValues[currTimeIndex];
        real_T t2 = pTimeValues[currTimeIndex + 1];
        if (t1 == t2) {
          if (t < t1) {
            rtb_SUM_f = pDataValues[currTimeIndex];
          } else {
            rtb_SUM_f = pDataValues[currTimeIndex + 1];
          }
        } else {
          real_T f1 = (t2 - t) / (t2 - t1);
          real_T f2 = 1.0 - f1;
          real_T d1;
          real_T d2;
          int_T TimeIndex= currTimeIndex;
          d1 = pDataValues[TimeIndex];
          d2 = pDataValues[TimeIndex + 1];
          rtb_SUM_f = (real_T) rtInterpolate(d1, d2, f1, f2);
          pDataValues += 1370;
        }
      }
    }

    /* Switch: '<S20>/Switch' */
    TransferFcn_b = rtb_SUM_f;

    /* SimscapeInputBlock: '<S380>/INPUT_23_1_1' incorporates:
     *  Switch: '<S20>/Switch'
     */
    rtDW.INPUT_23_1_1[0] = rtb_SUM_f;
    rtDW.INPUT_23_1_1[1] = 0.0;
    rtDW.INPUT_23_1_1[2] = 0.0;
    rtDW.INPUT_23_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_24_1_1' incorporates:
     *  Bias: '<S19>/Bias'
     *  Gain: '<S19>/Gain'
     *  Gain: '<S19>/Max Valve Displacement [m]'
     *  TransferFcn: '<S19>/Transfer Fcn'
     */
    rtDW.INPUT_24_1_1[0] = (2.0 * rtX.TransferFcn_CSTATE_nf + -1.0) * 0.0063;
    rtDW.INPUT_24_1_1[1] = 0.0;
    rtDW.INPUT_24_1_1[2] = 0.0;
    rtDW.INPUT_24_1_1[3] = 0.0;

    /* SimscapeExecutionBlock: '<S380>/STATE_1' incorporates:
     *  SimscapeExecutionBlock: '<S380>/OUTPUT_1_0'
     */
    simulationData = (NeslSimulationData *)rtDW.STATE_1_SimData;
    TransferFcn_fn = rtM->Timing.t[0];
    time = TransferFcn_fn;
    simulationData->mData->mTime.mN = 1;
    simulationData->mData->mTime.mX = &time;
    simulationData->mData->mContStates.mN = 631;
    simulationData->mData->mContStates.mX =
      &rtX.EVThermalManagement_AMPC_2020bB[0];
    simulationData->mData->mDiscStates.mN = 0;
    simulationData->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
    simulationData->mData->mModeVector.mN = 393;
    simulationData->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
    rtb_RelationalOperator1 = false;
    simulationData->mData->mFoundZcEvents = rtb_RelationalOperator1;
    rtb_RelationalOperator1 = rtmIsMajorTimeStep(rtM);
    simulationData->mData->mIsMajorTimeStep = rtb_RelationalOperator1;
    rtb_RelationalOperator = false;
    simulationData->mData->mIsSolverAssertCheck = rtb_RelationalOperator;
    simulationData->mData->mIsSolverCheckingCIC = false;
    rtb_RelationalOperator = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
    simulationData->mData->mIsComputingJacobian = rtb_RelationalOperator;
    simulationData->mData->mIsEvaluatingF0 = false;
    simulationData->mData->mIsSolverRequestingReset = false;
    tmp_1[0] = 0;
    tmp_0[0] = rtDW.INPUT_1_1_1[0];
    tmp_0[1] = rtDW.INPUT_1_1_1[1];
    tmp_0[2] = rtDW.INPUT_1_1_1[2];
    tmp_0[3] = rtDW.INPUT_1_1_1[3];
    tmp_1[1] = 4;
    tmp_0[4] = rtDW.INPUT_2_1_1[0];
    tmp_0[5] = rtDW.INPUT_2_1_1[1];
    tmp_0[6] = rtDW.INPUT_2_1_1[2];
    tmp_0[7] = rtDW.INPUT_2_1_1[3];
    tmp_1[2] = 8;
    tmp_0[8] = rtDW.INPUT_3_1_1[0];
    tmp_0[9] = rtDW.INPUT_3_1_1[1];
    tmp_0[10] = rtDW.INPUT_3_1_1[2];
    tmp_0[11] = rtDW.INPUT_3_1_1[3];
    tmp_1[3] = 12;
    tmp_0[12] = rtDW.INPUT_4_1_1[0];
    tmp_0[13] = rtDW.INPUT_4_1_1[1];
    tmp_0[14] = rtDW.INPUT_4_1_1[2];
    tmp_0[15] = rtDW.INPUT_4_1_1[3];
    tmp_1[4] = 16;
    tmp_0[16] = rtDW.INPUT_5_1_1[0];
    tmp_0[17] = rtDW.INPUT_5_1_1[1];
    tmp_0[18] = rtDW.INPUT_5_1_1[2];
    tmp_0[19] = rtDW.INPUT_5_1_1[3];
    tmp_1[5] = 20;
    tmp_0[20] = rtDW.INPUT_6_1_1[0];
    tmp_0[21] = rtDW.INPUT_6_1_1[1];
    tmp_0[22] = rtDW.INPUT_6_1_1[2];
    tmp_0[23] = rtDW.INPUT_6_1_1[3];
    tmp_1[6] = 24;
    tmp_0[24] = rtDW.INPUT_10_1_1[0];
    tmp_0[25] = rtDW.INPUT_10_1_1[1];
    tmp_0[26] = rtDW.INPUT_10_1_1[2];
    tmp_0[27] = rtDW.INPUT_10_1_1[3];
    tmp_1[7] = 28;
    tmp_0[28] = rtDW.INPUT_8_1_1[0];
    tmp_0[29] = rtDW.INPUT_8_1_1[1];
    tmp_0[30] = rtDW.INPUT_8_1_1[2];
    tmp_0[31] = rtDW.INPUT_8_1_1[3];
    tmp_1[8] = 32;
    tmp_0[32] = rtDW.INPUT_7_1_1[0];
    tmp_0[33] = rtDW.INPUT_7_1_1[1];
    tmp_0[34] = rtDW.INPUT_7_1_1[2];
    tmp_0[35] = rtDW.INPUT_7_1_1[3];
    tmp_1[9] = 36;
    tmp_0[36] = rtDW.INPUT_9_1_1[0];
    tmp_0[37] = rtDW.INPUT_9_1_1[1];
    tmp_0[38] = rtDW.INPUT_9_1_1[2];
    tmp_0[39] = rtDW.INPUT_9_1_1[3];
    tmp_1[10] = 40;
    tmp_0[40] = rtDW.INPUT_11_1_1[0];
    tmp_0[41] = rtDW.INPUT_11_1_1[1];
    tmp_0[42] = rtDW.INPUT_11_1_1[2];
    tmp_0[43] = rtDW.INPUT_11_1_1[3];
    tmp_1[11] = 44;
    tmp_0[44] = rtDW.INPUT_12_1_1[0];
    tmp_0[45] = rtDW.INPUT_12_1_1[1];
    tmp_0[46] = rtDW.INPUT_12_1_1[2];
    tmp_0[47] = rtDW.INPUT_12_1_1[3];
    tmp_1[12] = 48;
    tmp_0[48] = rtDW.INPUT_13_1_1[0];
    tmp_0[49] = rtDW.INPUT_13_1_1[1];
    tmp_0[50] = rtDW.INPUT_13_1_1[2];
    tmp_0[51] = rtDW.INPUT_13_1_1[3];
    tmp_1[13] = 52;
    tmp_0[52] = rtDW.INPUT_14_1_1[0];
    tmp_0[53] = rtDW.INPUT_14_1_1[1];
    tmp_0[54] = rtDW.INPUT_14_1_1[2];
    tmp_0[55] = rtDW.INPUT_14_1_1[3];
    tmp_1[14] = 56;
    tmp_0[56] = rtDW.INPUT_15_1_1[0];
    tmp_0[57] = rtDW.INPUT_15_1_1[1];
    tmp_0[58] = rtDW.INPUT_15_1_1[2];
    tmp_0[59] = rtDW.INPUT_15_1_1[3];
    tmp_1[15] = 60;
    tmp_0[60] = rtDW.INPUT_16_1_1[0];
    tmp_0[61] = rtDW.INPUT_16_1_1[1];
    tmp_0[62] = rtDW.INPUT_16_1_1[2];
    tmp_0[63] = rtDW.INPUT_16_1_1[3];
    tmp_1[16] = 64;
    tmp_0[64] = rtDW.INPUT_17_1_1[0];
    tmp_0[65] = rtDW.INPUT_17_1_1[1];
    tmp_0[66] = rtDW.INPUT_17_1_1[2];
    tmp_0[67] = rtDW.INPUT_17_1_1[3];
    tmp_1[17] = 68;
    tmp_0[68] = rtDW.INPUT_18_1_1[0];
    tmp_0[69] = rtDW.INPUT_18_1_1[1];
    tmp_0[70] = rtDW.INPUT_18_1_1[2];
    tmp_0[71] = rtDW.INPUT_18_1_1[3];
    tmp_1[18] = 72;
    tmp_0[72] = rtDW.INPUT_22_1_1[0];
    tmp_0[73] = rtDW.INPUT_22_1_1[1];
    tmp_0[74] = rtDW.INPUT_22_1_1[2];
    tmp_0[75] = rtDW.INPUT_22_1_1[3];
    tmp_1[19] = 76;
    tmp_0[76] = rtDW.INPUT_20_1_1[0];
    tmp_0[77] = rtDW.INPUT_20_1_1[1];
    tmp_0[78] = rtDW.INPUT_20_1_1[2];
    tmp_0[79] = rtDW.INPUT_20_1_1[3];
    tmp_1[20] = 80;
    tmp_0[80] = rtDW.INPUT_19_1_1[0];
    tmp_0[81] = rtDW.INPUT_19_1_1[1];
    tmp_0[82] = rtDW.INPUT_19_1_1[2];
    tmp_0[83] = rtDW.INPUT_19_1_1[3];
    tmp_1[21] = 84;
    tmp_0[84] = rtDW.INPUT_21_1_1[0];
    tmp_0[85] = rtDW.INPUT_21_1_1[1];
    tmp_0[86] = rtDW.INPUT_21_1_1[2];
    tmp_0[87] = rtDW.INPUT_21_1_1[3];
    tmp_1[22] = 88;
    tmp_0[88] = rtDW.INPUT_23_1_1[0];
    tmp_0[89] = rtDW.INPUT_23_1_1[1];
    tmp_0[90] = rtDW.INPUT_23_1_1[2];
    tmp_0[91] = rtDW.INPUT_23_1_1[3];
    tmp_1[23] = 92;
    tmp_0[92] = rtDW.INPUT_24_1_1[0];
    tmp_0[93] = rtDW.INPUT_24_1_1[1];
    tmp_0[94] = rtDW.INPUT_24_1_1[2];
    tmp_0[95] = rtDW.INPUT_24_1_1[3];
    tmp_1[24] = 96;
    simulationData->mData->mInputValues.mN = 96;
    simulationData->mData->mInputValues.mX = &tmp_0[0];
    simulationData->mData->mInputOffsets.mN = 25;
    simulationData->mData->mInputOffsets.mX = &tmp_1[0];
    simulationData->mData->mOutputs.mN = 1024;
    simulationData->mData->mOutputs.mX = &rtDW.STATE_1[0];
    simulationData->mData->mSampleHits.mN = 0;
    simulationData->mData->mSampleHits.mX = NULL;
    simulationData->mData->mIsFundamentalSampleHit = false;
    simulationData->mData->mTolerances.mN = 0;
    simulationData->mData->mTolerances.mX = NULL;
    simulationData->mData->mCstateHasChanged = false;
    diag = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
    diagTree = neu_diagnostic_manager_get_initial_tree(diag);
    j = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
      NESL_SIM_OUTPUTS, simulationData, diag);
    if (j != 0) {
      rtb_RelationalOperator = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (rtb_RelationalOperator) {
        msg = rtw_diagnostics_msg(diagTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* End of SimscapeExecutionBlock: '<S380>/STATE_1' */

    /* SimscapeInputBlock: '<S380>/INPUT_3_1_1' incorporates:
     *  TransferFcn: '<S377>/Transfer Fcn3'
     */
    rtDW.INPUT_3_1_1[0] = rtX.TransferFcn3_CSTATE;
    rtDW.INPUT_3_1_1[1] = 0.0;
    rtDW.INPUT_3_1_1[2] = 0.0;
    rtDW.INPUT_3_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_11_1_1' incorporates:
     *  TransferFcn: '<S377>/Transfer Fcn4'
     */
    rtDW.INPUT_11_1_1[0] = rtX.TransferFcn4_CSTATE;
    rtDW.INPUT_11_1_1[1] = 0.0;
    rtDW.INPUT_11_1_1[2] = 0.0;
    rtDW.INPUT_11_1_1[3] = 0.0;

    /* Gain: '<S11>/Max Power [W]' incorporates:
     *  TransferFcn: '<S11>/Transfer Fcn'
     */
    TransferFcn3 = 4000.0 * rtX.TransferFcn_CSTATE_fj;

    /* SimscapeInputBlock: '<S380>/INPUT_12_1_1' */
    rtDW.INPUT_12_1_1[0] = TransferFcn3;
    rtDW.INPUT_12_1_1[1] = 0.0;
    rtDW.INPUT_12_1_1[2] = 0.0;
    rtDW.INPUT_12_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_13_1_1' incorporates:
     *  TransferFcn: '<S377>/Transfer Fcn1'
     */
    rtDW.INPUT_13_1_1[0] = rtX.TransferFcn1_CSTATE;
    rtDW.INPUT_13_1_1[1] = 0.0;
    rtDW.INPUT_13_1_1[2] = 0.0;
    rtDW.INPUT_13_1_1[3] = 0.0;

    /* SimscapeInputBlock: '<S380>/INPUT_14_1_1' incorporates:
     *  TransferFcn: '<S377>/Transfer Fcn2'
     */
    rtDW.INPUT_14_1_1[0] = rtX.TransferFcn2_CSTATE;
    rtDW.INPUT_14_1_1[1] = 0.0;
    rtDW.INPUT_14_1_1[2] = 0.0;
    rtDW.INPUT_14_1_1[3] = 0.0;

    /* SimscapeExecutionBlock: '<S380>/OUTPUT_1_0' */
    simulationData = (NeslSimulationData *)rtDW.OUTPUT_1_0_SimData;
    time_0 = TransferFcn_fn;
    simulationData->mData->mTime.mN = 1;
    simulationData->mData->mTime.mX = &time_0;
    simulationData->mData->mContStates.mN = 0;
    simulationData->mData->mContStates.mX = NULL;
    simulationData->mData->mDiscStates.mN = 0;
    simulationData->mData->mDiscStates.mX = &rtDW.OUTPUT_1_0_Discrete;
    simulationData->mData->mModeVector.mN = 0;
    simulationData->mData->mModeVector.mX = &rtDW.OUTPUT_1_0_Modes;
    rtb_RelationalOperator = false;
    simulationData->mData->mFoundZcEvents = rtb_RelationalOperator;
    simulationData->mData->mIsMajorTimeStep = rtb_RelationalOperator1;
    rtb_RelationalOperator1 = false;
    simulationData->mData->mIsSolverAssertCheck = rtb_RelationalOperator1;
    simulationData->mData->mIsSolverCheckingCIC = false;
    simulationData->mData->mIsComputingJacobian = false;
    simulationData->mData->mIsEvaluatingF0 = false;
    simulationData->mData->mIsSolverRequestingReset = false;
    tmp_2[0] = 0;
    rtDW.dv[0] = rtDW.INPUT_1_1_1[0];
    rtDW.dv[1] = rtDW.INPUT_1_1_1[1];
    rtDW.dv[2] = rtDW.INPUT_1_1_1[2];
    rtDW.dv[3] = rtDW.INPUT_1_1_1[3];
    tmp_2[1] = 4;
    rtDW.dv[4] = rtDW.INPUT_2_1_1[0];
    rtDW.dv[5] = rtDW.INPUT_2_1_1[1];
    rtDW.dv[6] = rtDW.INPUT_2_1_1[2];
    rtDW.dv[7] = rtDW.INPUT_2_1_1[3];
    tmp_2[2] = 8;
    rtDW.dv[8] = rtDW.INPUT_3_1_1[0];
    rtDW.dv[9] = rtDW.INPUT_3_1_1[1];
    rtDW.dv[10] = rtDW.INPUT_3_1_1[2];
    rtDW.dv[11] = rtDW.INPUT_3_1_1[3];
    tmp_2[3] = 12;
    rtDW.dv[12] = rtDW.INPUT_4_1_1[0];
    rtDW.dv[13] = rtDW.INPUT_4_1_1[1];
    rtDW.dv[14] = rtDW.INPUT_4_1_1[2];
    rtDW.dv[15] = rtDW.INPUT_4_1_1[3];
    tmp_2[4] = 16;
    rtDW.dv[16] = rtDW.INPUT_5_1_1[0];
    rtDW.dv[17] = rtDW.INPUT_5_1_1[1];
    rtDW.dv[18] = rtDW.INPUT_5_1_1[2];
    rtDW.dv[19] = rtDW.INPUT_5_1_1[3];
    tmp_2[5] = 20;
    rtDW.dv[20] = rtDW.INPUT_6_1_1[0];
    rtDW.dv[21] = rtDW.INPUT_6_1_1[1];
    rtDW.dv[22] = rtDW.INPUT_6_1_1[2];
    rtDW.dv[23] = rtDW.INPUT_6_1_1[3];
    tmp_2[6] = 24;
    rtDW.dv[24] = rtDW.INPUT_10_1_1[0];
    rtDW.dv[25] = rtDW.INPUT_10_1_1[1];
    rtDW.dv[26] = rtDW.INPUT_10_1_1[2];
    rtDW.dv[27] = rtDW.INPUT_10_1_1[3];
    tmp_2[7] = 28;
    rtDW.dv[28] = rtDW.INPUT_8_1_1[0];
    rtDW.dv[29] = rtDW.INPUT_8_1_1[1];
    rtDW.dv[30] = rtDW.INPUT_8_1_1[2];
    rtDW.dv[31] = rtDW.INPUT_8_1_1[3];
    tmp_2[8] = 32;
    rtDW.dv[32] = rtDW.INPUT_7_1_1[0];
    rtDW.dv[33] = rtDW.INPUT_7_1_1[1];
    rtDW.dv[34] = rtDW.INPUT_7_1_1[2];
    rtDW.dv[35] = rtDW.INPUT_7_1_1[3];
    tmp_2[9] = 36;
    rtDW.dv[36] = rtDW.INPUT_9_1_1[0];
    rtDW.dv[37] = rtDW.INPUT_9_1_1[1];
    rtDW.dv[38] = rtDW.INPUT_9_1_1[2];
    rtDW.dv[39] = rtDW.INPUT_9_1_1[3];
    tmp_2[10] = 40;
    rtDW.dv[40] = rtDW.INPUT_11_1_1[0];
    rtDW.dv[41] = rtDW.INPUT_11_1_1[1];
    rtDW.dv[42] = rtDW.INPUT_11_1_1[2];
    rtDW.dv[43] = rtDW.INPUT_11_1_1[3];
    tmp_2[11] = 44;
    rtDW.dv[44] = rtDW.INPUT_12_1_1[0];
    rtDW.dv[45] = rtDW.INPUT_12_1_1[1];
    rtDW.dv[46] = rtDW.INPUT_12_1_1[2];
    rtDW.dv[47] = rtDW.INPUT_12_1_1[3];
    tmp_2[12] = 48;
    rtDW.dv[48] = rtDW.INPUT_13_1_1[0];
    rtDW.dv[49] = rtDW.INPUT_13_1_1[1];
    rtDW.dv[50] = rtDW.INPUT_13_1_1[2];
    rtDW.dv[51] = rtDW.INPUT_13_1_1[3];
    tmp_2[13] = 52;
    rtDW.dv[52] = rtDW.INPUT_14_1_1[0];
    rtDW.dv[53] = rtDW.INPUT_14_1_1[1];
    rtDW.dv[54] = rtDW.INPUT_14_1_1[2];
    rtDW.dv[55] = rtDW.INPUT_14_1_1[3];
    tmp_2[14] = 56;
    rtDW.dv[56] = rtDW.INPUT_15_1_1[0];
    rtDW.dv[57] = rtDW.INPUT_15_1_1[1];
    rtDW.dv[58] = rtDW.INPUT_15_1_1[2];
    rtDW.dv[59] = rtDW.INPUT_15_1_1[3];
    tmp_2[15] = 60;
    rtDW.dv[60] = rtDW.INPUT_16_1_1[0];
    rtDW.dv[61] = rtDW.INPUT_16_1_1[1];
    rtDW.dv[62] = rtDW.INPUT_16_1_1[2];
    rtDW.dv[63] = rtDW.INPUT_16_1_1[3];
    tmp_2[16] = 64;
    rtDW.dv[64] = rtDW.INPUT_17_1_1[0];
    rtDW.dv[65] = rtDW.INPUT_17_1_1[1];
    rtDW.dv[66] = rtDW.INPUT_17_1_1[2];
    rtDW.dv[67] = rtDW.INPUT_17_1_1[3];
    tmp_2[17] = 68;
    rtDW.dv[68] = rtDW.INPUT_18_1_1[0];
    rtDW.dv[69] = rtDW.INPUT_18_1_1[1];
    rtDW.dv[70] = rtDW.INPUT_18_1_1[2];
    rtDW.dv[71] = rtDW.INPUT_18_1_1[3];
    tmp_2[18] = 72;
    rtDW.dv[72] = rtDW.INPUT_22_1_1[0];
    rtDW.dv[73] = rtDW.INPUT_22_1_1[1];
    rtDW.dv[74] = rtDW.INPUT_22_1_1[2];
    rtDW.dv[75] = rtDW.INPUT_22_1_1[3];
    tmp_2[19] = 76;
    rtDW.dv[76] = rtDW.INPUT_20_1_1[0];
    rtDW.dv[77] = rtDW.INPUT_20_1_1[1];
    rtDW.dv[78] = rtDW.INPUT_20_1_1[2];
    rtDW.dv[79] = rtDW.INPUT_20_1_1[3];
    tmp_2[20] = 80;
    rtDW.dv[80] = rtDW.INPUT_19_1_1[0];
    rtDW.dv[81] = rtDW.INPUT_19_1_1[1];
    rtDW.dv[82] = rtDW.INPUT_19_1_1[2];
    rtDW.dv[83] = rtDW.INPUT_19_1_1[3];
    tmp_2[21] = 84;
    rtDW.dv[84] = rtDW.INPUT_21_1_1[0];
    rtDW.dv[85] = rtDW.INPUT_21_1_1[1];
    rtDW.dv[86] = rtDW.INPUT_21_1_1[2];
    rtDW.dv[87] = rtDW.INPUT_21_1_1[3];
    tmp_2[22] = 88;
    rtDW.dv[88] = rtDW.INPUT_23_1_1[0];
    rtDW.dv[89] = rtDW.INPUT_23_1_1[1];
    rtDW.dv[90] = rtDW.INPUT_23_1_1[2];
    rtDW.dv[91] = rtDW.INPUT_23_1_1[3];
    tmp_2[23] = 92;
    rtDW.dv[92] = rtDW.INPUT_24_1_1[0];
    rtDW.dv[93] = rtDW.INPUT_24_1_1[1];
    rtDW.dv[94] = rtDW.INPUT_24_1_1[2];
    rtDW.dv[95] = rtDW.INPUT_24_1_1[3];
    tmp_2[24] = 96;
    memcpy(&rtDW.dv[96], &rtDW.STATE_1[0], sizeof(real_T) << 10U);
    tmp_2[25] = 1120;
    simulationData->mData->mInputValues.mN = 1120;
    simulationData->mData->mInputValues.mX = &rtDW.dv[0];
    simulationData->mData->mInputOffsets.mN = 26;
    simulationData->mData->mInputOffsets.mX = &tmp_2[0];
    simulationData->mData->mOutputs.mN = 102;
    simulationData->mData->mOutputs.mX = &rtDW.OUTPUT_1_0[0];
    simulationData->mData->mSampleHits.mN = 0;
    simulationData->mData->mSampleHits.mX = NULL;
    simulationData->mData->mIsFundamentalSampleHit = false;
    simulationData->mData->mTolerances.mN = 0;
    simulationData->mData->mTolerances.mX = NULL;
    simulationData->mData->mCstateHasChanged = false;
    diag = (NeuDiagnosticManager *)rtDW.OUTPUT_1_0_DiagMgr;
    diagTree = neu_diagnostic_manager_get_initial_tree(diag);
    j = ne_simulator_method((NeslSimulator *)rtDW.OUTPUT_1_0_Simulator,
      NESL_SIM_OUTPUTS, simulationData, diag);
    if (j != 0) {
      rtb_RelationalOperator1 = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (rtb_RelationalOperator1) {
        msg = rtw_diagnostics_msg(diagTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* Sum: '<S7>/Add' incorporates:
     *  Constant: '<S7>/Constant'
     *  Gain: '<S7>/Gain1'
     */
    TransferFcn_c = 0.10471975511965977 * TransferFcn_c + 0.01;

    /* Abs: '<S7>/Abs' incorporates:
     *  TransferFcn: '<S7>/Transfer Fcn1'
     */
    Abs = fabs(0.25 * rtX.TransferFcn1_CSTATE_e);

    /* Gain: '<S343>/EPower_Compressor' incorporates:
     *  Product: '<S343>/MeccPower_Compressor'
     */
    rtDW.EPower_Compressor = TransferFcn_c * Abs * 1.25;

    /* Sum: '<S58>/SUM' incorporates:
     *  Constant: '<S58>/CONSTANT'
     */
    TransferFcn1 = rtDW.OUTPUT_1_0[7] + -273.15;

    /* Sum: '<S60>/SUM' incorporates:
     *  Constant: '<S60>/CONSTANT'
     */
    TransferFcn2 = rtDW.OUTPUT_1_0[8] + -273.15;

    /* Sum: '<S62>/SUM' incorporates:
     *  Constant: '<S62>/CONSTANT'
     */
    TransferFcn4 = rtDW.OUTPUT_1_0[9] + -273.15;

    /* Sum: '<S64>/SUM' incorporates:
     *  Constant: '<S64>/CONSTANT'
     */
    TransferFcn_fn = rtDW.OUTPUT_1_0[10] + -273.15;

    /* MinMax: '<S9>/T_ battery' */
    if ((TransferFcn1 > TransferFcn2) || rtIsNaN(TransferFcn2)) {
      TransferFcn2 = TransferFcn1;
    }

    if ((TransferFcn2 > TransferFcn4) || rtIsNaN(TransferFcn4)) {
      TransferFcn4 = TransferFcn2;
    }

    if ((TransferFcn4 > TransferFcn_fn) || rtIsNaN(TransferFcn_fn)) {
      /* MinMax: '<S9>/T_ battery' */
      rtDW.T_battery = TransferFcn4;
    } else {
      /* MinMax: '<S9>/T_ battery' */
      rtDW.T_battery = TransferFcn_fn;
    }

    /* End of MinMax: '<S9>/T_ battery' */

    /* TransferFcn: '<S273>/Transfer Fcn' */
    TransferFcn_an = 100.0 * rtX.TransferFcn_CSTATE_o;

    /* MATLAB Function: '<S273>/Jacobians' incorporates:
     *  MATLAB Function: '<S12>/R0'
     */
    TransferFcn1 = TransferFcn_an * 0.00328855058229269 + i_battery;
    TransferFcn2 = TransferFcn1 * TransferFcn1;
    TransferFcn1 = (rtDW.T_battery * 0.0009567346938775497 - 0.02658775510204079)
      * TransferFcn2 / 159000.0;
    TransferFcn_fn = rtDW.T_battery * rtDW.T_battery;
    TransferFcn4 = (TransferFcn_fn * 0.00047836734693877491 + -(rtDW.T_battery *
      0.02658775510204079)) + 1.0169795918367339;

    /* MATLAB Function: '<S273>/MATLAB Function' incorporates:
     *  Constant: '<S20>/Temperature [degC]'
     *  MATLAB Function: '<S273>/Jacobians'
     */
    b_idx_0 = ((TransferFcn_an * 2.1629129864595191E-5 + i_battery *
                0.006577101164585381) * TransferFcn4 / 159000.0 +
               1.1430188679245283E-5) - 2.877610062893082E-5;
    b_idx_1 = (TransferFcn_an * 0.006577101164585381 + i_battery * 2.0) *
      TransferFcn4 / 159000.0;
    b_idx_2 = TransferFcn_an * 4.39622641509434E-7;
    TransferFcn2 = TransferFcn_an * -2.758 / 159000.0 + TransferFcn2 *
      TransferFcn4 / 159000.0;
    TransferFcn_an = expmNoLog2(TransferFcn1);
    TransferFcn1 = (((expmNoLog2(TransferFcn1 * 0.25) * 4.0 + (TransferFcn_an +
      1.0)) + expmNoLog2(TransferFcn1 * 2.0 * 0.25) * 2.0) + expmNoLog2
                    (TransferFcn1 * 3.0 * 0.25) * 4.0) * 0.083333333333333329;
    b_idx_0 *= TransferFcn1;
    b_idx_1 *= TransferFcn1;
    b_idx_2 *= TransferFcn1;

    /* RateTransition generated from: '<S307>/FixedHorizonOptimizer' */
    if (rtmIsMajorTimeStep(rtM)) {
      /* RateTransition generated from: '<S307>/FixedHorizonOptimizer' incorporates:
       *  Constant: '<S20>/Temperature [degC]'
       *  DataTypeConversion: '<S279>/Data Type Conversion2'
       *  MATLAB Function: '<S273>/MATLAB Function'
       */
      if (rtM->Timing.RateInteraction.TID1_2 == 1) {
        rtDW.TmpRTBAtFixedHorizonOptimizerIn[0] = b_idx_0;
        rtDW.TmpRTBAtFixedHorizonOptimizerIn[1] = b_idx_1;
        rtDW.TmpRTBAtFixedHorizonOptimizerIn[2] = b_idx_2;
        rtDW.TmpRTBAtFixedHorizonOptimizer_f[0] = 0.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_f[1] = 0.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_f[2] = 0.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_g[0] = rtDW.EPower_Compressor;
        rtDW.TmpRTBAtFixedHorizonOptimizer_g[1] = i_battery;
        rtDW.TmpRTBAtFixedHorizonOptimizer_g[2] = 26.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_o[0] = i_battery;
        rtDW.TmpRTBAtFixedHorizonOptimizer_o[1] = 26.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_c = TransferFcn_an;
        rtDW.TmpRTBAtFixedHorizonOptimizer_p = 1.0;
        rtDW.TmpRTBAtFixedHorizonOptimizer_k = rtDW.T_battery;
        rtDW.TmpRTBAtFixedHorizonOptimizer_d = rtDW.T_battery;
        rtDW.TmpRTBAtFixedHorizonOptimize_cz = TransferFcn1 * TransferFcn2;
        rtDW.TmpRTBAtFixedHorizonOptimizer_a = rtDW.T_battery;
      }

      /* End of RateTransition generated from: '<S307>/FixedHorizonOptimizer' */
    }

    /* End of RateTransition generated from: '<S307>/FixedHorizonOptimizer' */

    /* Relay: '<S310>/Relay' */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.Relay_Mode = ((rtDW.T_battery >= 50.0) || ((!(rtDW.T_battery <= 45.0))
        && rtDW.Relay_Mode));
    }

    if (rtmIsMajorTimeStep(rtM)) {
      /* MinMax: '<S310>/MinMax' incorporates:
       *  Relay: '<S310>/Relay'
       */
      if ((real_T)rtDW.Relay_Mode > 0.5) {
        /* MinMax: '<S310>/MinMax' */
        rtDW.MinMax = rtDW.Relay_Mode;
      } else {
        /* MinMax: '<S310>/MinMax' */
        rtDW.MinMax = 0.5;
      }

      /* End of MinMax: '<S310>/MinMax' */
    }

    /* Sum: '<S348>/SUM' incorporates:
     *  Constant: '<S348>/CONSTANT'
     */
    TransferFcn_an = rtDW.OUTPUT_1_0[100] + -273.15;

    /* Sum: '<S332>/SUM' incorporates:
     *  Lookup_n-D: '<S312>/1-D Lookup Table'
     *  Sum: '<S348>/SUM'
     */
    rtb_SUM_f = look1_plinlx(TransferFcn_an, rtConstP.pooled27,
      rtConstP.pooled26, &rtDW.m_bpIndex_ku, 7U);

    /* Saturate: '<S312>/Saturation' */
    if (rtb_SUM_f > 1.0) {
      /* Saturate: '<S312>/Saturation' */
      rtDW.Saturation = 1.0;
    } else if (rtb_SUM_f < 0.3) {
      /* Saturate: '<S312>/Saturation' */
      rtDW.Saturation = 0.3;
    } else {
      /* Saturate: '<S312>/Saturation' */
      rtDW.Saturation = rtb_SUM_f;
    }

    /* End of Saturate: '<S312>/Saturation' */
    if (rtmIsMajorTimeStep(rtM)) {
      /* Switch: '<S313>/Switch' incorporates:
       *  Constant: '<S313>/Constant'
       */
      rtDW.Switch_l = 0.0;
    }

    /* Switch: '<S310>/Switch' */
    if (rtDW.Switch_l > 0.5) {
      /* Switch: '<S310>/Switch' */
      rtDW.Switch_k = rtDW.Saturation;
    } else {
      /* Switch: '<S310>/Switch' */
      rtDW.Switch_k = rtDW.MinMax;
    }

    /* End of Switch: '<S310>/Switch' */

    /* Sum: '<S332>/SUM' incorporates:
     *  Lookup_n-D: '<S317>/1-D Lookup Table'
     *  Sum: '<S348>/SUM'
     */
    rtb_SUM_f = look1_plinlx(TransferFcn_an, rtConstP.pooled27,
      rtConstP.pooled26, &rtDW.m_bpIndex_i, 7U);

    /* RateTransition generated from: '<S273>/cmd_angVel_rads' */
    if (rtmIsMajorTimeStep(rtM) && (rtM->Timing.RateInteraction.TID1_2 == 1)) {
      /* RateTransition generated from: '<S273>/cmd_angVel_rads' */
      rtDW.TmpRTBAtcmd_angVel_radsInport1 = rtDW.TmpRTBAtcmd_angVel_radsInport1_;
    }

    /* End of RateTransition generated from: '<S273>/cmd_angVel_rads' */

    /* Lookup_n-D: '<S273>/Freezing Cutoff' incorporates:
     *  Switch: '<S273>/Switch'
     */
    TransferFcn_an = look1_plinlx(rtDW.OUTPUT_1_0[48],
      rtConstP.FreezingCutoff_bp01Data, rtConstP.FreezingCutoff_tableData,
      &rtDW.m_bpIndex_o, 3U);

    /* Switch: '<S273>/Switch1' incorporates:
     *  Constant: '<S273>/Constant5'
     *  Switch: '<S273>/Switch'
     */
    if (!(Abs > 0.0001)) {
      Abs = 0.01;
    }

    /* End of Switch: '<S273>/Switch1' */

    /* Switch: '<S273>/Switch' incorporates:
     *  Product: '<S273>/cmd_angVel_rads'
     *  Product: '<S273>/cmd_angVel_rpmNormalized'
     */
    TransferFcn_an *= rtDW.TmpRTBAtcmd_angVel_radsInport1 / Abs;

    /* RelationalOperator: '<S318>/Relational Operator' */
    rtb_RelationalOperator1 = (rtDW.OUTPUT_1_0[92] >= 2.2800000000000002);

    /* RelationalOperator: '<S318>/Relational Operator1' */
    rtb_RelationalOperator = (rtDW.OUTPUT_1_0[92] > 1.8800000000000001);

    /* Sum: '<S318>/Sum' */
    rtb_Sum_p = (uint8_T)((uint32_T)rtb_RelationalOperator1 +
                          rtb_RelationalOperator);

    /* Relay: '<S318>/Relay' incorporates:
     *  DataTypeConversion: '<S318>/Data Type Conversion'
     */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.Relay_Mode_b = ((rtb_Sum_p >= 1.5) || ((!(rtb_Sum_p <= 0.5)) &&
        rtDW.Relay_Mode_b));
    }

    /* RelationalOperator: '<S319>/Relational Operator' */
    rtb_RelationalOperator = (rtDW.OUTPUT_1_0[92] >= 1.7400000000000002);

    /* RelationalOperator: '<S319>/Relational Operator1' */
    rtb_RelationalOperator1 = (rtDW.OUTPUT_1_0[92] > 1.34);

    /* Sum: '<S319>/Sum' */
    rtb_Sum_p = (uint8_T)((uint32_T)rtb_RelationalOperator +
                          rtb_RelationalOperator1);

    /* Relay: '<S319>/Relay' incorporates:
     *  DataTypeConversion: '<S319>/Data Type Conversion'
     */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.Relay_Mode_m = ((rtb_Sum_p >= 1.5) || ((!(rtb_Sum_p <= 0.5)) &&
        rtDW.Relay_Mode_m));
    }

    /* RelationalOperator: '<S320>/Relational Operator' */
    rtb_RelationalOperator = (rtDW.OUTPUT_1_0[92] >= 1.1);

    /* RelationalOperator: '<S320>/Relational Operator1' */
    rtb_RelationalOperator1 = (rtDW.OUTPUT_1_0[92] > 0.8);

    /* Sum: '<S320>/Sum' */
    rtb_Sum_p = (uint8_T)((uint32_T)rtb_RelationalOperator +
                          rtb_RelationalOperator1);

    /* Relay: '<S320>/Relay' incorporates:
     *  DataTypeConversion: '<S320>/Data Type Conversion'
     */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.Relay_Mode_n = ((rtb_Sum_p >= 1.5) || ((!(rtb_Sum_p <= 0.5)) &&
        rtDW.Relay_Mode_n));
    }

    if (rtmIsMajorTimeStep(rtM)) {
      /* Gain: '<S315>/Gain' incorporates:
       *  Relay: '<S318>/Relay'
       *  Relay: '<S319>/Relay'
       *  Relay: '<S320>/Relay'
       *  Sum: '<S315>/Sum'
       */
      rtDW.Gain_kb = (((real_T)rtDW.Relay_Mode_b + (real_T)rtDW.Relay_Mode_m) +
                      (real_T)rtDW.Relay_Mode_n) * 0.33333333333333331;
    }

    /* Sum: '<S330>/SUM' incorporates:
     *  Constant: '<S330>/CONSTANT'
     */
    Abs = rtDW.OUTPUT_1_0[99] + -273.15;

    /* Relay: '<S316>/Relay Level 3' incorporates:
     *  Relay: '<S316>/Relay Level 1'
     *  Relay: '<S316>/Relay Level 2'
     */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.RelayLevel3_Mode = ((Abs >= 95.0) || ((!(Abs <= 86.0)) &&
        rtDW.RelayLevel3_Mode));
      rtDW.RelayLevel2_Mode = ((Abs >= 85.0) || ((!(Abs <= 76.0)) &&
        rtDW.RelayLevel2_Mode));
      rtDW.RelayLevel1_Mode = ((Abs >= 75.0) || ((!(Abs <= 65.0)) &&
        rtDW.RelayLevel1_Mode));
    }

    if (rtmIsMajorTimeStep(rtM)) {
      /* Gain: '<S316>/Gain' incorporates:
       *  Relay: '<S316>/Relay Level 1'
       *  Relay: '<S316>/Relay Level 2'
       *  Relay: '<S316>/Relay Level 3'
       *  Sum: '<S316>/Sum'
       */
      rtDW.Gain_i = (((real_T)rtDW.RelayLevel3_Mode + (real_T)
                      rtDW.RelayLevel2_Mode) + (real_T)rtDW.RelayLevel1_Mode) *
        0.33333333333333331;
    }

    /* Switch: '<S275>/Switch' incorporates:
     *  Constant: '<S275>/Constant'
     */
    if (TransferFcn_an > 0.0) {
      Abs = rtDW.Gain_kb;
    } else {
      Abs = 0.0;
    }

    /* End of Switch: '<S275>/Switch' */

    /* MinMax: '<S275>/MinMax' */
    if ((!(Abs > rtDW.Gain_i)) && (!rtIsNaN(rtDW.Gain_i))) {
      Abs = rtDW.Gain_i;
    }

    if ((!(Abs > rtb_SUM_f)) && (!rtIsNaN(rtb_SUM_f))) {
      Abs = rtb_SUM_f;
    }

    /* End of MinMax: '<S275>/MinMax' */

    /* Lookup_n-D: '<S8>/2-D Lookup Table' incorporates:
     *  Gain: '<S8>/Gain'
     *  Switch: '<S20>/Switch'
     */
    rtDW.uDLookupTable = look2_binlx(TransferFcn_b, 14.4 * Abs,
      rtConstP.uDLookupTable_bp01Data, rtConstP.uDLookupTable_bp02Data,
      rtConstP.uDLookupTable_tableData_l, rtConstP.uDLookupTable_maxIndex, 7U);

    /* Gain: '<S7>/Gain' */
    Abs = 9.5492965855137211 * TransferFcn_an;

    /* Saturate: '<S7>/Saturation' */
    if (Abs > 3600.0) {
      /* Saturate: '<S7>/Saturation' */
      rtDW.Saturation_c = 3600.0;
    } else if (Abs < 0.0) {
      /* Saturate: '<S7>/Saturation' */
      rtDW.Saturation_c = 0.0;
    } else {
      /* Saturate: '<S7>/Saturation' */
      rtDW.Saturation_c = Abs;
    }

    /* End of Saturate: '<S7>/Saturation' */

    /* Integrator: '<S12>/Integrator' */
    rtDW.Integrator = rtX.Integrator_CSTATE;
    if (rtmIsMajorTimeStep(rtM)) {
      /* MATLAB Function: '<S12>/c' incorporates:
       *  Constant: '<S20>/Temperature [degC]'
       */
      rtDW.c = 2.758;
    }

    /* Gain: '<S12>/Gain' incorporates:
     *  Gain: '<S12>/Gain2'
     *  MATLAB Function: '<S12>/R0'
     *  Math: '<S12>/Math Function'
     *  Product: '<S12>/Product'
     *  Product: '<S12>/Product1'
     *  Sum: '<S12>/Add'
     */
    rtDW.Gain_n = (((TransferFcn_fn * 5.9795918367346858E-6 + rtDW.T_battery *
                     -0.00033234693877550988) + 0.01271224489795918) *
                   (i_battery * i_battery) * 80.0 - rtDW.c *
                   rtDW.EPower_Compressor) * 6.2893081761006293E-6;

    /* Product: '<S343>/MeccPower_MotorPump1' incorporates:
     *  Gain: '<S16>/Gain'
     */
    TransferFcn_h = 0.10471975511965977 * TransferFcn_h * rtDW.OUTPUT_1_0[101];

    /* Gain: '<S343>/EPower_MotorPump' */
    TransferFcn_h *= 1.25;

    /* Product: '<S343>/MeccPower_MotorPump' incorporates:
     *  Gain: '<S2>/Gain'
     */
    MaxSpeedrpm = 0.10471975511965977 * MaxSpeedrpm * rtDW.OUTPUT_1_0[24];

    /* Gain: '<S343>/EPower_BatteryPump' */
    MaxSpeedrpm *= 1.25;

    /* Product: '<S1>/iBMScomputation' incorporates:
     *  Sum: '<S1>/EPower_BMS'
     */
    rtDW.iBMScomputation = (((TransferFcn_h + MaxSpeedrpm) +
      rtDW.EPower_Compressor) + TransferFcn3) / rtDW.OUTPUT_1_0[23];

    /* Sum: '<S341>/Add' */
    rtDW.EPower_BTM = (rtDW.EPower_Compressor + MaxSpeedrpm) + TransferFcn_h;

    /* Gain: '<S227>/GAIN' */
    MaxSpeedrpm = 1.0E+9 * rtDW.OUTPUT_1_0[79];

    /* Product: '<S7>/Divide' */
    rtDW.Divide = MaxSpeedrpm / TransferFcn_c;

    /* Sum: '<S332>/SUM' incorporates:
     *  Constant: '<S332>/CONSTANT'
     */
    rtb_SUM_f = rtDW.OUTPUT_1_0[98] + -273.15;

    /* Relay: '<S314>/Relay' */
    if (rtmIsMajorTimeStep(rtM)) {
      rtDW.Relay_Mode_e = ((rtb_SUM_f >= 25.0) || ((!(rtb_SUM_f <= 20.0)) &&
        rtDW.Relay_Mode_e));
    }

    /* Relay: '<S314>/Relay' */
    rtDW.Relay = !rtDW.Relay_Mode_e;

    /* Product: '<S341>/Product1' */
    rtDW.EPower_battery = rtDW.OUTPUT_1_0[23] * i_battery;

    /* Gain: '<S340>/Gain' */
    rtDW.Gain_j = 0.00027777777777777778 * TransferFcn_b;

    /* Sum: '<S379>/Sum' incorporates:
     *  Integrator: '<S379>/Integrator'
     */
    rtDW.Sum = TransferFcn_b - rtX.Integrator_CSTATE_h;
    if (rtmIsMajorTimeStep(rtM)) {
      /* Switch: '<S309>/Switch' incorporates:
       *  Constant: '<S309>/Constant'
       */
      rtDW.Switch_j = 0.0;
    }

    /* FromWorkspace: '<S20>/From Workspace' */
    {
      real_T *pDataValues = (real_T *) rtDW.FromWorkspace_PWORK.DataPtr;
      real_T *pTimeValues = (real_T *) rtDW.FromWorkspace_PWORK.TimePtr;
      int_T currTimeIndex = rtDW.FromWorkspace_IWORK.PrevIndex;
      real_T t = rtM->Timing.t[0];

      /* Get index */
      if (t <= pTimeValues[0]) {
        currTimeIndex = 0;
      } else if (t >= pTimeValues[1369]) {
        currTimeIndex = 1368;
      } else {
        if (t < pTimeValues[currTimeIndex]) {
          while (t < pTimeValues[currTimeIndex]) {
            currTimeIndex--;
          }
        } else {
          while (t >= pTimeValues[currTimeIndex + 1]) {
            currTimeIndex++;
          }
        }
      }

      rtDW.FromWorkspace_IWORK.PrevIndex = currTimeIndex;

      /* Post output */
      {
        real_T t1 = pTimeValues[currTimeIndex];
        real_T t2 = pTimeValues[currTimeIndex + 1];
        if (t1 == t2) {
          if (t < t1) {
            rtb_FromWorkspace = pDataValues[currTimeIndex];
          } else {
            rtb_FromWorkspace = pDataValues[currTimeIndex + 1];
          }
        } else {
          real_T f1 = (t2 - t) / (t2 - t1);
          real_T f2 = 1.0 - f1;
          real_T d1;
          real_T d2;
          int_T TimeIndex= currTimeIndex;
          d1 = pDataValues[TimeIndex];
          d2 = pDataValues[TimeIndex + 1];
          rtb_FromWorkspace = (real_T) rtInterpolate(d1, d2, f1, f2);
          pDataValues += 1370;
        }
      }
    }

    /* Saturate: '<S377>/Saturation' incorporates:
     *  Switch: '<S377>/Switch'
     */
    if (rtb_FromWorkspace >= 200.0) {
      /* Saturate: '<S377>/Saturation' */
      rtDW.Saturation_a = 200.0;
    } else {
      /* Saturate: '<S377>/Saturation' */
      rtDW.Saturation_a = rtb_FromWorkspace;
    }

    /* End of Saturate: '<S377>/Saturation' */

    /* Lookup_n-D: '<S377>/Charger Heat vs Current' incorporates:
     *  Saturate: '<S377>/Saturation'
     */
    rtDW.ChargerHeatvsCurrent = look1_plinlx(rtDW.Saturation_a,
      rtConstP.pooled33, rtConstP.pooled32, &rtDW.m_bpIndex_f, 4U);

    /* Lookup_n-D: '<S377>/DCDC Heat vs Current' incorporates:
     *  Saturate: '<S377>/Saturation'
     */
    rtDW.DCDCHeatvsCurrent = look1_plinlx(rtDW.Saturation_a, rtConstP.pooled33,
      rtConstP.pooled32, &rtDW.m_bpIndex_n, 4U);

    /* Lookup_n-D: '<S377>/Inverter Heat vs Current' incorporates:
     *  Saturate: '<S377>/Saturation'
     */
    rtDW.InverterHeatvsCurrent = look1_plinlx(rtDW.Saturation_a,
      rtConstP.pooled33, rtConstP.pooled32, &rtDW.m_bpIndex_m, 4U);

    /* Lookup_n-D: '<S377>/Motor Heat vs Current' incorporates:
     *  Saturate: '<S377>/Saturation'
     */
    rtDW.MotorHeatvsCurrent = look1_plinlx(rtDW.Saturation_a,
      rtConstP.MotorHeatvsCurrent_bp01Data,
      rtConstP.MotorHeatvsCurrent_tableData, &rtDW.m_bpIndex_e, 8U);
  }

  if (rtmIsMajorTimeStep(rtM)) {
    NeslSimulationData *simulationData_tmp;
    NeuDiagnosticManager *diagnosticManager_tmp;
    NeuDiagnosticTree *diagnosticTree;
    char *msg;
    real_T tmp_1[96];
    real_T tmp_4[96];
    real_T time;
    real_T time_0;
    real_T time_tmp;
    int32_T tmp_3;
    int_T tmp_2[25];
    int_T tmp_5[25];
    boolean_T tmp;
    boolean_T tmp_0;

    /* Update for SimscapeExecutionBlock: '<S380>/STATE_1' */
    simulationData_tmp = (NeslSimulationData *)rtDW.STATE_1_SimData;
    time_tmp = rtM->Timing.t[0];
    time = time_tmp;
    simulationData_tmp->mData->mTime.mN = 1;
    simulationData_tmp->mData->mTime.mX = &time;
    simulationData_tmp->mData->mContStates.mN = 631;
    simulationData_tmp->mData->mContStates.mX =
      &rtX.EVThermalManagement_AMPC_2020bB[0];
    simulationData_tmp->mData->mDiscStates.mN = 0;
    simulationData_tmp->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
    simulationData_tmp->mData->mModeVector.mN = 393;
    simulationData_tmp->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
    tmp = false;
    simulationData_tmp->mData->mFoundZcEvents = tmp;
    tmp = rtmIsMajorTimeStep(rtM);
    simulationData_tmp->mData->mIsMajorTimeStep = tmp;
    tmp_0 = false;
    simulationData_tmp->mData->mIsSolverAssertCheck = tmp_0;
    simulationData_tmp->mData->mIsSolverCheckingCIC = false;
    tmp_0 = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
    simulationData_tmp->mData->mIsComputingJacobian = tmp_0;
    simulationData_tmp->mData->mIsEvaluatingF0 = false;
    simulationData_tmp->mData->mIsSolverRequestingReset = false;
    tmp_2[0] = 0;
    tmp_1[0] = rtDW.INPUT_1_1_1[0];
    tmp_1[1] = rtDW.INPUT_1_1_1[1];
    tmp_1[2] = rtDW.INPUT_1_1_1[2];
    tmp_1[3] = rtDW.INPUT_1_1_1[3];
    tmp_2[1] = 4;
    tmp_1[4] = rtDW.INPUT_2_1_1[0];
    tmp_1[5] = rtDW.INPUT_2_1_1[1];
    tmp_1[6] = rtDW.INPUT_2_1_1[2];
    tmp_1[7] = rtDW.INPUT_2_1_1[3];
    tmp_2[2] = 8;
    tmp_1[8] = rtDW.INPUT_3_1_1[0];
    tmp_1[9] = rtDW.INPUT_3_1_1[1];
    tmp_1[10] = rtDW.INPUT_3_1_1[2];
    tmp_1[11] = rtDW.INPUT_3_1_1[3];
    tmp_2[3] = 12;
    tmp_1[12] = rtDW.INPUT_4_1_1[0];
    tmp_1[13] = rtDW.INPUT_4_1_1[1];
    tmp_1[14] = rtDW.INPUT_4_1_1[2];
    tmp_1[15] = rtDW.INPUT_4_1_1[3];
    tmp_2[4] = 16;
    tmp_1[16] = rtDW.INPUT_5_1_1[0];
    tmp_1[17] = rtDW.INPUT_5_1_1[1];
    tmp_1[18] = rtDW.INPUT_5_1_1[2];
    tmp_1[19] = rtDW.INPUT_5_1_1[3];
    tmp_2[5] = 20;
    tmp_1[20] = rtDW.INPUT_6_1_1[0];
    tmp_1[21] = rtDW.INPUT_6_1_1[1];
    tmp_1[22] = rtDW.INPUT_6_1_1[2];
    tmp_1[23] = rtDW.INPUT_6_1_1[3];
    tmp_2[6] = 24;
    tmp_1[24] = rtDW.INPUT_10_1_1[0];
    tmp_1[25] = rtDW.INPUT_10_1_1[1];
    tmp_1[26] = rtDW.INPUT_10_1_1[2];
    tmp_1[27] = rtDW.INPUT_10_1_1[3];
    tmp_2[7] = 28;
    tmp_1[28] = rtDW.INPUT_8_1_1[0];
    tmp_1[29] = rtDW.INPUT_8_1_1[1];
    tmp_1[30] = rtDW.INPUT_8_1_1[2];
    tmp_1[31] = rtDW.INPUT_8_1_1[3];
    tmp_2[8] = 32;
    tmp_1[32] = rtDW.INPUT_7_1_1[0];
    tmp_1[33] = rtDW.INPUT_7_1_1[1];
    tmp_1[34] = rtDW.INPUT_7_1_1[2];
    tmp_1[35] = rtDW.INPUT_7_1_1[3];
    tmp_2[9] = 36;
    tmp_1[36] = rtDW.INPUT_9_1_1[0];
    tmp_1[37] = rtDW.INPUT_9_1_1[1];
    tmp_1[38] = rtDW.INPUT_9_1_1[2];
    tmp_1[39] = rtDW.INPUT_9_1_1[3];
    tmp_2[10] = 40;
    tmp_1[40] = rtDW.INPUT_11_1_1[0];
    tmp_1[41] = rtDW.INPUT_11_1_1[1];
    tmp_1[42] = rtDW.INPUT_11_1_1[2];
    tmp_1[43] = rtDW.INPUT_11_1_1[3];
    tmp_2[11] = 44;
    tmp_1[44] = rtDW.INPUT_12_1_1[0];
    tmp_1[45] = rtDW.INPUT_12_1_1[1];
    tmp_1[46] = rtDW.INPUT_12_1_1[2];
    tmp_1[47] = rtDW.INPUT_12_1_1[3];
    tmp_2[12] = 48;
    tmp_1[48] = rtDW.INPUT_13_1_1[0];
    tmp_1[49] = rtDW.INPUT_13_1_1[1];
    tmp_1[50] = rtDW.INPUT_13_1_1[2];
    tmp_1[51] = rtDW.INPUT_13_1_1[3];
    tmp_2[13] = 52;
    tmp_1[52] = rtDW.INPUT_14_1_1[0];
    tmp_1[53] = rtDW.INPUT_14_1_1[1];
    tmp_1[54] = rtDW.INPUT_14_1_1[2];
    tmp_1[55] = rtDW.INPUT_14_1_1[3];
    tmp_2[14] = 56;
    tmp_1[56] = rtDW.INPUT_15_1_1[0];
    tmp_1[57] = rtDW.INPUT_15_1_1[1];
    tmp_1[58] = rtDW.INPUT_15_1_1[2];
    tmp_1[59] = rtDW.INPUT_15_1_1[3];
    tmp_2[15] = 60;
    tmp_1[60] = rtDW.INPUT_16_1_1[0];
    tmp_1[61] = rtDW.INPUT_16_1_1[1];
    tmp_1[62] = rtDW.INPUT_16_1_1[2];
    tmp_1[63] = rtDW.INPUT_16_1_1[3];
    tmp_2[16] = 64;
    tmp_1[64] = rtDW.INPUT_17_1_1[0];
    tmp_1[65] = rtDW.INPUT_17_1_1[1];
    tmp_1[66] = rtDW.INPUT_17_1_1[2];
    tmp_1[67] = rtDW.INPUT_17_1_1[3];
    tmp_2[17] = 68;
    tmp_1[68] = rtDW.INPUT_18_1_1[0];
    tmp_1[69] = rtDW.INPUT_18_1_1[1];
    tmp_1[70] = rtDW.INPUT_18_1_1[2];
    tmp_1[71] = rtDW.INPUT_18_1_1[3];
    tmp_2[18] = 72;
    tmp_1[72] = rtDW.INPUT_22_1_1[0];
    tmp_1[73] = rtDW.INPUT_22_1_1[1];
    tmp_1[74] = rtDW.INPUT_22_1_1[2];
    tmp_1[75] = rtDW.INPUT_22_1_1[3];
    tmp_2[19] = 76;
    tmp_1[76] = rtDW.INPUT_20_1_1[0];
    tmp_1[77] = rtDW.INPUT_20_1_1[1];
    tmp_1[78] = rtDW.INPUT_20_1_1[2];
    tmp_1[79] = rtDW.INPUT_20_1_1[3];
    tmp_2[20] = 80;
    tmp_1[80] = rtDW.INPUT_19_1_1[0];
    tmp_1[81] = rtDW.INPUT_19_1_1[1];
    tmp_1[82] = rtDW.INPUT_19_1_1[2];
    tmp_1[83] = rtDW.INPUT_19_1_1[3];
    tmp_2[21] = 84;
    tmp_1[84] = rtDW.INPUT_21_1_1[0];
    tmp_1[85] = rtDW.INPUT_21_1_1[1];
    tmp_1[86] = rtDW.INPUT_21_1_1[2];
    tmp_1[87] = rtDW.INPUT_21_1_1[3];
    tmp_2[22] = 88;
    tmp_1[88] = rtDW.INPUT_23_1_1[0];
    tmp_1[89] = rtDW.INPUT_23_1_1[1];
    tmp_1[90] = rtDW.INPUT_23_1_1[2];
    tmp_1[91] = rtDW.INPUT_23_1_1[3];
    tmp_2[23] = 92;
    tmp_1[92] = rtDW.INPUT_24_1_1[0];
    tmp_1[93] = rtDW.INPUT_24_1_1[1];
    tmp_1[94] = rtDW.INPUT_24_1_1[2];
    tmp_1[95] = rtDW.INPUT_24_1_1[3];
    tmp_2[24] = 96;
    simulationData_tmp->mData->mInputValues.mN = 96;
    simulationData_tmp->mData->mInputValues.mX = &tmp_1[0];
    simulationData_tmp->mData->mInputOffsets.mN = 25;
    simulationData_tmp->mData->mInputOffsets.mX = &tmp_2[0];
    diagnosticManager_tmp = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree
      (diagnosticManager_tmp);
    tmp_3 = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
      NESL_SIM_UPDATE, simulationData_tmp, diagnosticManager_tmp);
    if (tmp_3 != 0) {
      tmp_0 = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (tmp_0) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    simulationData_tmp = (NeslSimulationData *)rtDW.STATE_1_SimData;
    time_0 = time_tmp;
    simulationData_tmp->mData->mTime.mN = 1;
    simulationData_tmp->mData->mTime.mX = &time_0;
    simulationData_tmp->mData->mContStates.mN = 631;
    simulationData_tmp->mData->mContStates.mX =
      &rtX.EVThermalManagement_AMPC_2020bB[0];
    simulationData_tmp->mData->mDiscStates.mN = 0;
    simulationData_tmp->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
    simulationData_tmp->mData->mModeVector.mN = 393;
    simulationData_tmp->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
    tmp_0 = false;
    simulationData_tmp->mData->mFoundZcEvents = tmp_0;
    simulationData_tmp->mData->mIsMajorTimeStep = tmp;
    tmp = false;
    simulationData_tmp->mData->mIsSolverAssertCheck = tmp;
    simulationData_tmp->mData->mIsSolverCheckingCIC = false;
    tmp = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
    simulationData_tmp->mData->mIsComputingJacobian = tmp;
    simulationData_tmp->mData->mIsEvaluatingF0 = false;
    simulationData_tmp->mData->mIsSolverRequestingReset = false;
    tmp_5[0] = 0;
    tmp_4[0] = rtDW.INPUT_1_1_1[0];
    tmp_4[1] = rtDW.INPUT_1_1_1[1];
    tmp_4[2] = rtDW.INPUT_1_1_1[2];
    tmp_4[3] = rtDW.INPUT_1_1_1[3];
    tmp_5[1] = 4;
    tmp_4[4] = rtDW.INPUT_2_1_1[0];
    tmp_4[5] = rtDW.INPUT_2_1_1[1];
    tmp_4[6] = rtDW.INPUT_2_1_1[2];
    tmp_4[7] = rtDW.INPUT_2_1_1[3];
    tmp_5[2] = 8;
    tmp_4[8] = rtDW.INPUT_3_1_1[0];
    tmp_4[9] = rtDW.INPUT_3_1_1[1];
    tmp_4[10] = rtDW.INPUT_3_1_1[2];
    tmp_4[11] = rtDW.INPUT_3_1_1[3];
    tmp_5[3] = 12;
    tmp_4[12] = rtDW.INPUT_4_1_1[0];
    tmp_4[13] = rtDW.INPUT_4_1_1[1];
    tmp_4[14] = rtDW.INPUT_4_1_1[2];
    tmp_4[15] = rtDW.INPUT_4_1_1[3];
    tmp_5[4] = 16;
    tmp_4[16] = rtDW.INPUT_5_1_1[0];
    tmp_4[17] = rtDW.INPUT_5_1_1[1];
    tmp_4[18] = rtDW.INPUT_5_1_1[2];
    tmp_4[19] = rtDW.INPUT_5_1_1[3];
    tmp_5[5] = 20;
    tmp_4[20] = rtDW.INPUT_6_1_1[0];
    tmp_4[21] = rtDW.INPUT_6_1_1[1];
    tmp_4[22] = rtDW.INPUT_6_1_1[2];
    tmp_4[23] = rtDW.INPUT_6_1_1[3];
    tmp_5[6] = 24;
    tmp_4[24] = rtDW.INPUT_10_1_1[0];
    tmp_4[25] = rtDW.INPUT_10_1_1[1];
    tmp_4[26] = rtDW.INPUT_10_1_1[2];
    tmp_4[27] = rtDW.INPUT_10_1_1[3];
    tmp_5[7] = 28;
    tmp_4[28] = rtDW.INPUT_8_1_1[0];
    tmp_4[29] = rtDW.INPUT_8_1_1[1];
    tmp_4[30] = rtDW.INPUT_8_1_1[2];
    tmp_4[31] = rtDW.INPUT_8_1_1[3];
    tmp_5[8] = 32;
    tmp_4[32] = rtDW.INPUT_7_1_1[0];
    tmp_4[33] = rtDW.INPUT_7_1_1[1];
    tmp_4[34] = rtDW.INPUT_7_1_1[2];
    tmp_4[35] = rtDW.INPUT_7_1_1[3];
    tmp_5[9] = 36;
    tmp_4[36] = rtDW.INPUT_9_1_1[0];
    tmp_4[37] = rtDW.INPUT_9_1_1[1];
    tmp_4[38] = rtDW.INPUT_9_1_1[2];
    tmp_4[39] = rtDW.INPUT_9_1_1[3];
    tmp_5[10] = 40;
    tmp_4[40] = rtDW.INPUT_11_1_1[0];
    tmp_4[41] = rtDW.INPUT_11_1_1[1];
    tmp_4[42] = rtDW.INPUT_11_1_1[2];
    tmp_4[43] = rtDW.INPUT_11_1_1[3];
    tmp_5[11] = 44;
    tmp_4[44] = rtDW.INPUT_12_1_1[0];
    tmp_4[45] = rtDW.INPUT_12_1_1[1];
    tmp_4[46] = rtDW.INPUT_12_1_1[2];
    tmp_4[47] = rtDW.INPUT_12_1_1[3];
    tmp_5[12] = 48;
    tmp_4[48] = rtDW.INPUT_13_1_1[0];
    tmp_4[49] = rtDW.INPUT_13_1_1[1];
    tmp_4[50] = rtDW.INPUT_13_1_1[2];
    tmp_4[51] = rtDW.INPUT_13_1_1[3];
    tmp_5[13] = 52;
    tmp_4[52] = rtDW.INPUT_14_1_1[0];
    tmp_4[53] = rtDW.INPUT_14_1_1[1];
    tmp_4[54] = rtDW.INPUT_14_1_1[2];
    tmp_4[55] = rtDW.INPUT_14_1_1[3];
    tmp_5[14] = 56;
    tmp_4[56] = rtDW.INPUT_15_1_1[0];
    tmp_4[57] = rtDW.INPUT_15_1_1[1];
    tmp_4[58] = rtDW.INPUT_15_1_1[2];
    tmp_4[59] = rtDW.INPUT_15_1_1[3];
    tmp_5[15] = 60;
    tmp_4[60] = rtDW.INPUT_16_1_1[0];
    tmp_4[61] = rtDW.INPUT_16_1_1[1];
    tmp_4[62] = rtDW.INPUT_16_1_1[2];
    tmp_4[63] = rtDW.INPUT_16_1_1[3];
    tmp_5[16] = 64;
    tmp_4[64] = rtDW.INPUT_17_1_1[0];
    tmp_4[65] = rtDW.INPUT_17_1_1[1];
    tmp_4[66] = rtDW.INPUT_17_1_1[2];
    tmp_4[67] = rtDW.INPUT_17_1_1[3];
    tmp_5[17] = 68;
    tmp_4[68] = rtDW.INPUT_18_1_1[0];
    tmp_4[69] = rtDW.INPUT_18_1_1[1];
    tmp_4[70] = rtDW.INPUT_18_1_1[2];
    tmp_4[71] = rtDW.INPUT_18_1_1[3];
    tmp_5[18] = 72;
    tmp_4[72] = rtDW.INPUT_22_1_1[0];
    tmp_4[73] = rtDW.INPUT_22_1_1[1];
    tmp_4[74] = rtDW.INPUT_22_1_1[2];
    tmp_4[75] = rtDW.INPUT_22_1_1[3];
    tmp_5[19] = 76;
    tmp_4[76] = rtDW.INPUT_20_1_1[0];
    tmp_4[77] = rtDW.INPUT_20_1_1[1];
    tmp_4[78] = rtDW.INPUT_20_1_1[2];
    tmp_4[79] = rtDW.INPUT_20_1_1[3];
    tmp_5[20] = 80;
    tmp_4[80] = rtDW.INPUT_19_1_1[0];
    tmp_4[81] = rtDW.INPUT_19_1_1[1];
    tmp_4[82] = rtDW.INPUT_19_1_1[2];
    tmp_4[83] = rtDW.INPUT_19_1_1[3];
    tmp_5[21] = 84;
    tmp_4[84] = rtDW.INPUT_21_1_1[0];
    tmp_4[85] = rtDW.INPUT_21_1_1[1];
    tmp_4[86] = rtDW.INPUT_21_1_1[2];
    tmp_4[87] = rtDW.INPUT_21_1_1[3];
    tmp_5[22] = 88;
    tmp_4[88] = rtDW.INPUT_23_1_1[0];
    tmp_4[89] = rtDW.INPUT_23_1_1[1];
    tmp_4[90] = rtDW.INPUT_23_1_1[2];
    tmp_4[91] = rtDW.INPUT_23_1_1[3];
    tmp_5[23] = 92;
    tmp_4[92] = rtDW.INPUT_24_1_1[0];
    tmp_4[93] = rtDW.INPUT_24_1_1[1];
    tmp_4[94] = rtDW.INPUT_24_1_1[2];
    tmp_4[95] = rtDW.INPUT_24_1_1[3];
    tmp_5[24] = 96;
    simulationData_tmp->mData->mInputValues.mN = 96;
    simulationData_tmp->mData->mInputValues.mX = &tmp_4[0];
    simulationData_tmp->mData->mInputOffsets.mN = 25;
    simulationData_tmp->mData->mInputOffsets.mX = &tmp_5[0];
    diagnosticManager_tmp = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree
      (diagnosticManager_tmp);
    tmp_3 = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
      NESL_SIM_UPDATE, simulationData_tmp, diagnosticManager_tmp);
    if (tmp_3 != 0) {
      tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (tmp) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* End of Update for SimscapeExecutionBlock: '<S380>/STATE_1' */
  }                                    /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(rtM)) {
    rt_ertODEUpdateContinuousStates(&rtM->solverInfo);

    /* Update absolute time */
    /* The "clockTick0" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick0"
     * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
     * overflow during the application lifespan selected.
     */
    ++rtM->Timing.clockTick0;
    rtM->Timing.t[0] = rtsiGetSolverStopTime(&rtM->solverInfo);

    /* Update absolute time */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The resolution of this integer timer is 0.01, which is the step size
     * of the task. Size of "clockTick1" ensures timer will not overflow during the
     * application lifespan selected.
     */
    rtM->Timing.clockTick1++;
  }                                    /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void EVThermalManagement_AMPC_2020b_derivatives(void)
{
  NeslSimulationData *simulationData;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  XDot *_rtXdot;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  int_T tmp_1[25];
  int_T is;
  boolean_T tmp;
  _rtXdot = ((XDot *) rtM->derivs);

  /* Derivatives for TransferFcn: '<S377>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE = 0.0;
  _rtXdot->TransferFcn_CSTATE += -rtX.TransferFcn_CSTATE;
  _rtXdot->TransferFcn_CSTATE += rtDW.Saturation_a;

  /* Derivatives for TransferFcn: '<S1>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_b = 0.0;
  _rtXdot->TransferFcn_CSTATE_b += -rtX.TransferFcn_CSTATE_b;
  _rtXdot->TransferFcn_CSTATE_b += rtDW.iBMScomputation;

  /* Derivatives for TransferFcn: '<S2>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_j = 0.0;
  _rtXdot->TransferFcn_CSTATE_j += -0.2 * rtX.TransferFcn_CSTATE_j;
  _rtXdot->TransferFcn_CSTATE_j += rtDW.Switch_k;

  /* Derivatives for TransferFcn: '<S5>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_n = 0.0;
  _rtXdot->TransferFcn_CSTATE_n += -rtX.TransferFcn_CSTATE_n;

  /* Derivatives for TransferFcn: '<S7>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_f = 0.0;
  _rtXdot->TransferFcn_CSTATE_f += -0.2 * rtX.TransferFcn_CSTATE_f;
  _rtXdot->TransferFcn_CSTATE_f += rtDW.Saturation_c;

  /* Derivatives for TransferFcn: '<S8>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_jk = 0.0;
  _rtXdot->TransferFcn_CSTATE_jk += -0.2 * rtX.TransferFcn_CSTATE_jk;
  _rtXdot->TransferFcn_CSTATE_jk += rtDW.uDLookupTable;

  /* Derivatives for TransferFcn: '<S16>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_p = 0.0;
  _rtXdot->TransferFcn_CSTATE_p += -0.2 * rtX.TransferFcn_CSTATE_p;
  _rtXdot->TransferFcn_CSTATE_p += rtDW.Saturation;

  /* Derivatives for TransferFcn: '<S17>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_pv = 0.0;
  _rtXdot->TransferFcn_CSTATE_pv += -rtX.TransferFcn_CSTATE_pv;
  _rtXdot->TransferFcn_CSTATE_pv += rtDW.Switch_l;

  /* Derivatives for TransferFcn: '<S19>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_nf = 0.0;
  _rtXdot->TransferFcn_CSTATE_nf += -rtX.TransferFcn_CSTATE_nf;
  _rtXdot->TransferFcn_CSTATE_nf += rtDW.Relay;

  /* Derivatives for SimscapeExecutionBlock: '<S380>/STATE_1' */
  simulationData = (NeslSimulationData *)rtDW.STATE_1_SimData;
  time = rtM->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 631;
  simulationData->mData->mContStates.mX = &rtX.EVThermalManagement_AMPC_2020bB[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX = &rtDW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 393;
  simulationData->mData->mModeVector.mX = &rtDW.STATE_1_Modes[0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep(rtM);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&rtM->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = rtDW.INPUT_1_1_1[0];
  tmp_0[1] = rtDW.INPUT_1_1_1[1];
  tmp_0[2] = rtDW.INPUT_1_1_1[2];
  tmp_0[3] = rtDW.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = rtDW.INPUT_2_1_1[0];
  tmp_0[5] = rtDW.INPUT_2_1_1[1];
  tmp_0[6] = rtDW.INPUT_2_1_1[2];
  tmp_0[7] = rtDW.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = rtDW.INPUT_3_1_1[0];
  tmp_0[9] = rtDW.INPUT_3_1_1[1];
  tmp_0[10] = rtDW.INPUT_3_1_1[2];
  tmp_0[11] = rtDW.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = rtDW.INPUT_4_1_1[0];
  tmp_0[13] = rtDW.INPUT_4_1_1[1];
  tmp_0[14] = rtDW.INPUT_4_1_1[2];
  tmp_0[15] = rtDW.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = rtDW.INPUT_5_1_1[0];
  tmp_0[17] = rtDW.INPUT_5_1_1[1];
  tmp_0[18] = rtDW.INPUT_5_1_1[2];
  tmp_0[19] = rtDW.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = rtDW.INPUT_6_1_1[0];
  tmp_0[21] = rtDW.INPUT_6_1_1[1];
  tmp_0[22] = rtDW.INPUT_6_1_1[2];
  tmp_0[23] = rtDW.INPUT_6_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = rtDW.INPUT_10_1_1[0];
  tmp_0[25] = rtDW.INPUT_10_1_1[1];
  tmp_0[26] = rtDW.INPUT_10_1_1[2];
  tmp_0[27] = rtDW.INPUT_10_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = rtDW.INPUT_8_1_1[0];
  tmp_0[29] = rtDW.INPUT_8_1_1[1];
  tmp_0[30] = rtDW.INPUT_8_1_1[2];
  tmp_0[31] = rtDW.INPUT_8_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = rtDW.INPUT_7_1_1[0];
  tmp_0[33] = rtDW.INPUT_7_1_1[1];
  tmp_0[34] = rtDW.INPUT_7_1_1[2];
  tmp_0[35] = rtDW.INPUT_7_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = rtDW.INPUT_9_1_1[0];
  tmp_0[37] = rtDW.INPUT_9_1_1[1];
  tmp_0[38] = rtDW.INPUT_9_1_1[2];
  tmp_0[39] = rtDW.INPUT_9_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = rtDW.INPUT_11_1_1[0];
  tmp_0[41] = rtDW.INPUT_11_1_1[1];
  tmp_0[42] = rtDW.INPUT_11_1_1[2];
  tmp_0[43] = rtDW.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = rtDW.INPUT_12_1_1[0];
  tmp_0[45] = rtDW.INPUT_12_1_1[1];
  tmp_0[46] = rtDW.INPUT_12_1_1[2];
  tmp_0[47] = rtDW.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = rtDW.INPUT_13_1_1[0];
  tmp_0[49] = rtDW.INPUT_13_1_1[1];
  tmp_0[50] = rtDW.INPUT_13_1_1[2];
  tmp_0[51] = rtDW.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = rtDW.INPUT_14_1_1[0];
  tmp_0[53] = rtDW.INPUT_14_1_1[1];
  tmp_0[54] = rtDW.INPUT_14_1_1[2];
  tmp_0[55] = rtDW.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = rtDW.INPUT_15_1_1[0];
  tmp_0[57] = rtDW.INPUT_15_1_1[1];
  tmp_0[58] = rtDW.INPUT_15_1_1[2];
  tmp_0[59] = rtDW.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = rtDW.INPUT_16_1_1[0];
  tmp_0[61] = rtDW.INPUT_16_1_1[1];
  tmp_0[62] = rtDW.INPUT_16_1_1[2];
  tmp_0[63] = rtDW.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = rtDW.INPUT_17_1_1[0];
  tmp_0[65] = rtDW.INPUT_17_1_1[1];
  tmp_0[66] = rtDW.INPUT_17_1_1[2];
  tmp_0[67] = rtDW.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = rtDW.INPUT_18_1_1[0];
  tmp_0[69] = rtDW.INPUT_18_1_1[1];
  tmp_0[70] = rtDW.INPUT_18_1_1[2];
  tmp_0[71] = rtDW.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = rtDW.INPUT_22_1_1[0];
  tmp_0[73] = rtDW.INPUT_22_1_1[1];
  tmp_0[74] = rtDW.INPUT_22_1_1[2];
  tmp_0[75] = rtDW.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = rtDW.INPUT_20_1_1[0];
  tmp_0[77] = rtDW.INPUT_20_1_1[1];
  tmp_0[78] = rtDW.INPUT_20_1_1[2];
  tmp_0[79] = rtDW.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = rtDW.INPUT_19_1_1[0];
  tmp_0[81] = rtDW.INPUT_19_1_1[1];
  tmp_0[82] = rtDW.INPUT_19_1_1[2];
  tmp_0[83] = rtDW.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = rtDW.INPUT_21_1_1[0];
  tmp_0[85] = rtDW.INPUT_21_1_1[1];
  tmp_0[86] = rtDW.INPUT_21_1_1[2];
  tmp_0[87] = rtDW.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = rtDW.INPUT_23_1_1[0];
  tmp_0[89] = rtDW.INPUT_23_1_1[1];
  tmp_0[90] = rtDW.INPUT_23_1_1[2];
  tmp_0[91] = rtDW.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = rtDW.INPUT_24_1_1[0];
  tmp_0[93] = rtDW.INPUT_24_1_1[1];
  tmp_0[94] = rtDW.INPUT_24_1_1[2];
  tmp_0[95] = rtDW.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulationData->mData->mDx.mN = 631;
  simulationData->mData->mDx.mX = &_rtXdot->EVThermalManagement_AMPC_2020bB[0];
  diagnosticManager = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  is = ne_simulator_method((NeslSimulator *)rtDW.STATE_1_Simulator,
    NESL_SIM_DERIVATIVES, simulationData, diagnosticManager);
  if (is != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(rtM, msg);
    }
  }

  /* End of Derivatives for SimscapeExecutionBlock: '<S380>/STATE_1' */

  /* Derivatives for TransferFcn: '<S377>/Transfer Fcn3' */
  _rtXdot->TransferFcn3_CSTATE = 0.0;
  _rtXdot->TransferFcn3_CSTATE += -rtX.TransferFcn3_CSTATE;
  _rtXdot->TransferFcn3_CSTATE += rtDW.ChargerHeatvsCurrent;

  /* Derivatives for TransferFcn: '<S377>/Transfer Fcn4' */
  _rtXdot->TransferFcn4_CSTATE = 0.0;
  _rtXdot->TransferFcn4_CSTATE += -rtX.TransferFcn4_CSTATE;
  _rtXdot->TransferFcn4_CSTATE += rtDW.DCDCHeatvsCurrent;

  /* Derivatives for TransferFcn: '<S11>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_fj = 0.0;
  _rtXdot->TransferFcn_CSTATE_fj += -rtX.TransferFcn_CSTATE_fj;
  _rtXdot->TransferFcn_CSTATE_fj += rtDW.Switch_j;

  /* Derivatives for TransferFcn: '<S377>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE = 0.0;
  _rtXdot->TransferFcn1_CSTATE += -rtX.TransferFcn1_CSTATE;
  _rtXdot->TransferFcn1_CSTATE += rtDW.InverterHeatvsCurrent;

  /* Derivatives for TransferFcn: '<S377>/Transfer Fcn2' */
  _rtXdot->TransferFcn2_CSTATE = 0.0;
  _rtXdot->TransferFcn2_CSTATE += -rtX.TransferFcn2_CSTATE;
  _rtXdot->TransferFcn2_CSTATE += rtDW.MotorHeatvsCurrent;

  /* Derivatives for TransferFcn: '<S7>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE_e = 0.0;
  _rtXdot->TransferFcn1_CSTATE_e += -0.25 * rtX.TransferFcn1_CSTATE_e;
  _rtXdot->TransferFcn1_CSTATE_e += rtDW.Divide;

  /* Derivatives for TransferFcn: '<S273>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_o = 0.0;
  _rtXdot->TransferFcn_CSTATE_o += -100.0 * rtX.TransferFcn_CSTATE_o;
  _rtXdot->TransferFcn_CSTATE_o += rtDW.EPower_Compressor;

  /* Derivatives for Integrator: '<S12>/Integrator' */
  _rtXdot->Integrator_CSTATE = rtDW.Gain_n;

  /* Derivatives for Integrator: '<S379>/Integrator' */
  _rtXdot->Integrator_CSTATE_h = rtDW.Sum;

  /* Derivatives for Integrator: '<S340>/Integrator' */
  _rtXdot->Integrator_CSTATE_l = rtDW.Gain_j;

  /* Derivatives for Integrator: '<S341>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = rtDW.EPower_BTM;

  /* Derivatives for Integrator: '<S341>/Integrator' */
  _rtXdot->Integrator_CSTATE_g = rtDW.EPower_battery;

  /* Derivatives for Integrator: '<S343>/Integrator2' incorporates:
   *  Constant: '<S343>/Constant'
   */
  _rtXdot->Integrator2_CSTATE = 0.0;

  /* Derivatives for Integrator: '<S343>/Integrator' */
  _rtXdot->Integrator_CSTATE_m = rtDW.EPower_Compressor;
}

/* Model step function for TID2 */
void EVThermalManagement_AMPC_2020b_step2(void) /* Sample time: [1.0s, 0.0s] */
{
  {
    static const real_T s_1[170] = { 0.010407547169811321, 0.020815094339622642,
      0.031222641509433963, 0.041630188679245284, 0.052037735849056604,
      0.062445283018867925, 0.072852830188679246, 0.083260377358490567,
      0.093667924528301888, -0.010407547169811321, -0.020815094339622642,
      -0.031222641509433963, -0.041630188679245284, -0.052037735849056604,
      -0.062445283018867925, -0.072852830188679246, -0.083260377358490567,
      -0.093667924528301888, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, -1.0,
      -0.0, -0.0, -0.0, 1.0, 0.0, 0.0, 0.0, -0.0, 0.010407547169811321,
      0.020815094339622642, 0.031222641509433963, 0.041630188679245284,
      0.052037735849056604, 0.062445283018867925, 0.072852830188679246,
      0.083260377358490567, 0.0, -0.010407547169811321, -0.020815094339622642,
      -0.031222641509433963, -0.041630188679245284, -0.052037735849056604,
      -0.062445283018867925, -0.072852830188679246, -0.083260377358490567, -0.0,
      -1.0, -1.0, -1.0, 0.0, 1.0, 1.0, 1.0, -0.0, -1.0, -0.0, -0.0, 0.0, 1.0,
      0.0, 0.0, -0.0, -0.0, 0.010407547169811321, 0.020815094339622642,
      0.031222641509433963, 0.041630188679245284, 0.052037735849056604,
      0.062445283018867925, 0.072852830188679246, 0.0, 0.0,
      -0.010407547169811321, -0.020815094339622642, -0.031222641509433963,
      -0.041630188679245284, -0.052037735849056604, -0.062445283018867925,
      -0.072852830188679246, -0.0, -0.0, -1.0, -1.0, 0.0, 0.0, 1.0, 1.0, -0.0,
      -0.0, -1.0, -0.0, 0.0, 0.0, 1.0, 0.0, -0.0, -0.0, -0.0,
      0.010407547169811321, 0.020815094339622642, 0.031222641509433963,
      0.041630188679245284, 0.052037735849056604, 0.062445283018867925, 0.0, 0.0,
      0.0, -0.010407547169811321, -0.020815094339622642, -0.031222641509433963,
      -0.041630188679245284, -0.052037735849056604, -0.062445283018867925, -0.0,
      -0.0, -0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -0.0, -0.0, -0.0, -1.0, 0.0, 0.0,
      0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

    static const real_T t_3[36] = { 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
      0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

    static const real_T b_Mrows_2[34] = { 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0,
      9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0,
      21.0, 22.0, 28.0, 29.0, 30.0, 31.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0,
      43.0, 44.0 };

    static const real_T c_Mlim_0[34] = { 0.89999999999999991,
      0.89999999999999991, 0.89999999999999991, 0.89999999999999991,
      0.89999999999999991, 0.89999999999999991, 0.89999999999999991,
      0.89999999999999991, 0.89999999999999991, 0.10000000000000009,
      0.10000000000000009, 0.10000000000000009, 0.10000000000000009,
      0.10000000000000009, 0.10000000000000009, 0.10000000000000009,
      0.10000000000000009, 0.10000000000000009, 1.0, 1.0, 1.0, 1.0, -0.0, -0.0,
      -0.0, -0.0, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666,
      0.16666666666666666, 0.16666666666666666, 0.16666666666666666,
      0.16666666666666666, 0.16666666666666666 };

    static const real_T n_5[34] = { -0.1, -0.1, -0.1, -0.1, -0.1, -0.1, -0.1,
      -0.1, -0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

    static const real_T o_0[34] = { 0.010407547169811321, 0.020815094339622642,
      0.031222641509433963, 0.041630188679245284, 0.052037735849056604,
      0.062445283018867925, 0.072852830188679246, 0.083260377358490567,
      0.093667924528301888, -0.010407547169811321, -0.020815094339622642,
      -0.031222641509433963, -0.041630188679245284, -0.052037735849056604,
      -0.062445283018867925, -0.072852830188679246, -0.083260377358490567,
      -0.093667924528301888, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

    static const real_T q_1[25] = { 0.1208703558561766, 0.10599608914204345,
      0.091230139466002141, 0.076680823866144554, 0.0, 0.10599608914204345,
      0.10209667577073693, 0.0881972623994304, 0.074406166066215751, 0.0,
      0.091230139466002141, 0.0881972623994304, 0.08516438533285868,
      0.072131508266286948, 0.0, 0.076680823866144554, 0.074406166066215751,
      0.072131508266286948, 0.069856850466358145, 0.0, 0.0, 0.0, 0.0, 0.0,
      100000.0 };

    static const real_T b[5] = { -0.10407547169811321, 0.0, 0.0, 0.0, 0.0 };

    static const int8_T d[5] = { 0, 0, 0, 0, 1 };

    real_T tmp_2[270];
    real_T s_2[170];
    real_T tmp[120];
    real_T b_Mlim[34];
    real_T n_6[34];
    real_T o_1[34];
    real_T Bv[30];
    real_T Dv[30];
    real_T vseq[30];
    real_T q_2[25];
    real_T Bu[10];
    real_T rtb_useq[10];
    real_T b_utarget[9];
    real_T rseq[9];
    real_T tmp_0[9];
    real_T tmp_1[9];
    real_T tmp_3[9];
    real_T tmp_4[9];
    real_T b_B_0[8];
    real_T b_B_1[8];
    real_T b_B[5];
    real_T b_D[5];
    real_T CovMat[4];
    real_T L;
    real_T U_idx_0;
    real_T U_idx_1;
    real_T U_idx_2;
    real_T Y;
    real_T b_Mlim_0;
    real_T rtb_cmd_mechanicalPowerCompress;
    real_T status;
    real_T u;
    real_T xk;
    int32_T CovMat_tmp;
    int32_T CovMat_tmp_0;
    int32_T b_Mrows_1;
    int32_T ct;

    /* MATLAB Function: '<S307>/FixedHorizonOptimizer' incorporates:
     *  Constant: '<S273>/Constant3'
     *  Memory: '<S279>/LastPcov'
     *  Memory: '<S279>/Memory'
     *  Memory: '<S279>/last_x'
     *  RateTransition generated from: '<S307>/FixedHorizonOptimizer'
     *  UnitDelay: '<S279>/last_mv'
     * */
    memset(&Bu[0], 0, 10U * sizeof(real_T));
    memset(&Bv[0], 0, 30U * sizeof(real_T));
    memset(&Dv[0], 0, 30U * sizeof(real_T));
    for (ct = 0; ct < 5; ct++) {
      b_B[ct] = b[ct];
      b_D[ct] = d[ct];
    }

    U_idx_0 = rtDW.TmpRTBAtFixedHorizonOptimizerIn[0] * 6000.0;
    U_idx_1 = rtDW.TmpRTBAtFixedHorizonOptimizerIn[1] * 100.0;
    U_idx_2 = rtDW.TmpRTBAtFixedHorizonOptimizerIn[2] * 10.0;
    rtb_cmd_mechanicalPowerCompress = rtDW.TmpRTBAtFixedHorizonOptimizer_p /
      Yscale;
    b_B[0] = rtDW.TmpRTBAtFixedHorizonOptimizerIn[0] * 6000.0;
    b_D[1] = rtDW.TmpRTBAtFixedHorizonOptimizer_f[1] / 10.0 * 100.0;
    b_D[2] = rtDW.TmpRTBAtFixedHorizonOptimizer_f[2] / 10.0 * 10.0;
    b_B_0[0] = U_idx_0;
    b_B_0[1] = b_D[0];
    b_B_1[0] = U_idx_0;
    b_B_1[4] = b_D[0];
    b_B_0[2] = U_idx_1;
    b_B_0[3] = b_D[1];
    b_B_1[1] = U_idx_1;
    b_B_1[5] = b_D[1];
    b_B_0[4] = U_idx_2;
    b_B_0[5] = b_D[2];
    b_B_1[2] = U_idx_2;
    b_B_1[6] = b_D[2];
    b_B_0[6] = b_B[4];
    b_B_0[7] = b_D[4];
    b_B_1[3] = b_B[4];
    b_B_1[7] = b_D[4];
    for (ct = 0; ct < 2; ct++) {
      for (b_Mrows_1 = 0; b_Mrows_1 < 2; b_Mrows_1++) {
        CovMat_tmp = b_Mrows_1 + (ct << 1);
        CovMat[CovMat_tmp] = 0.0;
        CovMat_tmp_0 = ct << 2;
        CovMat[CovMat_tmp] += b_B_1[CovMat_tmp_0] * b_B_0[b_Mrows_1];
        CovMat[CovMat_tmp] += b_B_1[CovMat_tmp_0 + 1] * b_B_0[b_Mrows_1 + 2];
        CovMat[CovMat_tmp] += b_B_1[CovMat_tmp_0 + 2] * b_B_0[b_Mrows_1 + 4];
        CovMat[CovMat_tmp] += b_B_1[CovMat_tmp_0 + 3] * b_B_0[b_Mrows_1 + 6];
      }
    }

    Bu[0] = U_idx_0;
    Bv[0] = U_idx_1;
    Dv[0] = b_D[1];
    Bv[1] = U_idx_2;
    Dv[1] = b_D[2];
    Dv[2] = b_D[3];
    U_idx_0 = rtDW.TmpRTBAtFixedHorizonOptimizer_g[0] / 6000.0;
    U_idx_1 = rtDW.TmpRTBAtFixedHorizonOptimizer_g[1] / 100.0;
    U_idx_2 = rtDW.TmpRTBAtFixedHorizonOptimizer_g[2] / 10.0;
    Y = rtDW.TmpRTBAtFixedHorizonOptimizer_k / Yscale;
    for (ct = 0; ct < 34; ct++) {
      b_Mrows_1 = (int32_T)b_Mrows_2[ct];
      b_Mlim_0 = c_Mlim_0[ct];
      if (b_Mrows_1 <= 9) {
        b_Mlim_0 += yoff - Y;
      } else if (b_Mrows_1 <= 18) {
        b_Mlim_0 -= yoff - Y;
      } else if (b_Mrows_1 <= 27) {
        b_Mlim_0 += uoff - U_idx_0;
      } else {
        if (b_Mrows_1 <= 36) {
          b_Mlim_0 -= uoff - U_idx_0;
        }
      }

      b_Mlim[ct] = b_Mlim_0;
    }

    for (ct = 0; ct < 9; ct++) {
      b_utarget[ct] = 0.0 - U_idx_0;
    }

    Bv[2] = rtDW.TmpRTBAtFixedHorizonOptimize_cz;
    memset(&vseq[0], 0, 30U * sizeof(real_T));
    for (ct = 0; ct < 10; ct++) {
      vseq[ct * 3 + 2] = 1.0;
    }

    for (ct = 0; ct < 9; ct++) {
      rseq[ct] = 3.0 - Y;
    }

    for (ct = 0; ct < 10; ct++) {
      vseq[ct * 3] = 0.01 * rtDW.TmpRTBAtFixedHorizonOptimizer_o[0] - U_idx_1;
      vseq[ct * 3 + 1] = 0.1 * rtDW.TmpRTBAtFixedHorizonOptimizer_o[1] - U_idx_2;
    }

    U_idx_1 = 1.0 / (rtb_cmd_mechanicalPowerCompress *
                     rtDW.LastPcov_PreviousInput *
                     rtb_cmd_mechanicalPowerCompress + CovMat[3]);
    U_idx_2 = rtDW.TmpRTBAtFixedHorizonOptimizer_c * rtDW.LastPcov_PreviousInput;
    b_Mlim_0 = U_idx_2 * rtb_cmd_mechanicalPowerCompress + CovMat[2];
    L = b_Mlim_0 * U_idx_1;
    xk = (rtDW.last_x_PreviousInput - rtDW.TmpRTBAtFixedHorizonOptimizer_d) +
      b_B[0] * 0.0;
    Y = (rtDW.TmpRTBAtFixedHorizonOptimizer_a * RYscale - Y) - (((b_D[1] * vseq
      [0] + b_D[2] * vseq[1]) + b_D[3] * vseq[2]) +
      rtb_cmd_mechanicalPowerCompress * xk);
    memset(&tmp[0], 0, 120U * sizeof(real_T));
    memset(&rtDW.dv1[0], 0, 1020U * sizeof(real_T));
    for (ct = 0; ct < 9; ct++) {
      tmp_0[ct] = 1.0;
      tmp_1[ct] = 0.0;
    }

    memset(&tmp_2[0], 0, 270U * sizeof(real_T));
    for (ct = 0; ct < 9; ct++) {
      tmp_3[ct] = 0.010000000000000002;
      tmp_4[ct] = 1.0;
    }

    memcpy(&n_6[0], &n_5[0], 34U * sizeof(real_T));
    memcpy(&o_1[0], &o_0[0], 34U * sizeof(real_T));
    memcpy(&q_2[0], &q_1[0], 25U * sizeof(real_T));
    memcpy(&s_2[0], &s_1[0], 170U * sizeof(real_T));
    mpcblock_optimizer(rseq, vseq, xk + rtDW.LastPcov_PreviousInput *
                       rtb_cmd_mechanicalPowerCompress * U_idx_1 * Y,
                       rtDW.last_mv_DSTATE - U_idx_0, rtDW.Memory_PreviousInput,
                       b_Mlim, n_6, o_1, rtDW.dv1, b_utarget, U_idx_0, q_2, s_2,
                       tmp_0, tmp_1, t_3, tmp_3, tmp_4,
                       rtDW.TmpRTBAtFixedHorizonOptimizer_c, Bu, Bv,
                       rtb_cmd_mechanicalPowerCompress, Dv, b_Mrows_2, &u,
                       rtb_useq, &status, rtDW.iAout);
    rtDW.u = u;
    rtb_cmd_mechanicalPowerCompress = (U_idx_2 *
      rtDW.TmpRTBAtFixedHorizonOptimizer_c - b_Mlim_0 * L) + CovMat[0];
    rtDW.Pk1 = (rtb_cmd_mechanicalPowerCompress +
                rtb_cmd_mechanicalPowerCompress) * 0.5;
    rtDW.xk1 = ((((rtDW.TmpRTBAtFixedHorizonOptimizerIn[2] * 10.0 * vseq[1] +
                   Bv[0] * vseq[0]) + rtDW.TmpRTBAtFixedHorizonOptimize_cz *
                  vseq[2]) + ((u - U_idx_0) * b_B[0] +
      rtDW.TmpRTBAtFixedHorizonOptimizer_c * xk)) + L * Y) +
      rtDW.TmpRTBAtFixedHorizonOptimizer_d;

    /* End of MATLAB Function: '<S307>/FixedHorizonOptimizer' */

    /* Gain: '<S273>/cmd_mechanicalPowerCompressor' incorporates:
     *  Gain: '<S279>/u_scale'
     */
    rtb_cmd_mechanicalPowerCompress = 6000.0 * rtDW.u * 0.8;

    /* RateTransition generated from: '<S273>/cmd_angVel_rads' */
    rtDW.TmpRTBAtcmd_angVel_radsInport1_ = rtb_cmd_mechanicalPowerCompress;
  }

  {
    int32_T i;

    /* Update for Memory: '<S279>/Memory' */
    for (i = 0; i < 34; i++) {
      rtDW.Memory_PreviousInput[i] = rtDW.iAout[i];
    }

    /* End of Update for Memory: '<S279>/Memory' */

    /* Update for Memory: '<S279>/last_x' */
    rtDW.last_x_PreviousInput = rtDW.xk1;

    /* Update for UnitDelay: '<S279>/last_mv' */
    rtDW.last_mv_DSTATE = rtDW.u;

    /* Update for Memory: '<S279>/LastPcov' */
    rtDW.LastPcov_PreviousInput = rtDW.Pk1;
  }
}

/* Model initialize function */
void EVThermalManagement_AMPC_2020b_initialize(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&rtM->solverInfo, &rtM->Timing.simTimeStep);
    rtsiSetTPtr(&rtM->solverInfo, &rtmGetTPtr(rtM));
    rtsiSetStepSizePtr(&rtM->solverInfo, &rtM->Timing.stepSize0);
    rtsiSetdXPtr(&rtM->solverInfo, &rtM->derivs);
    rtsiSetContStatesPtr(&rtM->solverInfo, (real_T **) &rtM->contStates);
    rtsiSetNumContStatesPtr(&rtM->solverInfo, &rtM->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&rtM->solverInfo,
      &rtM->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&rtM->solverInfo,
      &rtM->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&rtM->solverInfo,
      &rtM->periodicContStateRanges);
    rtsiSetErrorStatusPtr(&rtM->solverInfo, (&rtmGetErrorStatus(rtM)));
    rtsiSetSolverMassMatrixIr(&rtM->solverInfo, rtMassMatrix.ir);
    rtsiSetSolverMassMatrixJc(&rtM->solverInfo, rtMassMatrix.jc);
    rtsiSetSolverMassMatrixPr(&rtM->solverInfo, rtMassMatrix.pr);
    rtsiSetRTModelPtr(&rtM->solverInfo, rtM);
  }

  rtsiSetSimTimeStep(&rtM->solverInfo, MAJOR_TIME_STEP);
  rtM->intgData.x0 = rtM->odeX0;
  rtM->intgData.f0 = rtM->odeF0;
  rtM->intgData.x1start = rtM->odeX1START;
  rtM->intgData.f1 = rtM->odeF1;
  rtM->intgData.Delta = rtM->odeDELTA;
  rtM->intgData.E = rtM->odeE;
  rtM->intgData.fac = rtM->odeFAC;

  /* initialize */
  {
    int_T i;
    real_T *f = rtM->intgData.fac;
    for (i = 0; i < (int_T)(sizeof(rtM->odeFAC)/sizeof(real_T)); i++) {
      f[i] = 1.5e-8;
    }
  }

  rtM->intgData.DFDX = rtM->odeDFDX;
  rtM->intgData.W = rtM->odeW;
  rtM->intgData.pivots = rtM->odePIVOTS;
  rtM->intgData.xtmp = rtM->odeXTMP;
  rtM->intgData.ztmp = rtM->odeZTMP;
  rtM->intgData.M = rtM->odeMASSMATRIX_M;
  rtM->intgData.M1 = rtM->odeMASSMATRIX_M1;
  rtM->intgData.xdot = rtM->odeXDOT;
  rtM->intgData.Edot = rtM->odeEDOT;
  rtM->intgData.fminusMxdot = rtM->odeFMXDOT;
  rtM->intgData.isFirstStep = true;
  rtsiSetSolverExtrapolationOrder(&rtM->solverInfo, 4);
  rtsiSetSolverNumberNewtonIterations(&rtM->solverInfo, 1);
  rtM->contStates = ((X *) &rtX);
  rtM->massMatrixType = ((ssMatrixType)3);
  rtM->massMatrixNzMax = (157);
  rtM->massMatrixIr = (rtMassMatrix.ir);
  rtM->massMatrixJc = (rtMassMatrix.jc);
  rtM->massMatrixPr = (rtMassMatrix.pr);
  rtsiSetSolverMassMatrixType(&rtM->solverInfo, (ssMatrixType)3);
  rtsiSetSolverMassMatrixNzMax(&rtM->solverInfo, 157);
  rtsiSetSolverData(&rtM->solverInfo, (void *)&rtM->intgData);
  rtsiSetSolverName(&rtM->solverInfo,"ode14x");
  rtmSetTPtr(rtM, &rtM->Timing.tArray[0]);
  rtM->Timing.stepSize0 = 0.01;

  /* Root-level init GlobalMassMatrixPr offset */
  {
    rtDW.STATE_1_MASS_MATRIX_PR = 9;   /* '<S380>/STATE_1' */
  }

  {
    NeModelParameters modelParameters;
    NeModelParameters modelParameters_0;
    NeslRtpManager *manager;
    NeslRtpManager *manager_0;
    NeslSimulationData *tmp_1;
    NeslSimulator *tmp_0;
    NeuDiagnosticManager *diagnosticManager;
    NeuDiagnosticTree *diagnosticTree;
    char *msg;
    real_T tmp_2;
    int_T is;
    boolean_T tmp;

    /* Start for SimscapeRtp: '<S21>/RTP_1' */
    manager_0 = nesl_lease_rtp_manager(
      "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 0);
    manager = manager_0;
    tmp = pointer_is_null(manager_0);
    if (tmp) {
      EVThermalManagement_AMPC_2020b_8db03944_1_gateway();
      manager = nesl_lease_rtp_manager(
        "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 0);
    }

    rtDW.RTP_1_RtpManager = (void *)manager;
    rtDW.RTP_1_SetParametersNeeded = true;

    /* End of Start for SimscapeRtp: '<S21>/RTP_1' */

    /* Start for FromWorkspace: '<S20>/From Workspace1' */
    {
      static real_T pTimeValues0[] = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0,
        8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0,
        20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0,
        32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0,
        44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0,
        56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0,
        68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0,
        80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0,
        92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0,
        103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0,
        113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0,
        123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0,
        133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0,
        143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0,
        153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0,
        163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0,
        173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0,
        183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0,
        193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0,
        203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0,
        213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0,
        223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0,
        233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0,
        243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0,
        253.0, 254.0, 255.0, 256.0, 257.0, 258.0, 259.0, 260.0, 261.0, 262.0,
        263.0, 264.0, 265.0, 266.0, 267.0, 268.0, 269.0, 270.0, 271.0, 272.0,
        273.0, 274.0, 275.0, 276.0, 277.0, 278.0, 279.0, 280.0, 281.0, 282.0,
        283.0, 284.0, 285.0, 286.0, 287.0, 288.0, 289.0, 290.0, 291.0, 292.0,
        293.0, 294.0, 295.0, 296.0, 297.0, 298.0, 299.0, 300.0, 301.0, 302.0,
        303.0, 304.0, 305.0, 306.0, 307.0, 308.0, 309.0, 310.0, 311.0, 312.0,
        313.0, 314.0, 315.0, 316.0, 317.0, 318.0, 319.0, 320.0, 321.0, 322.0,
        323.0, 324.0, 325.0, 326.0, 327.0, 328.0, 329.0, 330.0, 331.0, 332.0,
        333.0, 334.0, 335.0, 336.0, 337.0, 338.0, 339.0, 340.0, 341.0, 342.0,
        343.0, 344.0, 345.0, 346.0, 347.0, 348.0, 349.0, 350.0, 351.0, 352.0,
        353.0, 354.0, 355.0, 356.0, 357.0, 358.0, 359.0, 360.0, 361.0, 362.0,
        363.0, 364.0, 365.0, 366.0, 367.0, 368.0, 369.0, 370.0, 371.0, 372.0,
        373.0, 374.0, 375.0, 376.0, 377.0, 378.0, 379.0, 380.0, 381.0, 382.0,
        383.0, 384.0, 385.0, 386.0, 387.0, 388.0, 389.0, 390.0, 391.0, 392.0,
        393.0, 394.0, 395.0, 396.0, 397.0, 398.0, 399.0, 400.0, 401.0, 402.0,
        403.0, 404.0, 405.0, 406.0, 407.0, 408.0, 409.0, 410.0, 411.0, 412.0,
        413.0, 414.0, 415.0, 416.0, 417.0, 418.0, 419.0, 420.0, 421.0, 422.0,
        423.0, 424.0, 425.0, 426.0, 427.0, 428.0, 429.0, 430.0, 431.0, 432.0,
        433.0, 434.0, 435.0, 436.0, 437.0, 438.0, 439.0, 440.0, 441.0, 442.0,
        443.0, 444.0, 445.0, 446.0, 447.0, 448.0, 449.0, 450.0, 451.0, 452.0,
        453.0, 454.0, 455.0, 456.0, 457.0, 458.0, 459.0, 460.0, 461.0, 462.0,
        463.0, 464.0, 465.0, 466.0, 467.0, 468.0, 469.0, 470.0, 471.0, 472.0,
        473.0, 474.0, 475.0, 476.0, 477.0, 478.0, 479.0, 480.0, 481.0, 482.0,
        483.0, 484.0, 485.0, 486.0, 487.0, 488.0, 489.0, 490.0, 491.0, 492.0,
        493.0, 494.0, 495.0, 496.0, 497.0, 498.0, 499.0, 500.0, 501.0, 502.0,
        503.0, 504.0, 505.0, 506.0, 507.0, 508.0, 509.0, 510.0, 511.0, 512.0,
        513.0, 514.0, 515.0, 516.0, 517.0, 518.0, 519.0, 520.0, 521.0, 522.0,
        523.0, 524.0, 525.0, 526.0, 527.0, 528.0, 529.0, 530.0, 531.0, 532.0,
        533.0, 534.0, 535.0, 536.0, 537.0, 538.0, 539.0, 540.0, 541.0, 542.0,
        543.0, 544.0, 545.0, 546.0, 547.0, 548.0, 549.0, 550.0, 551.0, 552.0,
        553.0, 554.0, 555.0, 556.0, 557.0, 558.0, 559.0, 560.0, 561.0, 562.0,
        563.0, 564.0, 565.0, 566.0, 567.0, 568.0, 569.0, 570.0, 571.0, 572.0,
        573.0, 574.0, 575.0, 576.0, 577.0, 578.0, 579.0, 580.0, 581.0, 582.0,
        583.0, 584.0, 585.0, 586.0, 587.0, 588.0, 589.0, 590.0, 591.0, 592.0,
        593.0, 594.0, 595.0, 596.0, 597.0, 598.0, 599.0, 600.0, 601.0, 602.0,
        603.0, 604.0, 605.0, 606.0, 607.0, 608.0, 609.0, 610.0, 611.0, 612.0,
        613.0, 614.0, 615.0, 616.0, 617.0, 618.0, 619.0, 620.0, 621.0, 622.0,
        623.0, 624.0, 625.0, 626.0, 627.0, 628.0, 629.0, 630.0, 631.0, 632.0,
        633.0, 634.0, 635.0, 636.0, 637.0, 638.0, 639.0, 640.0, 641.0, 642.0,
        643.0, 644.0, 645.0, 646.0, 647.0, 648.0, 649.0, 650.0, 651.0, 652.0,
        653.0, 654.0, 655.0, 656.0, 657.0, 658.0, 659.0, 660.0, 661.0, 662.0,
        663.0, 664.0, 665.0, 666.0, 667.0, 668.0, 669.0, 670.0, 671.0, 672.0,
        673.0, 674.0, 675.0, 676.0, 677.0, 678.0, 679.0, 680.0, 681.0, 682.0,
        683.0, 684.0, 685.0, 686.0, 687.0, 688.0, 689.0, 690.0, 691.0, 692.0,
        693.0, 694.0, 695.0, 696.0, 697.0, 698.0, 699.0, 700.0, 701.0, 702.0,
        703.0, 704.0, 705.0, 706.0, 707.0, 708.0, 709.0, 710.0, 711.0, 712.0,
        713.0, 714.0, 715.0, 716.0, 717.0, 718.0, 719.0, 720.0, 721.0, 722.0,
        723.0, 724.0, 725.0, 726.0, 727.0, 728.0, 729.0, 730.0, 731.0, 732.0,
        733.0, 734.0, 735.0, 736.0, 737.0, 738.0, 739.0, 740.0, 741.0, 742.0,
        743.0, 744.0, 745.0, 746.0, 747.0, 748.0, 749.0, 750.0, 751.0, 752.0,
        753.0, 754.0, 755.0, 756.0, 757.0, 758.0, 759.0, 760.0, 761.0, 762.0,
        763.0, 764.0, 765.0, 766.0, 767.0, 768.0, 769.0, 770.0, 771.0, 772.0,
        773.0, 774.0, 775.0, 776.0, 777.0, 778.0, 779.0, 780.0, 781.0, 782.0,
        783.0, 784.0, 785.0, 786.0, 787.0, 788.0, 789.0, 790.0, 791.0, 792.0,
        793.0, 794.0, 795.0, 796.0, 797.0, 798.0, 799.0, 800.0, 801.0, 802.0,
        803.0, 804.0, 805.0, 806.0, 807.0, 808.0, 809.0, 810.0, 811.0, 812.0,
        813.0, 814.0, 815.0, 816.0, 817.0, 818.0, 819.0, 820.0, 821.0, 822.0,
        823.0, 824.0, 825.0, 826.0, 827.0, 828.0, 829.0, 830.0, 831.0, 832.0,
        833.0, 834.0, 835.0, 836.0, 837.0, 838.0, 839.0, 840.0, 841.0, 842.0,
        843.0, 844.0, 845.0, 846.0, 847.0, 848.0, 849.0, 850.0, 851.0, 852.0,
        853.0, 854.0, 855.0, 856.0, 857.0, 858.0, 859.0, 860.0, 861.0, 862.0,
        863.0, 864.0, 865.0, 866.0, 867.0, 868.0, 869.0, 870.0, 871.0, 872.0,
        873.0, 874.0, 875.0, 876.0, 877.0, 878.0, 879.0, 880.0, 881.0, 882.0,
        883.0, 884.0, 885.0, 886.0, 887.0, 888.0, 889.0, 890.0, 891.0, 892.0,
        893.0, 894.0, 895.0, 896.0, 897.0, 898.0, 899.0, 900.0, 901.0, 902.0,
        903.0, 904.0, 905.0, 906.0, 907.0, 908.0, 909.0, 910.0, 911.0, 912.0,
        913.0, 914.0, 915.0, 916.0, 917.0, 918.0, 919.0, 920.0, 921.0, 922.0,
        923.0, 924.0, 925.0, 926.0, 927.0, 928.0, 929.0, 930.0, 931.0, 932.0,
        933.0, 934.0, 935.0, 936.0, 937.0, 938.0, 939.0, 940.0, 941.0, 942.0,
        943.0, 944.0, 945.0, 946.0, 947.0, 948.0, 949.0, 950.0, 951.0, 952.0,
        953.0, 954.0, 955.0, 956.0, 957.0, 958.0, 959.0, 960.0, 961.0, 962.0,
        963.0, 964.0, 965.0, 966.0, 967.0, 968.0, 969.0, 970.0, 971.0, 972.0,
        973.0, 974.0, 975.0, 976.0, 977.0, 978.0, 979.0, 980.0, 981.0, 982.0,
        983.0, 984.0, 985.0, 986.0, 987.0, 988.0, 989.0, 990.0, 991.0, 992.0,
        993.0, 994.0, 995.0, 996.0, 997.0, 998.0, 999.0, 1000.0, 1001.0, 1002.0,
        1003.0, 1004.0, 1005.0, 1006.0, 1007.0, 1008.0, 1009.0, 1010.0, 1011.0,
        1012.0, 1013.0, 1014.0, 1015.0, 1016.0, 1017.0, 1018.0, 1019.0, 1020.0,
        1021.0, 1022.0, 1023.0, 1024.0, 1025.0, 1026.0, 1027.0, 1028.0, 1029.0,
        1030.0, 1031.0, 1032.0, 1033.0, 1034.0, 1035.0, 1036.0, 1037.0, 1038.0,
        1039.0, 1040.0, 1041.0, 1042.0, 1043.0, 1044.0, 1045.0, 1046.0, 1047.0,
        1048.0, 1049.0, 1050.0, 1051.0, 1052.0, 1053.0, 1054.0, 1055.0, 1056.0,
        1057.0, 1058.0, 1059.0, 1060.0, 1061.0, 1062.0, 1063.0, 1064.0, 1065.0,
        1066.0, 1067.0, 1068.0, 1069.0, 1070.0, 1071.0, 1072.0, 1073.0, 1074.0,
        1075.0, 1076.0, 1077.0, 1078.0, 1079.0, 1080.0, 1081.0, 1082.0, 1083.0,
        1084.0, 1085.0, 1086.0, 1087.0, 1088.0, 1089.0, 1090.0, 1091.0, 1092.0,
        1093.0, 1094.0, 1095.0, 1096.0, 1097.0, 1098.0, 1099.0, 1100.0, 1101.0,
        1102.0, 1103.0, 1104.0, 1105.0, 1106.0, 1107.0, 1108.0, 1109.0, 1110.0,
        1111.0, 1112.0, 1113.0, 1114.0, 1115.0, 1116.0, 1117.0, 1118.0, 1119.0,
        1120.0, 1121.0, 1122.0, 1123.0, 1124.0, 1125.0, 1126.0, 1127.0, 1128.0,
        1129.0, 1130.0, 1131.0, 1132.0, 1133.0, 1134.0, 1135.0, 1136.0, 1137.0,
        1138.0, 1139.0, 1140.0, 1141.0, 1142.0, 1143.0, 1144.0, 1145.0, 1146.0,
        1147.0, 1148.0, 1149.0, 1150.0, 1151.0, 1152.0, 1153.0, 1154.0, 1155.0,
        1156.0, 1157.0, 1158.0, 1159.0, 1160.0, 1161.0, 1162.0, 1163.0, 1164.0,
        1165.0, 1166.0, 1167.0, 1168.0, 1169.0, 1170.0, 1171.0, 1172.0, 1173.0,
        1174.0, 1175.0, 1176.0, 1177.0, 1178.0, 1179.0, 1180.0, 1181.0, 1182.0,
        1183.0, 1184.0, 1185.0, 1186.0, 1187.0, 1188.0, 1189.0, 1190.0, 1191.0,
        1192.0, 1193.0, 1194.0, 1195.0, 1196.0, 1197.0, 1198.0, 1199.0, 1200.0,
        1201.0, 1202.0, 1203.0, 1204.0, 1205.0, 1206.0, 1207.0, 1208.0, 1209.0,
        1210.0, 1211.0, 1212.0, 1213.0, 1214.0, 1215.0, 1216.0, 1217.0, 1218.0,
        1219.0, 1220.0, 1221.0, 1222.0, 1223.0, 1224.0, 1225.0, 1226.0, 1227.0,
        1228.0, 1229.0, 1230.0, 1231.0, 1232.0, 1233.0, 1234.0, 1235.0, 1236.0,
        1237.0, 1238.0, 1239.0, 1240.0, 1241.0, 1242.0, 1243.0, 1244.0, 1245.0,
        1246.0, 1247.0, 1248.0, 1249.0, 1250.0, 1251.0, 1252.0, 1253.0, 1254.0,
        1255.0, 1256.0, 1257.0, 1258.0, 1259.0, 1260.0, 1261.0, 1262.0, 1263.0,
        1264.0, 1265.0, 1266.0, 1267.0, 1268.0, 1269.0, 1270.0, 1271.0, 1272.0,
        1273.0, 1274.0, 1275.0, 1276.0, 1277.0, 1278.0, 1279.0, 1280.0, 1281.0,
        1282.0, 1283.0, 1284.0, 1285.0, 1286.0, 1287.0, 1288.0, 1289.0, 1290.0,
        1291.0, 1292.0, 1293.0, 1294.0, 1295.0, 1296.0, 1297.0, 1298.0, 1299.0,
        1300.0, 1301.0, 1302.0, 1303.0, 1304.0, 1305.0, 1306.0, 1307.0, 1308.0,
        1309.0, 1310.0, 1311.0, 1312.0, 1313.0, 1314.0, 1315.0, 1316.0, 1317.0,
        1318.0, 1319.0, 1320.0, 1321.0, 1322.0, 1323.0, 1324.0, 1325.0, 1326.0,
        1327.0, 1328.0, 1329.0, 1330.0, 1331.0, 1332.0, 1333.0, 1334.0, 1335.0,
        1336.0, 1337.0, 1338.0, 1339.0, 1340.0, 1341.0, 1342.0, 1343.0, 1344.0,
        1345.0, 1346.0, 1347.0, 1348.0, 1349.0, 1350.0, 1351.0, 1352.0, 1353.0,
        1354.0, 1355.0, 1356.0, 1357.0, 1358.0, 1359.0, 1360.0, 1361.0, 1362.0,
        1363.0, 1364.0, 1365.0, 1366.0, 1367.0, 1368.0, 1369.0 } ;

      static real_T pDataValues0[] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.82802,
        9.495106, 13.840323999999999, 18.50741, 23.013562, 27.197846,
        27.841582000000002, 29.129054000000004, 33.313338, 34.922678,
        36.049215999999994, 36.21015, 35.566414, 34.60081, 33.635206,
        32.830535999999995, 31.864932, 27.35878, 23.979166, 23.979166, 24.461968,
        24.94477, 25.74944, 27.519714, 30.738394000000003, 33.957074, 36.532018,
        36.853885999999996, 36.532018, 36.371084, 34.278942, 30.57746, 27.519714,
        25.427572, 25.427572, 28.485318, 31.864932, 34.761744,
        37.336687999999995, 38.946028, 39.589764, 40.072565999999995, 40.2335,
        39.589764, 39.42883, 39.750698, 39.911632000000004, 39.750698, 39.589764,
        39.589764, 40.394434000000004, 41.199104000000005, 41.360037999999996,
        40.877235999999996, 40.072565999999995, 40.2335, 40.877235999999996,
        41.84284, 41.84284, 41.360037999999996, 42.003774, 42.969378, 44.25685,
        46.027124, 47.153662000000004, 47.958332, 48.441134000000005, 48.923936,
        49.406738, 49.406738, 49.08487, 48.923936, 48.763002, 48.923936,
        49.567672, 48.923936, 48.119265999999996, 47.47553, 47.958332, 48.763002,
        49.406738, 49.728606, 49.88954, 49.728606, 48.923936, 47.958332,
        48.119265999999996, 48.602067999999996, 49.406738, 50.211408, 51.177012,
        51.820748, 52.142616, 51.820748, 51.016078, 46.027124, 40.716302,
        35.40548, 30.094658000000003, 24.783836, 19.473014, 14.162192000000001,
        8.85137, 3.5405480000000007, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 5.310822, 10.621644, 15.932466, 21.243288, 26.55411, 31.864932,
        35.727348, 39.106962, 41.520972, 42.486576, 41.360037999999996,
        40.394434000000004, 39.750698, 40.2335, 40.555368, 40.877235999999996,
        41.520972, 43.774048, 42.64751, 38.62416, 36.532018, 31.221196,
        28.485318, 27.680647999999998, 29.129054000000004, 29.933723999999998,
        32.1868, 35.727348, 39.42883, 43.934982, 49.08487, 53.91289,
        58.258108000000007, 60.028381999999986, 63.247061999999985, 65.17827,
        67.753214, 70.006289999999993, 72.581234, 74.02964, 75.317112, 76.44365,
        76.44365, 76.121782, 75.960848, 75.63898, 75.63898, 75.63898, 75.63898,
        75.63898, 75.960848, 76.282716, 77.087386, 78.05299, 79.018594000000007,
        79.66233, 80.467, 81.432604, 82.07634, 82.88101, 84.007548, 85.616888,
        87.065294000000009, 87.869964, 88.352766, 88.5137, 88.352766, 87.869964,
        87.869964, 88.191831999999991, 88.674634, 89.31837, 89.640238000000011,
        90.283974, 90.605842, 91.088644, 91.249578, 91.249578, 90.92771,
        90.92771, 90.92771, 90.92771, 90.92771, 90.92771, 90.766776, 90.283974,
        89.801172, 88.674634, 87.869964, 87.226228, 86.90436, 86.421558,
        86.260624, 86.743426, 86.90436, 87.065294000000009, 87.065294000000009,
        86.582492, 85.938756, 85.29502, 84.651284, 83.846614, 84.329416,
        83.68568, 83.524746, 83.202878, 82.88101, 83.041944, 83.363812,
        83.846614, 84.49035, 85.29502, 86.09969, 86.90436, 88.352766, 89.157436,
        89.479304, 90.12304, 90.12304, 89.801172, 88.835568000000009, 87.70903,
        86.260624, 84.49035, 82.88101, 82.88101, 82.88101, 82.237274, 80.627934,
        80.467, 80.627934, 80.467, 79.823264000000009, 79.66233, 79.66233,
        79.66233, 79.018594000000007, 78.213924, 77.409254, 75.960848, 74.190574,
        72.4203, 70.489092, 68.557884, 66.78761, 64.856401999999989,
        61.976401999999993, 59.54558, 56.648768000000004, 54.395692, 52.30355,
        50.69421, 49.245804, 49.08487, 48.2802, 46.67086, 44.25685,
        39.911632000000004, 34.60081, 32.347734, 30.738394000000003, 29.77279,
        27.35878, 24.94477, 20.11675, 17.380872, 12.87472, 7.563898,
        2.2530759999999996, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 1.60934, 6.9201619999999995, 12.230984, 17.541806,
        22.852628, 27.841582000000002, 32.1868, 36.21015, 38.141358, 40.555368,
        42.808444, 45.222454, 48.2802, 49.567672, 50.855144, 51.659814000000004,
        52.786351999999994, 54.073824, 55.52223, 55.683164000000005, 56.165966,
        56.005031999999993, 55.52223, 55.844098, 57.131569999999996, 57.93624,
        57.93624, 57.93624, 57.93624, 57.93624, 57.93624, 58.097174,
        58.579975999999995, 58.74091, 58.579975999999995, 57.93624, 56.487834,
        54.878494, 53.91289, 50.533276, 46.67086, 41.360037999999996, 37.01482,
        32.669602, 28.16345, 23.33543, 19.31208, 14.001257999999998, 8.690436,
        3.379614, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.184284, 9.495106, 14.805928,
        20.11675, 25.427572, 30.738394000000003, 36.049215999999994, 40.2335,
        41.199104000000005, 44.25685, 46.67086, 48.2802, 48.441134000000005,
        48.2802, 47.797398, 47.153662000000004, 46.348992, 45.06152, 40.2335,
        34.922678, 29.611856, 24.301033999999998, 18.990212, 13.67939, 8.368568,
        3.057746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.310822, 10.621644, 15.932466,
        21.243288, 26.55411, 31.864932, 37.175754000000005, 42.486576, 44.739652,
        46.831794, 50.69421, 53.10822, 54.073824, 56.005031999999993, 56.487834,
        57.292504, 58.097174, 57.93624, 58.097174, 58.258108000000007, 57.93624,
        57.453438000000006, 57.93624, 57.93624, 57.292504, 57.131569999999996,
        56.970636, 56.648768000000004, 56.648768000000004, 56.648768000000004,
        56.648768000000004, 56.648768000000004, 56.648768000000004, 56.3269,
        56.487834, 56.648768000000004, 57.131569999999996, 56.648768000000004,
        56.3269, 56.3269, 56.3269, 56.005031999999993, 55.683164000000005,
        55.52223, 53.91289, 51.49888, 48.441134000000005, 45.06152, 41.03817,
        36.21015, 31.864932, 26.55411, 21.243288, 16.576202000000002, 11.587248,
        6.43736, 1.6093399999999995, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        1.9312079999999998, 5.63269, 8.85137, 10.46071, 13.67939,
        15.449663999999999, 16.89807, 19.151146, 22.53076, 25.74944, 28.485318,
        30.57746, 32.347734, 33.79614, 35.40548, 37.01482, 38.302292, 39.42883,
        40.072565999999995, 40.2335, 40.2335, 40.2335, 40.2335, 40.2335, 40.2335,
        41.199104000000005, 41.520972, 41.84284, 41.199104000000005, 40.555368,
        40.2335, 40.2335, 40.2335, 39.267896, 37.175754000000005, 31.864932,
        26.55411, 21.243288, 15.932466, 10.621644, 5.310822, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        5.310822, 10.621644, 15.932466, 20.92142, 23.496364, 25.74944, 27.35878,
        27.35878, 27.35878, 28.16345, 28.485318, 28.485318, 28.16345, 27.35878,
        27.197846, 26.715044000000002, 27.35878, 27.519714, 27.35878,
        26.715044000000002, 26.55411, 26.55411, 26.715044000000002, 27.35878,
        28.324384000000002, 29.77279, 30.899327999999997, 32.508668, 33.79614,
        33.957074, 34.118007999999996, 34.761744, 35.40548, 36.049215999999994,
        36.21015, 36.21015, 36.21015, 36.532018, 38.141358, 40.394434000000004,
        41.84284, 42.64751, 43.45218, 42.003774, 36.692952, 31.38213, 26.071308,
        20.760486, 15.449663999999999, 10.138842, 4.82802, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.21868, 7.24203, 12.552852,
        16.415267999999998, 20.11675, 22.53076, 24.622902, 28.16345,
        31.543063999999998, 33.79614, 35.727348, 37.497622, 39.42883, 40.716302,
        41.199104000000005, 41.84284, 42.003774, 42.164708, 42.164708, 42.486576,
        42.64751, 42.64751, 41.84284, 41.03817, 37.980424, 34.439876, 29.77279,
        26.393175999999997, 23.33543, 18.668343999999998, 14.001257999999998,
        9.3341719999999988, 5.63269, 3.21868, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.2530759999999996, 5.310822,
        7.0810960000000005, 10.46071, 14.805928, 18.185542, 21.72609, 23.496364,
        26.393175999999997, 26.875978, 26.55411, 26.55411, 29.289987999999997,
        30.899327999999997, 32.347734, 34.60081, 36.21015, 36.21015, 35.566414,
        36.532018, 37.497622, 37.81949, 36.21015, 34.761744, 32.99147, 28.96812,
        24.1401, 19.31208, 14.48406, 9.9779080000000011, 7.24203, 4.82802,
        3.379614, 0.80466999999999977, 0.80467, 5.1498880000000007, 10.46071,
        15.449663999999999, 20.11675, 22.53076, 25.74944, 28.96812,
        31.543063999999998, 34.60081, 37.175754000000005, 39.42883, 41.03817,
        42.64751, 43.613114, 44.417784000000005, 44.900586, 45.544322, 46.027124,
        46.027124, 45.544322, 45.383388, 45.06152, 44.25685, 43.130312, 41.03817,
        37.81949, 34.60081, 30.57746, 26.55411, 23.979166, 20.11675, 15.127796,
        9.9779080000000011, 4.82802, 2.41401, 2.41401, 0.80467, 0.0, 4.82802,
        10.138842, 15.449663999999999, 20.760486, 25.427572, 28.16345, 29.611856,
        31.38213, 33.313338, 35.40548, 37.336687999999995, 40.2335, 42.64751,
        44.25685, 45.06152, 45.544322, 46.509926, 46.509926, 46.509926,
        46.348992, 45.86619, 45.544322, 45.544322, 45.544322, 45.383388,
        44.417784000000005, 44.25685, 44.25685, 44.25685, 44.25685, 44.25685,
        44.25685, 44.417784000000005, 45.06152, 45.86619, 48.2802, 49.88954,
        51.49888, 53.10822, 53.10822, 54.073824, 54.71756, 55.200362, 55.039428,
        54.71756, 54.71756, 54.556625999999994, 54.073824, 53.269154, 53.10822,
        52.30355, 51.49888, 51.337945999999995, 50.855144, 50.69421, 49.245804,
        48.2802, 48.119265999999996, 48.119265999999996, 48.119265999999996,
        48.119265999999996, 47.636464000000004, 47.47553, 47.47553,
        47.153662000000004, 46.509926, 45.383388, 44.578718, 43.45218, 41.03817,
        38.141358, 35.40548, 32.99147, 30.899327999999997, 30.899327999999997,
        32.347734, 33.635206, 34.439876, 35.40548, 36.371084, 37.336687999999995,
        38.62416, 40.2335, 41.84284, 42.808444, 42.808444, 43.130312, 43.45218,
        43.774048, 44.739652, 45.222454, 46.348992, 46.509926, 46.67086,
        46.831794, 46.67086, 45.222454, 44.25685, 43.45218, 41.520972, 40.2335,
        39.42883, 39.911632000000004, 40.394434000000004, 41.03817,
        41.360037999999996, 42.164708, 43.291246, 44.25685, 44.739652, 45.705256,
        46.67086, 46.992728, 46.831794, 46.67086, 46.509926, 45.86619, 45.222454,
        45.06152, 45.06152, 44.417784000000005, 43.774048, 42.808444, 43.45218,
        44.25685, 44.739652, 45.06152, 44.739652, 45.06152, 45.06152, 45.06152,
        44.578718, 44.095915999999995, 43.291246, 42.808444, 42.64751, 42.64751,
        42.64751, 42.325642, 42.164708, 42.164708, 41.681906, 41.199104000000005,
        41.199104000000005, 41.681906, 41.520972, 41.03817, 39.589764, 37.81949,
        35.727348, 34.761744, 34.761744, 34.922678, 36.371084, 37.658556,
        38.62416, 38.946028, 39.267896, 40.072565999999995, 40.394434000000004,
        40.555368, 40.716302, 41.03817, 40.555368, 40.2335, 40.2335, 40.2335,
        39.750698, 39.42883, 39.106962, 39.106962, 39.42883, 40.2335, 40.2335,
        39.589764, 39.589764, 38.785094, 39.42883, 40.394434000000004,
        41.199104000000005, 40.394434000000004, 38.62416, 35.40548, 32.347734,
        27.197846, 21.887024, 16.576202000000002, 11.26538, 5.9545580000000005,
        0.64373599999999986, 0.0, 0.0, 0.0, 3.21868, 8.529501999999999,
        13.840323999999999, 19.151146, 24.461968, 28.16345, 29.933723999999998,
        32.1868, 33.957074, 35.40548, 37.01482, 39.42883, 42.325642, 44.25685,
        45.222454, 45.705256, 45.86619, 45.86619, 45.86619, 44.578718, 44.25685,
        43.774048, 43.130312, 42.64751, 41.84284, 41.360037999999996, 40.555368,
        38.62416, 35.40548, 34.60081, 34.60081, 35.083612, 36.21015, 37.01482,
        36.692952, 36.692952, 37.01482, 36.532018, 36.532018, 36.532018,
        37.81949, 38.62416, 39.589764, 39.911632000000004, 40.394434000000004,
        41.03817, 41.199104000000005, 41.03817, 40.2335, 38.785094, 38.141358,
        37.336687999999995, 36.853885999999996, 36.21015, 35.40548, 34.761744,
        32.99147, 28.16345, 22.852628, 17.541806, 12.230984, 6.9201619999999995,
        1.6093399999999995, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.9312079999999998, 6.43736, 11.748182,
        17.059003999999998, 22.369826, 27.35878, 29.77279, 32.1868, 35.083612,
        37.01482, 38.62416, 39.911632000000004, 41.199104000000005, 42.64751,
        43.130312, 44.095915999999995, 44.900586, 45.544322, 45.06152, 44.25685,
        43.45218, 43.45218, 42.325642, 39.42883, 36.21015, 34.60081,
        33.152404000000004, 28.96812, 24.1401, 19.794882, 17.863674,
        17.059003999999998, 16.0934, 15.28873, 14.644993999999999,
        14.001257999999998, 13.840323999999999, 14.162192000000001, 14.48406,
        14.001257999999998, 13.840323999999999, 12.87472, 11.26538, 8.0467,
        6.759228, 4.184284, 1.60934, 0.0, 0.16093400000000002,
        0.96560399999999991, 2.5749440000000003, 5.793624, 11.104446000000001,
        16.0934, 20.599552000000003, 22.53076, 23.33543, 25.74944,
        29.129054000000004, 32.1868, 33.79614, 34.118007999999996, 34.278942,
        34.439876, 34.922678, 36.21015, 37.01482, 38.302292, 39.42883, 40.2335,
        40.072565999999995, 39.911632000000004, 40.2335, 40.877235999999996,
        41.520972, 41.84284, 42.486576, 42.808444, 43.291246, 43.45218, 43.45218,
        43.45218, 43.291246, 43.130312, 43.130312, 42.64751, 42.486576, 41.84284,
        41.03817, 39.589764, 37.81949, 34.60081, 32.1868, 28.16345, 25.74944,
        22.53076, 17.219938, 11.909116000000001, 6.5982939999999992,
        1.2874720000000004, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.379614, 8.690436, 14.001257999999998,
        19.31208, 24.622902, 29.933723999999998, 33.957074, 37.01482, 37.81949,
        37.01482, 36.21015, 32.1868, 26.875978, 21.565156, 16.254334, 10.943512,
        5.63269, 0.32186799999999993, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.32186800000000004, 2.41401, 5.63269, 10.46071,
        15.771531999999999, 19.31208, 20.760486, 20.92142, 20.277684,
        20.599552000000003, 21.082354, 21.082354, 22.53076, 24.94477, 27.35878,
        29.933723999999998, 31.703998000000002, 33.79614, 34.60081, 35.083612,
        35.083612, 34.60081, 34.118007999999996, 34.60081, 35.083612, 35.40548,
        35.244546, 34.922678, 34.60081, 34.60081, 34.439876, 32.347734, 31.38213,
        30.899327999999997, 31.543063999999998, 31.864932, 32.1868, 31.38213,
        28.16345, 24.94477, 20.92142, 16.0934, 12.87472, 9.65604, 6.43736,
        4.02335, 1.1265379999999998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        1.60934, 1.60934, 1.60934, 1.60934, 1.60934, 2.5749440000000003, 4.82802,
        6.43736, 8.0467, 10.138842, 12.87472, 16.0934, 16.89807, 15.28873,
        13.67939, 12.230984, 14.162192000000001, 17.70274, 22.53076, 27.35878,
        31.38213, 33.79614, 35.083612, 35.727348, 37.01482, 37.980424, 38.785094,
        39.42883, 39.42883, 38.62416, 37.81949, 37.81949, 37.81949, 37.81949,
        37.81949, 37.81949, 38.62416, 38.785094, 39.42883, 39.750698, 40.2335,
        40.877235999999996, 41.199104000000005, 41.360037999999996, 41.84284,
        42.164708, 43.45218, 44.739652, 45.544322, 46.67086, 46.831794, 46.67086,
        45.06152, 39.750698, 34.439876, 29.129054000000004, 23.818232000000002,
        18.50741, 13.196587999999998, 7.8857659999999994, 2.5749440000000008,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.41401,
        7.7248319999999993, 13.035654, 18.346476, 21.243288, 24.301033999999998,
        27.036912, 29.450922000000002, 31.38213, 32.669602, 34.278942, 35.244546,
        35.566414, 36.049215999999994, 35.40548, 34.761744, 33.957074, 32.99147,
        32.1868, 31.543063999999998, 29.77279, 28.16345, 26.55411, 24.94477,
        22.53076, 17.70274, 12.87472, 8.368568, 4.02335, 0.0, 0.0, 0.0 } ;

      rtDW.FromWorkspace1_PWORK.TimePtr = (void *) pTimeValues0;
      rtDW.FromWorkspace1_PWORK.DataPtr = (void *) pDataValues0;
      rtDW.FromWorkspace1_IWORK.PrevIndex = 0;
    }

    /* Start for SimscapeExecutionBlock: '<S380>/STATE_1' */
    tmp_0 = nesl_lease_simulator(
      "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 0, 0);
    rtDW.STATE_1_Simulator = (void *)tmp_0;
    tmp = pointer_is_null(rtDW.STATE_1_Simulator);
    if (tmp) {
      EVThermalManagement_AMPC_2020b_8db03944_1_gateway();
      tmp_0 = nesl_lease_simulator(
        "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 0, 0);
      rtDW.STATE_1_Simulator = (void *)tmp_0;
    }

    tmp_1 = nesl_create_simulation_data();
    rtDW.STATE_1_SimData = (void *)tmp_1;
    diagnosticManager = rtw_create_diagnostics();
    rtDW.STATE_1_DiagMgr = (void *)diagnosticManager;
    modelParameters.mSolverType = NE_SOLVER_TYPE_DAE;
    modelParameters.mSolverTolerance = 0.001;
    modelParameters.mVariableStepSolver = false;
    modelParameters.mIsUsingODEN = false;
    modelParameters.mFixedStepSize = 0.01;
    modelParameters.mStartTime = 0.0;
    modelParameters.mLoadInitialState = false;
    modelParameters.mUseSimState = false;
    modelParameters.mLinTrimCompile = false;
    modelParameters.mLoggingMode = SSC_LOGGING_ALL;
    modelParameters.mRTWModifiedTimeStamp = 6.5089716E+8;
    tmp_2 = 0.001;
    modelParameters.mSolverTolerance = tmp_2;
    tmp_2 = 0.01;
    modelParameters.mFixedStepSize = tmp_2;
    tmp = false;
    modelParameters.mVariableStepSolver = tmp;
    tmp = false;
    modelParameters.mIsUsingODEN = tmp;
    modelParameters.mLoadInitialState = false;
    diagnosticManager = (NeuDiagnosticManager *)rtDW.STATE_1_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
    is = nesl_initialize_simulator((NeslSimulator *)rtDW.STATE_1_Simulator,
      &modelParameters, diagnosticManager);
    if (is != 0) {
      tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (tmp) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* End of Start for SimscapeExecutionBlock: '<S380>/STATE_1' */

    /* Start for SimscapeExecutionBlock: '<S380>/OUTPUT_1_0' */
    tmp_0 = nesl_lease_simulator(
      "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 1, 0);
    rtDW.OUTPUT_1_0_Simulator = (void *)tmp_0;
    tmp = pointer_is_null(rtDW.OUTPUT_1_0_Simulator);
    if (tmp) {
      EVThermalManagement_AMPC_2020b_8db03944_1_gateway();
      tmp_0 = nesl_lease_simulator(
        "EVThermalManagement_AMPC_2020b/Solver Configuration_1", 1, 0);
      rtDW.OUTPUT_1_0_Simulator = (void *)tmp_0;
    }

    tmp_1 = nesl_create_simulation_data();
    rtDW.OUTPUT_1_0_SimData = (void *)tmp_1;
    diagnosticManager = rtw_create_diagnostics();
    rtDW.OUTPUT_1_0_DiagMgr = (void *)diagnosticManager;
    modelParameters_0.mSolverType = NE_SOLVER_TYPE_DAE;
    modelParameters_0.mSolverTolerance = 0.001;
    modelParameters_0.mVariableStepSolver = false;
    modelParameters_0.mIsUsingODEN = false;
    modelParameters_0.mFixedStepSize = 0.01;
    modelParameters_0.mStartTime = 0.0;
    modelParameters_0.mLoadInitialState = false;
    modelParameters_0.mUseSimState = false;
    modelParameters_0.mLinTrimCompile = false;
    modelParameters_0.mLoggingMode = SSC_LOGGING_ALL;
    modelParameters_0.mRTWModifiedTimeStamp = 6.5089716E+8;
    tmp_2 = 0.001;
    modelParameters_0.mSolverTolerance = tmp_2;
    tmp_2 = 0.01;
    modelParameters_0.mFixedStepSize = tmp_2;
    tmp = false;
    modelParameters_0.mVariableStepSolver = tmp;
    tmp = false;
    modelParameters_0.mIsUsingODEN = tmp;
    modelParameters_0.mLoadInitialState = false;
    diagnosticManager = (NeuDiagnosticManager *)rtDW.OUTPUT_1_0_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
    is = nesl_initialize_simulator((NeslSimulator *)rtDW.OUTPUT_1_0_Simulator,
      &modelParameters_0, diagnosticManager);
    if (is != 0) {
      tmp = error_buffer_is_empty(rtmGetErrorStatus(rtM));
      if (tmp) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* End of Start for SimscapeExecutionBlock: '<S380>/OUTPUT_1_0' */

    /* Start for FromWorkspace: '<S20>/From Workspace' */
    {
      static real_T pTimeValues0[] = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0,
        8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0,
        20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0,
        32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0,
        44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0,
        56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0,
        68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0,
        80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0,
        92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0,
        103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0,
        113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0,
        123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0,
        133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0,
        143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0,
        153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0,
        163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0,
        173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0,
        183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0,
        193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0,
        203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0,
        213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0,
        223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0,
        233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0,
        243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0,
        253.0, 254.0, 255.0, 256.0, 257.0, 258.0, 259.0, 260.0, 261.0, 262.0,
        263.0, 264.0, 265.0, 266.0, 267.0, 268.0, 269.0, 270.0, 271.0, 272.0,
        273.0, 274.0, 275.0, 276.0, 277.0, 278.0, 279.0, 280.0, 281.0, 282.0,
        283.0, 284.0, 285.0, 286.0, 287.0, 288.0, 289.0, 290.0, 291.0, 292.0,
        293.0, 294.0, 295.0, 296.0, 297.0, 298.0, 299.0, 300.0, 301.0, 302.0,
        303.0, 304.0, 305.0, 306.0, 307.0, 308.0, 309.0, 310.0, 311.0, 312.0,
        313.0, 314.0, 315.0, 316.0, 317.0, 318.0, 319.0, 320.0, 321.0, 322.0,
        323.0, 324.0, 325.0, 326.0, 327.0, 328.0, 329.0, 330.0, 331.0, 332.0,
        333.0, 334.0, 335.0, 336.0, 337.0, 338.0, 339.0, 340.0, 341.0, 342.0,
        343.0, 344.0, 345.0, 346.0, 347.0, 348.0, 349.0, 350.0, 351.0, 352.0,
        353.0, 354.0, 355.0, 356.0, 357.0, 358.0, 359.0, 360.0, 361.0, 362.0,
        363.0, 364.0, 365.0, 366.0, 367.0, 368.0, 369.0, 370.0, 371.0, 372.0,
        373.0, 374.0, 375.0, 376.0, 377.0, 378.0, 379.0, 380.0, 381.0, 382.0,
        383.0, 384.0, 385.0, 386.0, 387.0, 388.0, 389.0, 390.0, 391.0, 392.0,
        393.0, 394.0, 395.0, 396.0, 397.0, 398.0, 399.0, 400.0, 401.0, 402.0,
        403.0, 404.0, 405.0, 406.0, 407.0, 408.0, 409.0, 410.0, 411.0, 412.0,
        413.0, 414.0, 415.0, 416.0, 417.0, 418.0, 419.0, 420.0, 421.0, 422.0,
        423.0, 424.0, 425.0, 426.0, 427.0, 428.0, 429.0, 430.0, 431.0, 432.0,
        433.0, 434.0, 435.0, 436.0, 437.0, 438.0, 439.0, 440.0, 441.0, 442.0,
        443.0, 444.0, 445.0, 446.0, 447.0, 448.0, 449.0, 450.0, 451.0, 452.0,
        453.0, 454.0, 455.0, 456.0, 457.0, 458.0, 459.0, 460.0, 461.0, 462.0,
        463.0, 464.0, 465.0, 466.0, 467.0, 468.0, 469.0, 470.0, 471.0, 472.0,
        473.0, 474.0, 475.0, 476.0, 477.0, 478.0, 479.0, 480.0, 481.0, 482.0,
        483.0, 484.0, 485.0, 486.0, 487.0, 488.0, 489.0, 490.0, 491.0, 492.0,
        493.0, 494.0, 495.0, 496.0, 497.0, 498.0, 499.0, 500.0, 501.0, 502.0,
        503.0, 504.0, 505.0, 506.0, 507.0, 508.0, 509.0, 510.0, 511.0, 512.0,
        513.0, 514.0, 515.0, 516.0, 517.0, 518.0, 519.0, 520.0, 521.0, 522.0,
        523.0, 524.0, 525.0, 526.0, 527.0, 528.0, 529.0, 530.0, 531.0, 532.0,
        533.0, 534.0, 535.0, 536.0, 537.0, 538.0, 539.0, 540.0, 541.0, 542.0,
        543.0, 544.0, 545.0, 546.0, 547.0, 548.0, 549.0, 550.0, 551.0, 552.0,
        553.0, 554.0, 555.0, 556.0, 557.0, 558.0, 559.0, 560.0, 561.0, 562.0,
        563.0, 564.0, 565.0, 566.0, 567.0, 568.0, 569.0, 570.0, 571.0, 572.0,
        573.0, 574.0, 575.0, 576.0, 577.0, 578.0, 579.0, 580.0, 581.0, 582.0,
        583.0, 584.0, 585.0, 586.0, 587.0, 588.0, 589.0, 590.0, 591.0, 592.0,
        593.0, 594.0, 595.0, 596.0, 597.0, 598.0, 599.0, 600.0, 601.0, 602.0,
        603.0, 604.0, 605.0, 606.0, 607.0, 608.0, 609.0, 610.0, 611.0, 612.0,
        613.0, 614.0, 615.0, 616.0, 617.0, 618.0, 619.0, 620.0, 621.0, 622.0,
        623.0, 624.0, 625.0, 626.0, 627.0, 628.0, 629.0, 630.0, 631.0, 632.0,
        633.0, 634.0, 635.0, 636.0, 637.0, 638.0, 639.0, 640.0, 641.0, 642.0,
        643.0, 644.0, 645.0, 646.0, 647.0, 648.0, 649.0, 650.0, 651.0, 652.0,
        653.0, 654.0, 655.0, 656.0, 657.0, 658.0, 659.0, 660.0, 661.0, 662.0,
        663.0, 664.0, 665.0, 666.0, 667.0, 668.0, 669.0, 670.0, 671.0, 672.0,
        673.0, 674.0, 675.0, 676.0, 677.0, 678.0, 679.0, 680.0, 681.0, 682.0,
        683.0, 684.0, 685.0, 686.0, 687.0, 688.0, 689.0, 690.0, 691.0, 692.0,
        693.0, 694.0, 695.0, 696.0, 697.0, 698.0, 699.0, 700.0, 701.0, 702.0,
        703.0, 704.0, 705.0, 706.0, 707.0, 708.0, 709.0, 710.0, 711.0, 712.0,
        713.0, 714.0, 715.0, 716.0, 717.0, 718.0, 719.0, 720.0, 721.0, 722.0,
        723.0, 724.0, 725.0, 726.0, 727.0, 728.0, 729.0, 730.0, 731.0, 732.0,
        733.0, 734.0, 735.0, 736.0, 737.0, 738.0, 739.0, 740.0, 741.0, 742.0,
        743.0, 744.0, 745.0, 746.0, 747.0, 748.0, 749.0, 750.0, 751.0, 752.0,
        753.0, 754.0, 755.0, 756.0, 757.0, 758.0, 759.0, 760.0, 761.0, 762.0,
        763.0, 764.0, 765.0, 766.0, 767.0, 768.0, 769.0, 770.0, 771.0, 772.0,
        773.0, 774.0, 775.0, 776.0, 777.0, 778.0, 779.0, 780.0, 781.0, 782.0,
        783.0, 784.0, 785.0, 786.0, 787.0, 788.0, 789.0, 790.0, 791.0, 792.0,
        793.0, 794.0, 795.0, 796.0, 797.0, 798.0, 799.0, 800.0, 801.0, 802.0,
        803.0, 804.0, 805.0, 806.0, 807.0, 808.0, 809.0, 810.0, 811.0, 812.0,
        813.0, 814.0, 815.0, 816.0, 817.0, 818.0, 819.0, 820.0, 821.0, 822.0,
        823.0, 824.0, 825.0, 826.0, 827.0, 828.0, 829.0, 830.0, 831.0, 832.0,
        833.0, 834.0, 835.0, 836.0, 837.0, 838.0, 839.0, 840.0, 841.0, 842.0,
        843.0, 844.0, 845.0, 846.0, 847.0, 848.0, 849.0, 850.0, 851.0, 852.0,
        853.0, 854.0, 855.0, 856.0, 857.0, 858.0, 859.0, 860.0, 861.0, 862.0,
        863.0, 864.0, 865.0, 866.0, 867.0, 868.0, 869.0, 870.0, 871.0, 872.0,
        873.0, 874.0, 875.0, 876.0, 877.0, 878.0, 879.0, 880.0, 881.0, 882.0,
        883.0, 884.0, 885.0, 886.0, 887.0, 888.0, 889.0, 890.0, 891.0, 892.0,
        893.0, 894.0, 895.0, 896.0, 897.0, 898.0, 899.0, 900.0, 901.0, 902.0,
        903.0, 904.0, 905.0, 906.0, 907.0, 908.0, 909.0, 910.0, 911.0, 912.0,
        913.0, 914.0, 915.0, 916.0, 917.0, 918.0, 919.0, 920.0, 921.0, 922.0,
        923.0, 924.0, 925.0, 926.0, 927.0, 928.0, 929.0, 930.0, 931.0, 932.0,
        933.0, 934.0, 935.0, 936.0, 937.0, 938.0, 939.0, 940.0, 941.0, 942.0,
        943.0, 944.0, 945.0, 946.0, 947.0, 948.0, 949.0, 950.0, 951.0, 952.0,
        953.0, 954.0, 955.0, 956.0, 957.0, 958.0, 959.0, 960.0, 961.0, 962.0,
        963.0, 964.0, 965.0, 966.0, 967.0, 968.0, 969.0, 970.0, 971.0, 972.0,
        973.0, 974.0, 975.0, 976.0, 977.0, 978.0, 979.0, 980.0, 981.0, 982.0,
        983.0, 984.0, 985.0, 986.0, 987.0, 988.0, 989.0, 990.0, 991.0, 992.0,
        993.0, 994.0, 995.0, 996.0, 997.0, 998.0, 999.0, 1000.0, 1001.0, 1002.0,
        1003.0, 1004.0, 1005.0, 1006.0, 1007.0, 1008.0, 1009.0, 1010.0, 1011.0,
        1012.0, 1013.0, 1014.0, 1015.0, 1016.0, 1017.0, 1018.0, 1019.0, 1020.0,
        1021.0, 1022.0, 1023.0, 1024.0, 1025.0, 1026.0, 1027.0, 1028.0, 1029.0,
        1030.0, 1031.0, 1032.0, 1033.0, 1034.0, 1035.0, 1036.0, 1037.0, 1038.0,
        1039.0, 1040.0, 1041.0, 1042.0, 1043.0, 1044.0, 1045.0, 1046.0, 1047.0,
        1048.0, 1049.0, 1050.0, 1051.0, 1052.0, 1053.0, 1054.0, 1055.0, 1056.0,
        1057.0, 1058.0, 1059.0, 1060.0, 1061.0, 1062.0, 1063.0, 1064.0, 1065.0,
        1066.0, 1067.0, 1068.0, 1069.0, 1070.0, 1071.0, 1072.0, 1073.0, 1074.0,
        1075.0, 1076.0, 1077.0, 1078.0, 1079.0, 1080.0, 1081.0, 1082.0, 1083.0,
        1084.0, 1085.0, 1086.0, 1087.0, 1088.0, 1089.0, 1090.0, 1091.0, 1092.0,
        1093.0, 1094.0, 1095.0, 1096.0, 1097.0, 1098.0, 1099.0, 1100.0, 1101.0,
        1102.0, 1103.0, 1104.0, 1105.0, 1106.0, 1107.0, 1108.0, 1109.0, 1110.0,
        1111.0, 1112.0, 1113.0, 1114.0, 1115.0, 1116.0, 1117.0, 1118.0, 1119.0,
        1120.0, 1121.0, 1122.0, 1123.0, 1124.0, 1125.0, 1126.0, 1127.0, 1128.0,
        1129.0, 1130.0, 1131.0, 1132.0, 1133.0, 1134.0, 1135.0, 1136.0, 1137.0,
        1138.0, 1139.0, 1140.0, 1141.0, 1142.0, 1143.0, 1144.0, 1145.0, 1146.0,
        1147.0, 1148.0, 1149.0, 1150.0, 1151.0, 1152.0, 1153.0, 1154.0, 1155.0,
        1156.0, 1157.0, 1158.0, 1159.0, 1160.0, 1161.0, 1162.0, 1163.0, 1164.0,
        1165.0, 1166.0, 1167.0, 1168.0, 1169.0, 1170.0, 1171.0, 1172.0, 1173.0,
        1174.0, 1175.0, 1176.0, 1177.0, 1178.0, 1179.0, 1180.0, 1181.0, 1182.0,
        1183.0, 1184.0, 1185.0, 1186.0, 1187.0, 1188.0, 1189.0, 1190.0, 1191.0,
        1192.0, 1193.0, 1194.0, 1195.0, 1196.0, 1197.0, 1198.0, 1199.0, 1200.0,
        1201.0, 1202.0, 1203.0, 1204.0, 1205.0, 1206.0, 1207.0, 1208.0, 1209.0,
        1210.0, 1211.0, 1212.0, 1213.0, 1214.0, 1215.0, 1216.0, 1217.0, 1218.0,
        1219.0, 1220.0, 1221.0, 1222.0, 1223.0, 1224.0, 1225.0, 1226.0, 1227.0,
        1228.0, 1229.0, 1230.0, 1231.0, 1232.0, 1233.0, 1234.0, 1235.0, 1236.0,
        1237.0, 1238.0, 1239.0, 1240.0, 1241.0, 1242.0, 1243.0, 1244.0, 1245.0,
        1246.0, 1247.0, 1248.0, 1249.0, 1250.0, 1251.0, 1252.0, 1253.0, 1254.0,
        1255.0, 1256.0, 1257.0, 1258.0, 1259.0, 1260.0, 1261.0, 1262.0, 1263.0,
        1264.0, 1265.0, 1266.0, 1267.0, 1268.0, 1269.0, 1270.0, 1271.0, 1272.0,
        1273.0, 1274.0, 1275.0, 1276.0, 1277.0, 1278.0, 1279.0, 1280.0, 1281.0,
        1282.0, 1283.0, 1284.0, 1285.0, 1286.0, 1287.0, 1288.0, 1289.0, 1290.0,
        1291.0, 1292.0, 1293.0, 1294.0, 1295.0, 1296.0, 1297.0, 1298.0, 1299.0,
        1300.0, 1301.0, 1302.0, 1303.0, 1304.0, 1305.0, 1306.0, 1307.0, 1308.0,
        1309.0, 1310.0, 1311.0, 1312.0, 1313.0, 1314.0, 1315.0, 1316.0, 1317.0,
        1318.0, 1319.0, 1320.0, 1321.0, 1322.0, 1323.0, 1324.0, 1325.0, 1326.0,
        1327.0, 1328.0, 1329.0, 1330.0, 1331.0, 1332.0, 1333.0, 1334.0, 1335.0,
        1336.0, 1337.0, 1338.0, 1339.0, 1340.0, 1341.0, 1342.0, 1343.0, 1344.0,
        1345.0, 1346.0, 1347.0, 1348.0, 1349.0, 1350.0, 1351.0, 1352.0, 1353.0,
        1354.0, 1355.0, 1356.0, 1357.0, 1358.0, 1359.0, 1360.0, 1361.0, 1362.0,
        1363.0, 1364.0, 1365.0, 1366.0, 1367.0, 1368.0, 1369.0 } ;

      static real_T pDataValues0[] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        22.265866170993892, 34.703656769447377, 51.379871427371825,
        64.7998926648577, 74.342860432362883, 25.255586651518737,
        37.142801334249512, 93.516249780897979, 51.7375875979402,
        43.9144069708858, 24.025362323048245, 6.5369067482381569,
        -0.74037179849661816, -0.86467698362369594, 2.303239901101922,
        -1.0623863950744012, -64.330494683276513, -38.591178552014519,
        12.469563246497177, 19.631700370648321, 20.056666680115306,
        25.504497984740915, 42.118947798250026, 70.807001775762728,
        79.115770398705564, 73.575664121804309, 28.034835532358233,
        13.891521363604578, 17.266119944738616, -24.056854614062232,
        -53.873339971836209, -37.483602093332046, -19.1308736588984,
        13.34157577549448, 62.749453987578775, 76.283542806046839,
        75.432022805061166, 75.412469487285165, 58.602127773234884,
        38.059168848199981, 34.900513163580804, 27.530156947151472,
        8.1090049260631076, 19.338625625366973, 30.833479173338432,
        27.240689573296734, 19.565297229172629, 19.451783405921777,
        23.213320025605451, 42.747910473880509, 43.783174098263565,
        28.5593346724789, 12.554655822848741, 4.3716367502769815,
        27.530380074696723, 39.58337927470248, 48.475687725900727,
        25.054253679708747, 12.816613806503069, 40.9444773865238,
        50.071339890824817, 60.023879142941212, 75.451459051117013,
        60.524522569456842, 52.967118172358532, 44.637535572816986,
        45.238411383745351, 45.845260095452566, 31.898362753954064,
        22.252358327468372, 26.795204610890853, 26.654706230857887,
        36.054010401575447, 50.672424213978893, 12.773075959673312,
        7.6957631287065338, 11.949587070586757, 44.041616720130428,
        54.115854353218367, 50.453862421338613, 41.592410357298036,
        37.090763194556182, 27.505844335961758, 8.0943204175790182,
        2.758541899462402, 35.206359040289037, 44.838114226462054,
        55.043759862644258, 56.219292574349808, 62.3845324576783,
        53.791436528510516, 44.488713872349713, 24.474566986082984,
        9.190135025685759, -112.76371437159462, -111.0639801710047,
        -99.136808441078458, -86.677438500569011, -73.823108191381252,
        -60.679863745721335, -47.086889882387908, -33.481532276075271,
        -19.723993563930392, -4.4335631013747552, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 27.648378965944829, 46.575461221330919,
        65.886506664091272, 85.955137721295472, 105.96559030478404,
        95.413720762568289, 96.025692228325, 81.480882343303961,
        49.386702368137527, -3.2178850714444089, 0.3123027908238003,
        8.1774438822504489, 35.077448768104169, 31.63507324822811,
        31.958328060134694, 40.359490694135253, 82.750702554668024,
        -3.0162022735695131, -73.269128552976753, -25.143177891127124,
        -89.347349450705053, -32.621000449195115, 1.3010310830395118,
        39.733317262107967, 30.155431284593607, 58.431703966023541,
        89.5771868792744, 103.48236341612579, 135.39081121183779,
        170.37195987718553, 180.99241019892881, 183.4017343419398,
        104.85071810536039, 163.47425188140747, 122.79253341048181,
        153.90517508140186, 147.92814800829046, 168.50497234616233,
        125.49885945531526, 121.72015817072558, 117.34807493588488,
        67.139915421447057, 52.17343783493839, 59.14232779981387,
        51.4617644608781, 65.798519148427317, 65.798639616950126,
        65.7987600861722, 65.798880556093536, 80.6657053052502,
        81.26433609728258, 104.47131272832708, 113.88926773511156,
        116.12802617957588, 102.71892603947543, 112.01205258182277,
        121.85888729570415, 108.03825200050525, 117.63531560143443,
        136.05705675714503, 164.28008684873654, 160.482805975043,
        129.92146217558431, 114.52127261856471, 98.215382948625859,
        81.151126260086187, 63.517285152601517, 88.505462416015362,
        105.83207634435183, 115.28871470269348, 125.24665246359064,
        109.1648555966989, 127.69717664598426, 111.4359200681847,
        121.17303483874433, 104.35099449233557, 95.722330706960577,
        77.7828829550025, 95.0169992504601, 95.0172605741984, 95.017521900264,
        95.0177832286569, 95.018044559377174, 86.073556887922791,
        67.939053499130765, 67.038338604977284, 31.146812647269471,
        46.787429442923148, 54.072167197829451, 70.060842177933466,
        60.971384516029836, 77.067152393670241, 110.75852258373267,
        94.74859385613054, 95.0920558145055, 86.8570304124676,
        61.251878847214655, 51.960214612934053, 50.925407363822757,
        49.904884552055691, 40.6386938836109, 105.27710182556045,
        48.400834861776708, 71.955508300571736, 63.48352120362248,
        62.933826790083089, 86.7889095646277, 95.294022081655129,
        104.20662282115956, 113.5748995851615, 123.48406060996356,
        125.47512538077429, 127.48987228082223, 164.30944926486779,
        133.25900462433296, 108.8023146968642, 127.30024831845419,
        93.278728382150533, 75.5654791425479, 39.854762635561691,
        29.77082677173528, 11.1902557408179, -7.0651070638345654,
        -1.1814154871501674, 78.641874029938322, 78.642049183630988,
        46.205979754952928, -2.9930109432394989, 66.54880383902622,
        82.078940683393029, 66.549079403111463, 42.699055250005422,
        65.178048214699913, 72.728308861790055, 72.728457472125527,
        41.572672097088684, 33.003937822958171, 31.999518774853481,
        0.3434029929066274, -14.290532740185206, -15.257732675437298,
        -22.90102434292081, -23.552350991365703, -17.751827917292236,
        -24.524420209103898, -60.221793904298579, -43.071747802202346,
        -58.362842762970658, -35.89961700974284, -30.321517030534505,
        -15.350099384468654, -10.673733244027757, 26.9438486574992,
        7.7765687387859028, -15.438242584420488, -36.943154111968546,
        -83.62051674790888, -97.296944984513814, -26.323452450512018,
        -13.044718507569234, -1.2484945352016095, -25.881351394326707,
        -23.980765697112115, -54.739430390834436, -21.44072452412443,
        -34.696156069116235, -30.181802413605773, -16.35872950701448,
        -1.6412443839351347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 8.91841904298935, 33.418200514345308,
        52.24050716132092, 72.014971965663662, 86.696048584815429,
        92.489927498313918, 99.818098245097673, 64.004800246038229,
        79.344462699514267, 80.651554606731111, 89.9677513390868,
        114.04165389867944, 68.992893066894, 71.250689381342212,
        58.385093432221908, 69.849526613972031, 77.049512374456413,
        84.823533892604232, 43.729934816709424, 54.871790170897256,
        33.521301037733608, 22.454598266760357, 49.183778091341757,
        82.763311583728637, 68.217734098437845, 41.040571930731524,
        41.040617227863741, 41.040662525151419, 41.040707822594563,
        41.040753120193152, 46.7128215225965, 58.340522296080422,
        47.531733961026596, 36.240973864091295, 18.969470851357833,
        -9.2019289901647952, -14.914352066348265, 5.53437318958838,
        -69.761174511131472, -80.19030856373513, -112.50936808317344,
        -78.692849054030617, -70.998467566521214, -65.9357575369878,
        -61.823800299052031, -41.1261647979638, -46.690069823354243,
        -33.074607865585776, -19.326414638599594, -4.0252543408212844, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 23.056696573425246, 42.472524320294326,
        61.836790314834289, 81.7700447479495, 101.63826115916341,
        122.15736709900747, 115.88669257192412, 47.592345484883246,
        103.06683401715667, 93.356332610018583, 75.566962070832645,
        35.555318779874007, 26.245048843864158, 16.710761750164078,
        11.775516133495797, 6.8646567678640711, -6.7051924757308408,
        -96.999451877733847, -98.049802974957913, -85.552644170653849,
        -72.650711029444, -59.499141202882107, -45.8722254582071,
        -32.244885173943189, -18.52515836958997, -3.2522761827809541, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 27.657069547583777, 46.590497594826225,
        65.908352952180067, 85.98442313736048, 106.0026639581699,
        126.49816060211859, 147.61647447697626, 84.91559836375734,
        85.439415231567949, 142.653798624481, 108.88614037957375,
        67.082178192194348, 101.06474861865169, 55.3281239661839,
        67.169578974450673, 68.485164340648254, 35.547724509782057,
        46.714561591056416, 46.918405697777558, 30.042059993654657,
        24.093946074066686, 57.4034796733002, 41.042541571561394,
        18.464769002550231, 34.693651799394665, 34.524615996495932,
        28.800913442450145, 39.559076288612061, 39.559118289141573,
        39.559160289809583, 39.559202290616064, 39.55924429156105,
        28.4967965350913, 44.711364851386911, 44.908869083239267,
        56.244221040450306, 23.401360840423468, 28.49694543680749,
        39.195085819920344, 39.19512703045595, 28.195289431758948,
        27.895938836307312, 33.031203474948541, -15.048327208760261,
        -40.187863272613711, -58.07868106985196, -64.34283806913561,
        -76.91458978623784, -89.0555319373391, -69.5484246422402,
        -78.210696308911778, -65.087432369540977, -44.5374634689397,
        -37.1054945244093, -25.967631373338889, -12.12939407806034,
        -0.69905203149479112, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.2135457462951216,
        17.320247241573657, 14.170921149214591, 28.645642634478534,
        22.666545704288474, 22.139260678504293, 33.154394953174325,
        51.911366893718061, 58.205164540106175, 58.167903777742005,
        52.621142251174831, 50.359689503307429, 46.870017900717471,
        52.573356782513173, 55.305023955616669, 50.619823638006537,
        48.771194309695147, 38.643677332744176, 27.541406462919529,
        23.739440806302834, 23.739455595681079, 23.739470385087547,
        23.739485174522258, 23.739499963985203, 47.595514513547087,
        32.624061333457369, 32.953674832708174, 8.8116048071237376,
        8.5268891051162861, 16.083602874314614, 23.739606081457449,
        23.739620871151235, 0.040961125218717032, -25.448208530243896,
        -90.894858954832785, -78.211872780915741, -65.088432365510187,
        -51.625157235644963, -38.120916383500678, -24.271390767131766,
        -10.536719559228398, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 27.658796209044848,
        46.593485110039524, 62.035719530300511, 45.265019537537114,
        45.729562399657929, 39.493094106116835, 14.545940188453349,
        14.545945667949759, 28.178173083102081, 20.631980714356672,
        15.263743038671189, 9.6783770905349424, 1.2502954360438769,
        11.853225533395301, 6.4711872537289352, 24.777296457955231,
        17.247578750508154, 11.939260868419577, 3.8730040751893711,
        11.511978137780657, 14.041760812110908, 16.66589776293084,
        24.777361614761293, 30.936417580124175, 40.718891171194251,
        36.888919204414591, 47.772871168729139, 43.843182456958473,
        22.176244354327331, 22.306758229920558, 32.575683125509435,
        33.290206237803048, 34.010346440106353, 24.036042075372574,
        20.615069692838251, 20.615080795811835, 27.743811872925264,
        57.238597196737643, 75.47172933803472, 59.93633410385219,
        45.704513051959019, 46.776727674632987, -11.123864630995206,
        -102.09712543575364, -89.756593039180217, -77.023961451617993,
        -63.893117916643554, -50.389688494895161, -36.850520918512551,
        -23.014412757628289, -8.57029938955149, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.112803837806394, 34.476819548366713,
        39.448983964313548, 48.456313687598431, 41.4346120692248,
        41.535749783448324, 68.621434883426815, 75.458337289811,
        61.694501917954035, 59.431670765801982, 59.470138767896529,
        66.487503938626574, 54.366256394106486, 36.15308966740858,
        40.766555473271993, 29.170462206393186, 29.321208721224661,
        25.33546120456521, 33.619235347476824, 29.776097240064804,
        25.744241177731364, 5.0055902381565556, 4.711618619795261,
        -48.690342020395249, -55.822605766384328, -72.38499850228699,
        -41.871271115316006, -32.625166694244825, -49.126064705425236,
        -38.9272886598042, -28.665632114716487, -14.043980641314032,
        -4.6442032615929385, -3.6311976130890615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.00225876448123,
        9.898415200666193, 21.620133313083656, 37.697935913185177,
        40.756596076573686, 51.409028365237774, 35.533339654839381,
        55.608320994274223, 21.807654324433674, 8.9680438174726067,
        14.042174676778924, 60.002154618590474, 45.162384791294137,
        44.639715534438643, 63.322950889479465, 53.938078956865446,
        20.615606114912257, 6.5399100735731208, 41.2843158556707,
        42.565045658402369, 28.967291781846932, -14.311736918856298,
        -10.624655024030789, -16.863826080147835, -57.851962816772136,
        -63.595217649583454, -52.957823405338978, -41.933049781181047,
        -28.570487121431317, -10.373598579509913, -6.1696714741749066,
        -1.7236999436670923, -2.9258144848260095, 0.415842269906097,
        3.5547769845844082, 27.033884500993427, 43.180942303021624,
        56.676417352759373, 41.435651325571065, 58.208934455183467,
        66.288451732182878, 62.509477608484595, 77.965034922172833,
        75.082271049102545, 73.4204413617621, 62.287388164982538,
        65.1522507938015, 51.016676898935835, 48.0795566866408,
        40.383976341846363, 45.38956231556449, 41.719005290877469,
        28.720552904384249, 15.264452700093029, 23.83387851621934,
        19.278900156878855, 5.9561059942072143, -2.9350538148525809,
        -27.085546796406774, -52.402261357801294, -48.8201419051464,
        -60.51016760740162, -53.759569889397994, -25.720517695108715,
        -40.220677957839754, -45.434750922611791, -34.821718612202275,
        -21.887611105528759, -3.9139648936540321, 1.2486112692620188,
        -1.0482093822612275, -0.0081794174574349784, 0.0, 25.751916767890094,
        44.85095206130314, 64.181197261093217, 74.574465817682267,
        57.441051193831846, 40.478163494529724, 48.703685203349252,
        54.951898045910191, 61.919899859482378, 62.481047860301217,
        89.035069525817491, 84.055457413015489, 68.077013170716285,
        48.956845671009255, 41.144684241003276, 55.253770291399007,
        29.16297629148092, 29.16299878600222, 24.621413767387036,
        15.46572181736669, 19.621211649793349, 28.28342760121539,
        28.283448732891841, 23.834334087859819, 1.4731336887741828,
        22.937699581839603, 27.137099401110106, 27.137118822815765,
        27.137138244564149, 27.137157666355257, 27.137177088189084,
        31.480011216856592, 44.774387989548195, 50.063514780890756,
        97.175071596294842, 78.660774167291265, 81.8069901416215,
        85.008769425306184, 35.682717177848652, 67.092371277393525,
        57.984604738105119, 53.534641507611674, 32.54760223433707,
        27.015001749929567, 37.412627208733973, 32.065480772369341,
        21.285026561156073, 10.473512614589717, 30.649601365741702,
        9.912647229146776, 9.45981737153512, 28.980229653089328,
        18.838937656237942, 28.38951023691952, -10.675943968528259,
        2.8898482562440413, 26.111173175905815, 30.6702408400568,
        30.670265774263495, 30.670290708532686, 16.606931275164445,
        25.562879190410037, 30.061171330905776, 20.793005239056775,
        11.427251253501726, -2.5009953340047479, 6.0910669572832621,
        -2.8782217157926149, -35.191601295892148, -44.974523248106905,
        -38.846691609617693, -30.045246051262851, -22.310176329921021,
        16.8524859442515, 44.643240895902785, 43.611408593499085,
        35.400164233057104, 39.809210673594571, 41.075307552449878,
        42.354009490631377, 51.121221950020008, 60.878267175655573,
        63.71503318120957, 49.86927753866587, 25.883718714376911,
        34.293884855950772, 34.632323640565495, 34.972557239568552,
        52.650600545010363, 40.766088087423618, 59.281046552729521,
        33.56583205792279, 33.729535350881278, 33.893724263638369,
        24.889108013774621, -11.052818377806313, 1.4208037156128932,
        5.6281353627091137, -23.203914356681025, -7.1569599175605418,
        4.157178680428629, 34.745130251865845, 35.271061492798076,
        39.797727414499853, 32.464537813197758, 45.071893351706883,
        54.532419127789566, 51.9500509211034, 40.198652155535534,
        54.066168449030961, 55.497556747764236, 38.478569793858661,
        25.023295558729576, 24.88943634730758, 24.756067051033124,
        11.084715515292281, 10.749127110207386, 23.577421479609693,
        27.852022813481906, 10.339835378895993, 10.020447157298124,
        0.97200888368856975, 42.752011039026563, 47.866393134007332,
        40.199136156164982, 36.352592474362339, 19.055039648471286,
        36.352646299653436, 27.85222265397897, 27.852243135300807,
        14.674384287187671, 14.385026432308305, 5.5639913664827265,
        13.633900579234117, 21.697974734085903, 25.7475116379415,
        25.747529088287287, 17.42129768749167, 21.334414428764511,
        25.338797153507812, 13.00067538419243, 12.735978935221912,
        24.533121791349217, 36.696747940529306, 20.855898160988129,
        12.648658506092072, -11.049852871830552, -18.301256997642856,
        -24.776251842174776, -0.71890804574564238, 19.551866581430236,
        22.968171912077846, 50.966371458988057, 49.644501593582177,
        44.081418189709673, 30.061166417260782, 30.376193764330374,
        42.361912939115, 31.491393550774877, 27.837817071685006,
        27.984385767392968, 32.13871082945208, 12.389345274801604,
        16.086429826630127, 23.743824971622573, 23.743839769372734,
        11.96570078151399, 15.592775924324885, 15.398231302200688,
        22.843659279958874, 30.534562344352981, 42.567884424020257,
        23.74394113537868, 8.1137352837848518, 23.227089875239443,
        3.9473792470785445, 37.893667914190942, 46.493273925465488,
        43.809968655468495, 4.4851180403958937, -18.507276097723679,
        -49.736413257814682, -42.86101665192065, -76.6147599768905,
        -66.693907239764812, -53.285870672294408, -39.779133495067221,
        -25.974553291281591, -12.121133503769745, 0.056892874169121761, 0.0, 0.0,
        0.0, 17.857095956994407, 38.823650387983136, 58.303202118892344,
        78.155141606456255, 70.81701640258899, 46.234446305815823,
        58.465455362775309, 53.156100534204604, 49.424650492014038,
        55.316741397405252, 76.86438915271637, 94.335235440542178,
        76.02004553963009, 53.359748623604325, 41.341169877630293,
        32.918213825960535, 28.578231466383684, 28.578253052689206,
        -6.7693838796937671, 18.72088841561515, 14.195064882203585,
        9.7086251199548581, 13.54265235336239, 5.00641116104927,
        12.82426609906484, 4.5413296451559111, -22.292700511470571,
        -49.737162861753511, 2.7356866950685403, 19.435921842362131,
        29.679632716478871, 44.170032538786323, 38.529757314105581,
        13.990840921903798, 20.98118124628667, 28.204922122123254,
        10.375991496219973, 20.860113047338515, 20.860124422096838,
        49.892260035968576, 40.530652954194515, 45.392815318728118,
        31.012272979226768, 35.273839327097392, 39.80088185794952,
        28.428671093355931, 20.502579356541887, 4.42954678325011,
        -11.004374553109448, 7.5193191769225374, 3.4980182713862082,
        10.527822898706685, 6.7763624506411615, 2.9475027750350105,
        6.255324133467778, -16.866593610575766, -72.354058339131655,
        -69.086558250474141, -55.77256969965881, -42.214013407361236,
        -28.555113134284564, -14.618010068285642, -0.69921132130693742, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        8.8818779108645831, 31.789392720644251, 50.56900963175201,
        70.191418153921731, 85.0345313233762, 56.156374976639384,
        61.212144527709057, 76.25847839993753, 61.879398684701712,
        58.084292320618971, 53.119743272043294, 55.136712427457461,
        61.317263221859946, 38.338450809192494, 51.721948178717362,
        48.745061104671628, 45.397713541977339, 14.969103510445191,
        5.9570995701893343, 5.6286757666700105, 26.439661791075693,
        -3.0708102571818148, -46.116859069059046, -50.64048638616854,
        -13.985266089067004, -10.410281628163691, -61.05610399981564,
        -63.605739135207706, -46.76287470168198, -12.350850281224414,
        0.19536774978694646, -1.3979835438916279, 0.10840201491997159,
        1.6068693383902044, 1.5188579593056197, 5.5749340661856177,
        9.7226780178453662, 9.9500040548224, 2.9221635856610488,
        5.5749380813542775, -1.2248674492226244, -5.8456169670752649,
        -14.5866341688007, -2.2374939545165828, -6.2185397925212609,
        -3.6334857688587054, -0.6992230144675865, 0.0, 0.18119277618757015,
        1.7306042821112302, 8.40028342256176, 29.48691152465668,
        45.366835720823921, 56.862562384331227, 35.880490719741964,
        22.947351518753596, 47.876783863128004, 69.023859774482361,
        71.964191989601673, 49.89165987542021, 25.520472258689995,
        22.442737502859654, 22.573989989450912, 29.517529581119032,
        47.452745653201163, 38.531226801245232, 50.633224710655341,
        48.784072803009366, 42.570711907119261, 19.806556817981107,
        19.692131673876741, 31.333231725400402, 39.609879674438076,
        40.384859490299682, 32.962122277383465, 41.56277375987969,
        33.961642378213327, 38.5237881319788, 30.5498699054239,
        26.440230177538869, 26.440248599540176, 22.191232941002674,
        22.067771642619753, 26.162837288749593, 13.543393177135961,
        21.578443948120317, 9.1054158033632326, 4.7126485713881143,
        -11.050827003355232, -18.302852936826163, -48.828841433986376,
        -29.482404287890535, -56.517313269513636, -24.629136504118421,
        -34.145913923950751, -54.945289066633237, -41.403152289199134,
        -27.700508475453208, -13.770062177281051, -0.35264643411789359, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        18.753037395030642, 39.445293483021906, 58.90345610468254,
        78.769373199509133, 98.554106464176314, 92.927334729686436,
        84.126529937260074, 39.527814760607207, 3.4021829594617059,
        3.1696674846277118, -63.150932784288074, -79.022040536309575,
        -65.901066890019663, -52.462996039978677, -38.973064242623224,
        -25.123755807185542, -11.322511175911359, 0.094945867417484675, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.71321053163318726,
        7.8749757727645466, 26.000371037466607, 46.027447641724514,
        44.938596734992124, 27.589441372344027, 12.692215448847913,
        2.5038546194926257, 14.412004391620371, 16.734053014364086,
        10.803081763002108, 30.110882488541833, 46.271813973578631,
        51.138989002424921, 59.000992232303638, 49.266636362408313,
        58.790501936662693, 35.598513581958976, 29.681627517176818,
        19.788308998281934, 9.501998865267602, 9.2941145913472347,
        29.193063845256265, 29.68170410026655, 26.700423791448564,
        16.549463377165274, 13.014881390769711, 12.842127710554797,
        19.43731848614636, 16.04027203668549, -23.085789041668207,
        -1.1104861366243586, 7.9858898211432123, 29.106630045191494,
        23.516661433506947, 23.797794913620269, 1.986311387085566,
        -41.232390982496945, -37.215220502372645, -44.015961591012285,
        -45.601663520083321, -21.294099802761473, -16.842784411928715,
        -12.328407133951986, -5.3974838266947769, -4.0169226279045791,
        -0.21257373696681955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.83214660960376685, 0.83214662718597587, 0.83214664476818623,
        0.83214666235039758, 2.0205732537911691, 6.0828103014991,
        8.47801157951356, 10.826669603044282, 15.849226550313636,
        24.264477244935797, 34.392245835805475, 16.281890193150456,
        -7.5926054461813024, -6.9054957924423208, -4.973144052454094,
        21.7374253142296, 40.756947330950759, 66.332620953671935,
        83.04444536981282, 85.02060041466892, 64.609484751833122,
        45.766073895496518, 33.658873066709475, 48.671270044256808,
        43.221118533444347, 40.736019880050605, 37.897735678076664,
        23.101365665678482, 3.896351953745834, 3.6454967493233896,
        21.841477825899698, 21.8414903147595, 21.841502803641148,
        21.841515292544653, 21.841527781470003, 40.534118411046933,
        26.258791437627377, 37.897983910897487, 30.855581127461893,
        35.101117059975969, 39.611879760286, 32.306072057518733,
        28.579688276427131, 36.882229910685446, 33.295243020634857,
        58.7547642234627, 60.8617265735908, 49.631009111543747,
        59.801568168269711, 33.899726168858059, 24.893459185935242,
        -15.393427079276051, -108.98547500340274, -96.955621717967986,
        -84.429216697378337, -71.480427453890513, -58.270099565764887,
        -44.661563271124635, -31.016025843051931, -17.262450617763893,
        -2.2304403876681818, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 13.388514823062076, 36.013624814854317, 55.307354413849758,
        43.839968858849986, 52.758746225630723, 54.89815224375559,
        55.490157430045173, 51.453877146636955, 42.221092588135576,
        50.697138924081635, 39.607198028811133, 26.850394152685144,
        30.669701752937279, 6.4837393474545779, 6.2558961571312866,
        2.57375204562866, -0.94169784431224435, 2.1596431109452023,
        5.203319712862541, -15.73163871873466, -12.31457803099226,
        -11.814392116347113, -11.285579660594108, -22.034263594138334,
        -49.279531877101846, -38.302224016725077, -25.170493520981534,
        -14.952104131168184, -5.7713434372965482, 0.0, 0.0, 0.0 } ;

      rtDW.FromWorkspace_PWORK.TimePtr = (void *) pTimeValues0;
      rtDW.FromWorkspace_PWORK.DataPtr = (void *) pDataValues0;
      rtDW.FromWorkspace_IWORK.PrevIndex = 0;
    }

    /* InitializeConditions for TransferFcn: '<S377>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S1>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_b = 0.0;

    /* InitializeConditions for TransferFcn: '<S2>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_j = 0.0;

    /* InitializeConditions for TransferFcn: '<S5>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_n = 0.0;

    /* InitializeConditions for TransferFcn: '<S7>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_f = 0.0;

    /* InitializeConditions for TransferFcn: '<S8>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_jk = 0.0;

    /* InitializeConditions for TransferFcn: '<S16>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_p = 0.0;

    /* InitializeConditions for TransferFcn: '<S17>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_pv = 0.0;

    /* InitializeConditions for TransferFcn: '<S19>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_nf = 0.0;

    /* InitializeConditions for SimscapeExecutionBlock: '<S380>/STATE_1' */
    tmp = false;
    if (tmp) {
      is = strcmp("ode14x", rtsiGetSolverName(&rtM->solverInfo));
      if (is != 0) {
        msg = solver_mismatch_message("ode14x", rtsiGetSolverName
          (&rtM->solverInfo));
        rtmSetErrorStatus(rtM, msg);
      }
    }

    /* End of InitializeConditions for SimscapeExecutionBlock: '<S380>/STATE_1' */

    /* InitializeConditions for TransferFcn: '<S377>/Transfer Fcn3' */
    rtX.TransferFcn3_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S377>/Transfer Fcn4' */
    rtX.TransferFcn4_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S11>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_fj = 0.0;

    /* InitializeConditions for TransferFcn: '<S377>/Transfer Fcn1' */
    rtX.TransferFcn1_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S377>/Transfer Fcn2' */
    rtX.TransferFcn2_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S7>/Transfer Fcn1' */
    rtX.TransferFcn1_CSTATE_e = 0.0;

    /* InitializeConditions for TransferFcn: '<S273>/Transfer Fcn' */
    rtX.TransferFcn_CSTATE_o = 0.0;

    /* InitializeConditions for Integrator: '<S12>/Integrator' */
    rtX.Integrator_CSTATE = 26.0;

    /* InitializeConditions for Integrator: '<S379>/Integrator' */
    rtX.Integrator_CSTATE_h = 0.0;

    /* InitializeConditions for Integrator: '<S340>/Integrator' */
    rtX.Integrator_CSTATE_l = 0.0;

    /* InitializeConditions for Integrator: '<S341>/Integrator1' */
    rtX.Integrator1_CSTATE = 0.0;

    /* InitializeConditions for Integrator: '<S341>/Integrator' */
    rtX.Integrator_CSTATE_g = 0.0;

    /* InitializeConditions for Integrator: '<S343>/Integrator2' */
    rtX.Integrator2_CSTATE = 0.0;

    /* InitializeConditions for Integrator: '<S343>/Integrator' */
    rtX.Integrator_CSTATE_m = 0.0;

    /* InitializeConditions for Memory: '<S279>/last_x' */
    rtDW.last_x_PreviousInput = 26.0;

    /* InitializeConditions for Memory: '<S279>/LastPcov' */
    rtDW.LastPcov_PreviousInput = 1.0461846602238614;

    /* Root-level InitSystemMatrices */
    {
      static int_T modelMassMatrixIr[157] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
        9, 10, 11, 12, 11, 12, 13, 14, 13, 14, 15, 16, 15, 16, 19, 17, 18, 20,
        22, 21, 23, 25, 24, 26, 28, 27, 29, 30, 31, 30, 31, 32, 34, 32, 33, 34,
        32, 33, 36, 38, 37, 43, 39, 42, 40, 41, 35, 62, 44, 48, 44, 45, 52, 44,
        49, 44, 50, 54, 53, 59, 55, 58, 56, 57, 44, 44, 46, 44, 47, 51, 63, 64,
        60, 61, 67, 65, 66, 65, 66, 68, 69, 70, 69, 70, 73, 71, 72, 71, 72, 76,
        74, 75, 74, 75, 77, 79, 77, 79, 80, 78, 77, 79, 80, 81, 83, 81, 83, 84,
        82, 81, 83, 84, 88, 92, 88, 89, 88, 93, 88, 94, 85, 87, 85, 86, 87, 85,
        86, 88, 88, 90, 88, 91, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649,
        650, 651, 652, 653 };

      static int_T modelMassMatrixJc[655] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11,
        13, 15, 17, 19, 21, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 40, 42, 44, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61,
        63, 64, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 80, 81, 82, 83, 84,
        85, 86, 88, 90, 91, 93, 95, 96, 98, 100, 101, 103, 105, 107, 110, 111,
        114, 116, 119, 120, 123, 125, 127, 129, 131, 133, 136, 138, 139, 141,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157 };

      static real_T modelMassMatrixPr[157] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };

      (void) memcpy(rtMassMatrix.ir, modelMassMatrixIr,
                    157*sizeof(int_T));
      (void) memcpy(rtMassMatrix.jc, modelMassMatrixJc,
                    655*sizeof(int_T));
      (void) memcpy(rtMassMatrix.pr, modelMassMatrixPr,
                    157*sizeof(real_T));
    }
  }
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
